/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.violetlib.aqua.AquaInternalFrameUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;

public class AquaTitleBar {
    private static final int sMaxIconWidth = 15;
    private static final int sMaxIconHeight = 15;
    private static final int sAfterIconPad = 5;
    protected final AquaUIPainter titleBarPainter = AquaPainting.create();
    protected final JInternalFrame frame;
    protected final AquaUIPainter.TitleBarWidget widget;
    protected final TitleBarLayoutConfiguration layoutConfiguration;
    protected final int titleBarHeight;
    private int width;
    private TitleBarLayout titleBarLayout;
    private Color selectedTextColor;
    private Color notSelectedTextColor;

    public AquaTitleBar(JInternalFrame frame, AquaUIPainter.TitleBarWidget widget) {
        this.frame = frame;
        this.widget = widget;
        this.layoutConfiguration = new TitleBarLayoutConfiguration(this.widget);
        LayoutInfo layoutInfo = this.titleBarPainter.getLayoutInfo().getLayoutInfo(this.layoutConfiguration);
        this.titleBarHeight = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
    }

    public void setWidth(int w) {
        if (w != this.width) {
            this.width = w;
            this.invalidateLayout();
        }
    }

    public void invalidateLayout() {
        this.titleBarLayout = null;
    }

    public int getTitleBarHeight() {
        return this.titleBarHeight;
    }

    public int getWhichButtonHit(int x, int y) {
        TitleBarLayout layout = this.getTitleBarLayout();
        if (layout.closeButtonBounds.contains(x, y)) {
            return 0;
        }
        if (layout.minimizeButtonBounds.contains(x, y)) {
            return 1;
        }
        if (layout.resizeButtonBounds.contains(x, y)) {
            return 2;
        }
        return -1;
    }

    public boolean getWithinRolloverArea(int x, int y) {
        if (y < 0 || y >= this.titleBarHeight) {
            return false;
        }
        TitleBarLayout layout = this.getTitleBarLayout();
        return x >= layout.buttonAreaLeft && x <= layout.buttonAreaRight;
    }

    protected TitleBarLayout getTitleBarLayout() {
        if (this.titleBarLayout == null) {
            this.titleBarLayout = this.createTitleBarLayout();
        }
        return this.titleBarLayout;
    }

    protected TitleBarLayout createTitleBarLayout() {
        TitleBarLayout result = new TitleBarLayout();
        result.buttonAreaLeft = Integer.MAX_VALUE;
        result.buttonAreaRight = 0;
        AquaUILayoutInfo uiLayoutInfo = this.titleBarPainter.getLayoutInfo();
        for (AquaUIPainter.TitleBarButtonWidget bw : Arrays.asList(AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX, AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX, AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX)) {
            Insetter s = uiLayoutInfo.getTitleBarButtonInsets(this.layoutConfiguration, bw);
            Rectangle bounds = s.apply(this.width, this.titleBarHeight);
            result.buttonAreaLeft = Math.min(result.buttonAreaLeft, bounds.x);
            result.buttonAreaRight = Math.max(result.buttonAreaRight, bounds.x + bounds.width);
            if (bw == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
                result.closeButtonBounds = bounds;
                continue;
            }
            if (bw == AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX) {
                result.minimizeButtonBounds = bounds;
                continue;
            }
            if (bw != AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX) continue;
            result.resizeButtonBounds = bounds;
        }
        Insetter s = this.titleBarPainter.getLayoutInfo().getTitleBarLabelInsets(this.layoutConfiguration);
        if (s != null) {
            result.titleBounds = s.apply(this.width, this.titleBarHeight);
        }
        return result;
    }

    public void setColors(Color inSelectedTextColor, Color inNotSelectedTextColor) {
        this.selectedTextColor = inSelectedTextColor;
        this.notSelectedTextColor = inNotSelectedTextColor;
    }

    public void paint(Graphics g) {
        TitleBarConfiguration tg = this.getConfiguration();
        this.titleBarPainter.configure(this.width, this.titleBarHeight);
        this.titleBarPainter.getPainter(tg).paint(g, 0.0f, 0.0f);
        this.paintTitleContents(g);
    }

    public Rectangle getButtonArea() {
        TitleBarLayout layout = this.getTitleBarLayout();
        return new Rectangle(layout.buttonAreaLeft, 0, layout.buttonAreaRight - layout.buttonAreaLeft, this.titleBarHeight);
    }

    protected TitleBarConfiguration getConfiguration() {
        AquaUIPainter.State state = this.frame.isSelected() ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
        AquaUIPainter.State closeButtonState = this.getButtonState(0, this.frame.isClosable());
        AquaUIPainter.State minimizeButtonState = this.getButtonState(1, this.frame.isIconifiable());
        AquaUIPainter.State resizeButtonState = this.getButtonState(2, this.frame.isMaximizable());
        TitleBarConfiguration.ResizeAction resizeAction = this.getResizeAction(this.frame);
        boolean isDirty = this.isDirty();
        return new TitleBarConfiguration(this.widget, state, closeButtonState, minimizeButtonState, resizeButtonState, resizeAction, isDirty);
    }

    protected AquaUIPainter.State getButtonState(int buttonType, boolean isEnabled) {
        AquaInternalFrameUI ui = (AquaInternalFrameUI)this.frame.getUI();
        int buttonPressedIndex = ui.getWhichButtonPressed();
        boolean overButton = ui.getMouseOverPressedButton();
        boolean rollover = ui.getRollover();
        boolean frameSelected = this.frame.isSelected() || this.widget == AquaUIPainter.TitleBarWidget.UTILITY_WINDOW;
        boolean isActive = rollover || frameSelected;
        return this.getState(buttonPressedIndex == buttonType && overButton, rollover, isActive, isEnabled);
    }

    protected AquaUIPainter.State getState(boolean pressed, boolean rollover, boolean active, boolean enabled) {
        if (!enabled) {
            return AquaUIPainter.State.DISABLED;
        }
        if (!active) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (pressed) {
            return AquaUIPainter.State.PRESSED;
        }
        if (rollover) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected void paintTitleContents(Graphics g) {
        TitleBarLayout layout = this.getTitleBarLayout();
        Rectangle titleBounds = layout.titleBounds;
        if (titleBounds == null) {
            return;
        }
        boolean isSelected = this.frame.isSelected();
        Font f = g.getFont();
        g.setFont(this.frame.getFont());
        FontMetrics fm = g.getFontMetrics();
        int baseline = titleBounds.y + (titleBounds.height + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
        int iconWidth = this.getIconWidth();
        if (iconWidth > 0) {
            iconWidth += 5;
        }
        int availTextWidth = titleBounds.width - iconWidth;
        String text = this.frame.getTitle();
        int totalTextWidth = 0;
        int startXPosition = titleBounds.x;
        boolean wasTextShortened = false;
        if (text != null && !text.equals("")) {
            totalTextWidth = SwingUtilities.computeStringWidth(fm, text);
            String clipString = "\u2026";
            if (totalTextWidth > availTextWidth) {
                int nextCharWidth;
                int nChars;
                wasTextShortened = true;
                totalTextWidth = SwingUtilities.computeStringWidth(fm, "\u2026");
                for (nChars = 0; nChars < text.length() && totalTextWidth + (nextCharWidth = fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
                    totalTextWidth += nextCharWidth;
                }
                text = text.substring(0, nChars) + "\u2026";
            }
            if (!wasTextShortened && (startXPosition = (titleBounds.width - (totalTextWidth + iconWidth)) / 2) < titleBounds.x) {
                startXPosition = titleBounds.x;
            }
            if (isSelected || this.widget == AquaUIPainter.TitleBarWidget.UTILITY_WINDOW) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            AquaUtils.drawString(this.frame, g, text, startXPosition + iconWidth, baseline);
            g.setFont(f);
        }
        int iconYPosition = titleBounds.y + (titleBounds.height - this.getIconHeight()) / 2;
        this.paintTitleIcon(g, startXPosition, iconYPosition);
    }

    protected void paintTitleIcon(Graphics g, int x, int y) {
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon == null) {
            return;
        }
        if (icon instanceof ImageIcon && (icon.getIconWidth() > 15 || icon.getIconHeight() > 15)) {
            Image img = ((ImageIcon)icon).getImage();
            ((ImageIcon)icon).setImage(img.getScaledInstance(15, 15, 4));
        }
        icon.paintIcon(this.frame, g, x, y);
    }

    protected int getIconWidth() {
        int width = 0;
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null) {
            width = Math.min(icon.getIconWidth(), 15);
        }
        return width;
    }

    protected int getIconHeight() {
        int height = 0;
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null) {
            height = Math.min(icon.getIconHeight(), 15);
        }
        return height;
    }

    protected TitleBarConfiguration.ResizeAction getResizeAction(JInternalFrame frame) {
        if (frame.isMaximizable()) {
            return frame.isMaximum() ? TitleBarConfiguration.ResizeAction.FULL_SCREEN_EXIT : TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER;
        }
        return TitleBarConfiguration.ResizeAction.ZOOM_ENTER;
    }

    protected boolean isDirty() {
        Object dirty = this.frame.getClientProperty("windowModified");
        return Boolean.TRUE.equals(dirty);
    }

    private class TitleBarLayout {
        int buttonAreaLeft;
        int buttonAreaRight;
        Rectangle titleBounds;
        Rectangle closeButtonBounds;
        Rectangle minimizeButtonBounds;
        Rectangle resizeButtonBounds;

        private TitleBarLayout() {
        }
    }
}

