/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaToolBarUI
extends BasicToolBarUI
implements SwingConstants {
    private static AquaUtils.RecyclableSingleton<ToolBarBorder> toolBarBorder = new AquaUtils.RecyclableSingletonFromDefaultConstructor<ToolBarBorder>(ToolBarBorder.class);
    private LayoutManager originalLayoutManager;

    public static Border getToolBarBorder() {
        return toolBarBorder.get();
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaToolBarUI();
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.originalLayoutManager = this.toolBar.getLayout();
        if (this.originalLayoutManager instanceof UIResource) {
            this.toolBar.setLayout(new AquaToolBarLayout());
        }
        this.toolBar.setFloatable(false);
    }

    @Override
    protected void uninstallDefaults() {
        LayoutManager lm = this.toolBar.getLayout();
        if (lm instanceof AquaToolBarLayout) {
            this.toolBar.setLayout(this.originalLayoutManager);
        }
        super.uninstallDefaults();
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        RootPaneContainer window = super.createFloatingWindow(toolbar);
        window.getRootPane().putClientProperty("Window.style", "small");
        return window;
    }

    public static boolean isTallFormat(JToolBar tb) {
        int count = tb.getComponentCount();
        for (int i = 0; i < count; ++i) {
            AbstractButton b;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !AquaToolBarUI.isTallFormat(b = (AbstractButton)c)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTallFormat(AbstractButton b) {
        AquaButtonBorder bb;
        LayoutConfiguration g;
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder && (g = (bb = (AquaButtonBorder)border).getLayoutConfiguration(b)) instanceof ButtonLayoutConfiguration) {
            ButtonLayoutConfiguration bg = (ButtonLayoutConfiguration)g;
            AquaUIPainter.ButtonWidget bw = bg.getButtonWidget();
            return bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM;
        }
        return false;
    }

    @Override
    public final void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AquaUtils.fillRect(g, c, 3);
        }
        this.paint(g, c);
    }

    @Override
    protected void paintDragWindow(Graphics g) {
        super.paintDragWindow(g);
        if (this.dragWindow.getOrientation() == this.toolBar.getOrientation()) {
            this.toolBar.paint(g);
        }
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new AquaDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point p) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(p);
        }
    }

    private class AquaToolBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        GroupLayout gl;
        GroupLayout.SequentialGroup major;
        GroupLayout.ParallelGroup minor;
        boolean isConfigured;

        AquaToolBarLayout() {
        }

        private void configure() {
            if (!this.isConfigured) {
                this.isConfigured = true;
            }
            this.gl = new GroupLayout(AquaToolBarUI.this.toolBar);
            this.major = this.gl.createSequentialGroup();
            this.minor = this.gl.createParallelGroup(GroupLayout.Alignment.CENTER);
            int count = AquaToolBarUI.this.toolBar.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = AquaToolBarUI.this.toolBar.getComponent(i);
                if (i > 0) {
                    this.major.addGap(5);
                }
                this.major.addComponent(c);
                this.minor.addComponent(c);
            }
            if (AquaToolBarUI.this.toolBar.getOrientation() == 0) {
                this.gl.setHorizontalGroup(this.major);
                this.gl.setVerticalGroup(this.minor);
            } else {
                this.gl.setVerticalGroup(this.major);
                this.gl.setHorizontalGroup(this.minor);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.invalidateLayout(AquaToolBarUI.this.toolBar);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.invalidateLayout(AquaToolBarUI.this.toolBar);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.invalidateLayout(AquaToolBarUI.this.toolBar);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            this.configure();
            return this.gl.preferredLayoutSize(target);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            this.configure();
            return this.gl.minimumLayoutSize(target);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            this.configure();
            return this.gl.maximumLayoutSize(target);
        }

        @Override
        public void layoutContainer(Container target) {
            this.configure();
            this.gl.layoutContainer(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            this.configure();
            return this.gl.getLayoutAlignmentX(target);
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            this.configure();
            return this.gl.getLayoutAlignmentY(target);
        }

        @Override
        public void invalidateLayout(Container target) {
            this.isConfigured = false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("orientation")) {
                this.isConfigured = false;
            }
        }
    }

    protected class AquaDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps;

        public AquaDockingListener(JToolBar t) {
            super(AquaToolBarUI.this, t);
            this.pressedInBumps = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle bumpRect = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int x = AquaUtils.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                bumpRect.setBounds(x, 0, 14, this.toolBar.getSize().height);
            } else {
                bumpRect.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (bumpRect.contains(e.getPoint())) {
                this.pressedInBumps = true;
                Point dragOffset = e.getPoint();
                if (!AquaUtils.isLeftToRight(this.toolBar)) {
                    dragOffset.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                AquaToolBarUI.this.setDragOffset(dragOffset);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.pressedInBumps) {
                super.mouseDragged(e);
            }
        }
    }

    static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        ToolBarBorder() {
        }

        protected void fillHandle(Graphics g, int x1, int y1, int x2, int y2, boolean horizontal) {
            g.setColor(UIManager.getColor("ToolBar.borderHandleColor"));
            if (horizontal) {
                int h = y2 - y1 - 2;
                g.fillRect(x1 + 2, y1 + 1, 1, h);
                g.fillRect(x1 + 5, y1 + 1, 1, h);
            } else {
                int w = x2 - x1 - 2;
                g.fillRect(x1 + 1, y1 + 2, w, 1);
                g.fillRect(x1 + 1, y1 + 5, w, 1);
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean horizontal;
            g.translate(x, y);
            if (c.isOpaque()) {
                AquaUtils.fillRect(g, c, 3, 0, 0, w - 1, h - 1);
            }
            Color oldColor = g.getColor();
            JToolBar jtb = (JToolBar)c;
            ComponentOrientation orient = jtb.getComponentOrientation();
            boolean bl = horizontal = jtb.getOrientation() == 0;
            if (jtb.isFloatable()) {
                if (horizontal) {
                    if (orient.isLeftToRight()) {
                        this.fillHandle(g, 2, 2, 10, h - 2, true);
                    } else {
                        this.fillHandle(g, w - 10, 2, w - 2, h - 2, true);
                    }
                } else {
                    this.fillHandle(g, 2, 2, w - 2, 10, false);
                }
            }
            g.setColor(oldColor);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets borderInsets = new Insets(5, 5, 5, 5);
            return this.getBorderInsets(c, borderInsets);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets margin;
            JToolBar tb = (JToolBar)c;
            boolean isTallFormat = AquaToolBarUI.isTallFormat(tb);
            borderInsets.left = 4;
            borderInsets.right = 4;
            borderInsets.top = 4;
            int n = borderInsets.bottom = isTallFormat ? 0 : 4;
            if (tb.isFloatable()) {
                if (tb.getOrientation() == 0) {
                    borderInsets.left = 12;
                } else {
                    borderInsets.top = 12;
                }
            }
            if ((margin = tb.getMargin()) != null) {
                borderInsets.left += margin.left;
                borderInsets.top += margin.top;
                borderInsets.right += margin.right;
                borderInsets.bottom += margin.bottom;
            }
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

