/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaDragRecognitionSupport;
import org.violetlib.aqua.AquaTreeUI;

public class AquaTreeMouseBehavior
extends MouseInputAdapter
implements AquaDragRecognitionSupport.BeforeDrag {
    protected JTree tree;
    protected AquaTreeUI ui;
    private boolean mouseReleaseDeselects;
    private boolean mouseDragSelects;
    private boolean isMouseReleaseStartsEditing;
    private boolean isDragRecognitionOngoing;

    public AquaTreeMouseBehavior(JTree tree) {
        this.tree = tree;
        this.ui = (AquaTreeUI)tree.getUI();
    }

    @Override
    public void dragStarting(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(e) && !e.isConsumed()) {
            boolean isRowAtIndexSelected;
            TreePath path;
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            this.ui.completeEditing();
            if (this.tree.isRequestFocusEnabled()) {
                this.tree.requestFocusInWindow();
            }
            if (this.ui.isLocationInExpandControl(path = this.getMouseClickedClosestPathForLocation(this.tree, e.getX(), e.getY()), e.getX(), e.getY())) {
                this.ui.checkForClickInExpandControl(path, e.getX(), e.getY());
                return;
            }
            int index = this.tree.getRowForPath(path);
            this.mouseDragSelects = false;
            this.mouseReleaseDeselects = false;
            this.isMouseReleaseStartsEditing = true;
            this.isDragRecognitionOngoing = false;
            if (!(index == -1 || (isRowAtIndexSelected = this.tree.isRowSelected(index)) && e.isPopupTrigger())) {
                int anchorIndex = this.tree.getRowForPath(this.tree.getAnchorSelectionPath());
                if ((e.getModifiersEx() & 0x1900) == 256) {
                    if (isRowAtIndexSelected) {
                        this.tree.removeSelectionInterval(index, index);
                    } else {
                        this.tree.addSelectionInterval(index, index);
                        this.mouseDragSelects = true;
                        this.isMouseReleaseStartsEditing = false;
                    }
                } else if ((e.getModifiersEx() & 0x1840) == 64 && anchorIndex != -1) {
                    this.tree.setSelectionInterval(anchorIndex, index);
                    this.ui.setLeadSelectionPath(path);
                    this.mouseDragSelects = true;
                    this.isMouseReleaseStartsEditing = false;
                } else if ((e.getModifiersEx() & 0x140) == 0) {
                    if (isRowAtIndexSelected) {
                        if (this.tree.getDragEnabled()) {
                            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mousePressed(e);
                            this.mouseReleaseDeselects = false;
                            this.mouseDragSelects = false;
                        } else {
                            this.mouseReleaseDeselects = this.tree.isFocusOwner();
                        }
                    } else {
                        this.tree.setSelectionInterval(index, index);
                        if (this.tree.getDragEnabled() && this.ui.getPathBounds(this.tree, path).contains(e.getPoint())) {
                            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mousePressed(e);
                            this.mouseReleaseDeselects = false;
                            this.mouseDragSelects = false;
                            this.isMouseReleaseStartsEditing = false;
                        } else {
                            this.mouseDragSelects = true;
                            this.isMouseReleaseStartsEditing = false;
                        }
                    }
                    this.ui.setAnchorSelectionPath(path);
                    this.ui.setLeadSelectionPath(path);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(e) && !e.isConsumed()) {
            int index;
            if (this.tree.getDragEnabled() && this.isDragRecognitionOngoing) {
                AquaDragRecognitionSupport.mouseDragged(e, this);
            }
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            TreePath leadPath = this.ui.getClosestPathForLocation(this.tree, e.getX(), e.getY());
            if (this.tree.getCellEditor() != null) {
                this.tree.getCellEditor().isCellEditable(new EventObject(this));
            }
            this.mouseReleaseDeselects = false;
            this.isMouseReleaseStartsEditing = false;
            if (this.mouseDragSelects && (index = this.tree.getRowForPath(leadPath)) != -1) {
                Rectangle cellBounds = this.tree.getRowBounds(index);
                this.tree.scrollRectToVisible(cellBounds);
                TreePath anchorPath = this.tree.getAnchorSelectionPath();
                int anchorIndex = this.tree.getRowForPath(anchorPath);
                if (this.tree.getSelectionModel().getSelectionMode() == 1) {
                    this.tree.setSelectionInterval(index, index);
                } else {
                    if (anchorIndex < index) {
                        this.tree.setSelectionInterval(anchorIndex, index);
                    } else {
                        this.tree.setSelectionInterval(index, anchorIndex);
                    }
                    this.ui.setAnchorSelectionPath(anchorPath);
                    this.ui.setLeadSelectionPath(leadPath);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.isMouseReleaseStartsEditing = false;
        if (this.tree.getCellEditor() != null) {
            this.tree.getCellEditor().isCellEditable(new EventObject(this));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(e) && !e.isConsumed()) {
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            TreePath path = this.getMouseClickedClosestPathForLocation(this.tree, e.getX(), e.getY());
            if (this.startEditingOnRelease(path, e, e)) {
                return;
            }
            this.mouseDragSelects = false;
            if (this.mouseReleaseDeselects) {
                int index = this.tree.getRowForPath(path);
                this.tree.setSelectionInterval(index, index);
            }
        }
        if (this.tree.isRequestFocusEnabled()) {
            this.tree.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isMouseReleaseStartsEditing = false;
    }

    private boolean startEditingOnRelease(TreePath path, MouseEvent event, MouseEvent releaseEvent) {
        if (this.isMouseReleaseStartsEditing) {
            return this.ui.startEditing(path, event);
        }
        return false;
    }

    private TreePath getMouseClickedClosestPathForLocation(JTree tree, int x, int y) {
        TreePath path = this.ui.getClosestPathForLocation(tree, x, y);
        if (path == null) {
            return null;
        }
        Rectangle pathBounds = this.ui.getPathBounds(tree, path);
        if (y > pathBounds.y + pathBounds.height) {
            return null;
        }
        return path;
    }
}

