/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaTableUI;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.TreeTableCellRenderer;
import org.violetlib.treetable.ui.BasicTreeTableUI;

public class AquaTreeTableUI
extends BasicTreeTableUI {
    protected MyHandler handler = new MyHandler();

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return this.handler;
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree tree = super.createAndConfigureTree();
        tree.setFocusable(false);
        tree.putClientProperty("Component.hasFocusDelegate", this.treeTable);
        tree.putClientProperty("JTree.paintSelectionBackground", false);
        return tree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable table = super.createAndConfigureTable();
        table.setFocusable(false);
        table.putClientProperty("Component.hasFocusDelegate", this.treeTable);
        return table;
    }

    @Override
    protected void finishConfiguration(JTree tree, JTable table) {
        tree.putClientProperty("JTree.selectionRepainter", table);
    }

    @Override
    protected TreeTableCellRenderer createFocusRenderer() {
        return null;
    }

    @Override
    protected boolean hasTreeHandle(TreeTable treeTable, TreePath path) {
        return !treeTable.isLeaf(path);
    }

    @Override
    protected List<String> getProperties() {
        ArrayList<String> props = new ArrayList<String>(super.getProperties());
        props.add("Frame.active");
        return props;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeListener();
    }

    public void repaintSelection() {
        TableUI tableUI = this.getTable().getUI();
        if (tableUI instanceof SelectionRepaintable) {
            SelectionRepaintable sp = (SelectionRepaintable)((Object)tableUI);
            sp.repaintSelection();
        }
    }

    protected void handleDoubleClick(TreePath path) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color arc = this.treeTable.getAlternateRowColor();
        if (arc == null || arc instanceof UIResource) {
            JTable t = this.getTable();
            if (t.getUI() instanceof AquaTableUI && AquaTableUI.isStriped(t)) {
                this.treeTable.setAlternateRowColor(UIManager.getColor("Table.oddRowBackground"));
            } else {
                this.treeTable.setAlternateRowColor(null);
            }
        }
        super.paint(g, c);
    }

    protected class MyHandler
    extends BasicTreeTableUI.Handler {
        protected MyHandler() {
            super(AquaTreeTableUI.this);
        }

        @Override
        protected void focusChanged() {
            AquaTreeTableUI.this.repaintSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if ("Frame.active".equals(evt.getPropertyName())) {
                AquaTreeTableUI.this.getTree().putClientProperty("Frame.active", evt.getNewValue());
                AquaTreeTableUI.this.getTable().putClientProperty("Frame.active", evt.getNewValue());
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            AquaTreeTableUI.this.handler.propertyChange(event);
        }
    }
}

