/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaTreeMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.aqua.TreeSelectionBoundsTracker;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaTreeUI
extends BasicTreeUI
implements SelectionRepaintable {
    public static final String IS_CELL_FILLED_KEY = "JTree.isCellFilled";
    public static final String QUAQUA_IS_CELL_FILLED_KEY = "Quaqua.Tree.isCellFilled";
    public static final String TREE_STYLE_KEY = "JTree.style";
    public static final String QUAQUA_TREE_STYLE_KEY = "Quaqua.Tree.style";
    protected static final Color TRANSPARENT_COLOR = new Color(0, true);
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 0;
    private final Color[] stripes;
    private final PropertyChangeListener lineStyleListener = new LineListener();
    private final FocusListener editingComponentFocusListener = new EditingComponentFocusListener();
    private Component editorFocusOwner;
    protected TreePath fTrackingPath;
    protected boolean fIsPressed = false;
    protected boolean fIsInBounds = false;
    protected float fAnimationTransition = -1.0f;
    protected TreeArrowMouseInputHandler fMouseHandler;
    private boolean ignoreLAChange;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isCellFilled;
    protected boolean isSideBar;
    protected boolean isStriped;
    protected boolean shouldPaintSelection;
    protected boolean isActive;
    protected boolean isFocused;
    protected Color foreground;
    protected Color selectionBackground;
    protected Color selectionForeground;
    private Font oldCellRendererFont;
    private Icon oldCellRendererIcon;
    private Icon oldCellRendererDisabledIcon;
    private SidebarVibrantEffects sidebarVibrantEffects;
    private static DropTargetListener defaultDropTargetListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTreeUI();
    }

    public AquaTreeUI() {
        this.stripes = new Color[]{UIManager.getColor("Tree.evenRowBackground"), UIManager.getColor("Tree.oddRowBackground")};
    }

    public boolean isSideBar() {
        return this.isSideBar;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object lineStyleFlag = c.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(lineStyleFlag);
        c.addPropertyChangeListener(this.lineStyleListener);
    }

    @Override
    protected void completeUIInstall() {
        this.updateProperties();
        super.completeUIInstall();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JComponent.isCellContainer", true);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void updateProperties() {
        if (this.tree != null) {
            this.isCellFilled = Boolean.TRUE.equals(AquaUtils.getBooleanProperty(this.tree, IS_CELL_FILLED_KEY, QUAQUA_IS_CELL_FILLED_KEY));
            String style = this.getStyleProperty();
            boolean newIsSidebar = style != null && (style.equals("sideBar") || style.equals("sourceList"));
            boolean bl = this.isStriped = style != null && style.equals("striped");
            if (newIsSidebar != this.isSideBar) {
                this.isSideBar = newIsSidebar;
                this.updateSidebar();
            }
        }
    }

    protected void updateSidebar() {
        if (this.isSideBar) {
            if (this.sidebarVibrantEffects == null) {
                JComponent c = this.tree;
                if (c.getParent() instanceof JViewport) {
                    c = (JViewport)c.getParent();
                }
                this.sidebarVibrantEffects = new SidebarVibrantEffects(c);
            }
        } else if (this.sidebarVibrantEffects != null) {
            this.sidebarVibrantEffects.dispose();
            this.sidebarVibrantEffects = null;
        }
    }

    protected boolean isCellFilledProperty(String prop) {
        return AquaUtils.isProperty(prop, IS_CELL_FILLED_KEY, QUAQUA_IS_CELL_FILLED_KEY);
    }

    protected boolean isStyleProperty(String prop) {
        return AquaUtils.isProperty(prop, TREE_STYLE_KEY, QUAQUA_TREE_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.tree, TREE_STYLE_KEY, QUAQUA_TREE_STYLE_KEY);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new AquaTreeMouseBehavior(this.tree);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MacPropertyChangeHandler();
    }

    @Override
    public boolean startEditing(TreePath path, MouseEvent event) {
        boolean isEditing = super.startEditing(path, event);
        if (isEditing) {
            this.editorFocusOwner = AquaFocusHandler.getFocusableComponent(this.editingComponent);
            if (this.editorFocusOwner != null) {
                this.editorFocusOwner.addFocusListener(this.editingComponentFocusListener);
            }
        }
        return isEditing;
    }

    @Override
    public void completeEditing() {
        if (this.editorFocusOwner != null) {
            this.editorFocusOwner.removeFocusListener(this.editingComponentFocusListener);
        }
        super.completeEditing();
    }

    @Override
    public void cancelEditing(JTree tree) {
        if (this.editorFocusOwner != null) {
            this.editorFocusOwner.removeFocusListener(this.editingComponentFocusListener);
        }
        super.cancelEditing(tree);
    }

    @Override
    public boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        return super.isLocationInExpandControl(path, mouseX, mouseY);
    }

    @Override
    public void checkForClickInExpandControl(TreePath path, int mouseX, int mouseY) {
        super.checkForClickInExpandControl(path, mouseX, mouseY);
    }

    public void setAnchorSelectionPath(TreePath newPath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    public TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeadSelectionPath(TreePath newPath, boolean repaint) {
        Rectangle bounds = repaint ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        if (repaint) {
            if (bounds != null) {
                this.tree.repaint(bounds);
            }
            if ((bounds = this.getPathBounds(this.tree, newPath)) != null) {
                this.tree.repaint(bounds);
            }
        }
    }

    public TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    public void setLeadSelectionPath(TreePath newPath) {
        this.setLeadSelectionPath(newPath, false);
    }

    @Override
    protected void setShowsRootHandles(boolean newValue) {
        super.setShowsRootHandles(true);
    }

    @Override
    protected boolean getShowsRootHandles() {
        return true;
    }

    protected void decodeLineStyle(Object lineStyleFlag) {
        if (lineStyleFlag == null || NO_STYLE_STRING.equals(lineStyleFlag)) {
            this.lineStyle = 0;
            return;
        }
        if (LEG_LINE_STYLE_STRING.equals(lineStyleFlag)) {
            this.lineStyle = 2;
        } else if (HORIZ_STYLE_STRING.equals(lineStyleFlag)) {
            this.lineStyle = 1;
        }
    }

    @Override
    public TreePath getClosestPathForLocation(JTree treeLocal, int x, int y) {
        if (treeLocal == null || this.treeState == null) {
            return null;
        }
        Insets i = treeLocal.getInsets();
        if (i == null) {
            i = new Insets(0, 0, 0, 0);
        }
        return this.treeState.getPathClosestTo(x - i.left, y - i.top);
    }

    @Override
    public void repaintSelection() {
        if (this.tree == null) {
            return;
        }
        Object o = this.tree.getClientProperty("JTree.selectionRepainter");
        if (o instanceof SelectionRepaintable) {
            SelectionRepaintable sp = (SelectionRepaintable)o;
            sp.repaintSelection();
            return;
        }
        Rectangle pBounds = null;
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (int i = 0; i < selectionPaths.length; ++i) {
                if (i == 0) {
                    pBounds = this.getPathBounds(this.tree, selectionPaths[i]);
                    continue;
                }
                pBounds.add(this.getPathBounds(this.tree, selectionPaths[i]));
            }
            if (pBounds != null) {
                this.tree.repaint(0, pBounds.y, this.tree.getWidth(), pBounds.height);
            }
        }
    }

    @Override
    protected int getRowX(int row, int depth) {
        if (this.isSideBar && depth > 1) {
            --depth;
        }
        return this.totalChildIndent * (depth + this.depthOffset);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.treeState == null) {
            return;
        }
        if (this.sidebarVibrantEffects != null) {
            this.sidebarVibrantEffects.update();
        }
        this.isActive = AquaFocusHandler.isActive(c);
        this.isFocused = this.shouldDisplayAsFocused(c);
        boolean bl = this.shouldPaintSelection = !Boolean.FALSE.equals(this.tree.getClientProperty("JTree.paintSelectionBackground"));
        if (this.isSideBar) {
            this.foreground = UIManager.getColor("Tree.sideBar.foreground");
            this.selectionForeground = UIManager.getColor(this.isFocused ? "Tree.sideBar.selectionForeground" : "Tree.sideBar.selectionInactiveForeground");
            this.selectionBackground = UIManager.getColor(this.isFocused ? "Tree.sideBar.selectionBackground" : "Tree.sideBar.selectionInactiveBackground");
        } else {
            this.foreground = UIManager.getColor("Tree.foreground");
            this.selectionForeground = UIManager.getColor(this.isFocused ? "Tree.selectionForeground" : "Tree.selectionInactiveForeground");
            this.selectionBackground = UIManager.getColor(this.isFocused ? "Tree.selectionBackground" : "Tree.selectionInactiveBackground");
        }
        this.paintBackground(g);
        super.paint(g, c);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(g, c);
        }
    }

    protected void paintBackground(Graphics g) {
        if (this.tree.isOpaque() && g instanceof Graphics2D) {
            int width = this.tree.getWidth();
            int height = this.tree.getHeight();
            Color background = this.getCurrentBackground();
            AquaUtils.fillRect((Graphics2D)g, background, 0, 0, width, height);
        }
        Rectangle paintBounds = g.getClipBounds();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        if (initialPath != null && paintingEnumerator != null) {
            this.paintRowBackgrounds(g, initialPath, paintingEnumerator);
        } else if (this.isStriped) {
            this.paintEmptyTreeStripes(g);
        }
    }

    public Color getCurrentBackground() {
        if (this.isSideBar) {
            return null;
        }
        return this.tree.getBackground();
    }

    protected void paintRowBackgrounds(Graphics g, TreePath initialPath, Enumeration paintingEnumerator) {
        TreePath path;
        if (!this.isStriped && !this.shouldPaintSelection) {
            return;
        }
        int width = this.tree.getWidth();
        int height = this.tree.getHeight();
        Insets insets = this.tree.getInsets();
        int rwidth = width - insets.left - insets.left;
        int rheight = this.tree.getRowHeight();
        if (rheight <= 0) {
            rheight = this.tree.getFont().getSize() + 4;
        }
        int row = this.treeState.getRowForPath(initialPath);
        Rectangle paintBounds = g.getClipBounds();
        int endY = paintBounds.y + paintBounds.height;
        while (paintingEnumerator.hasMoreElements() && (path = (TreePath)paintingEnumerator.nextElement()) != null) {
            Rectangle bounds = this.getPathBounds(this.tree, path);
            if (bounds == null) {
                return;
            }
            bounds.x += insets.left;
            bounds.y += insets.top;
            Color bc = this.getSpecialBackgroundForRow(row);
            if (bc != null) {
                g.setColor(bc);
                g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
            }
            if (bounds.y + bounds.height >= endY) break;
            ++row;
        }
    }

    protected Color getSpecialBackgroundForRow(int row) {
        if (this.tree.isRowSelected(row) && this.shouldPaintSelection) {
            if (this.sidebarVibrantEffects != null) {
                return null;
            }
            return this.selectionBackground;
        }
        if (this.isStriped) {
            return this.stripes[row % 2];
        }
        return null;
    }

    protected boolean shouldDisplayAsFocused(Component c) {
        return this.tree.isEditing() || AquaFocusHandler.hasFocus(c);
    }

    protected void paintEmptyTreeStripes(Graphics g) {
        int width = this.tree.getWidth();
        int height = this.tree.getHeight();
        Insets insets = this.tree.getInsets();
        int rwidth = width - insets.left - insets.left;
        int rheight = this.tree.getRowHeight();
        if (rheight <= 0) {
            rheight = this.tree.getFont().getSize() + 4;
        }
        Color[] stripes = new Color[]{UIManager.getColor("Tree.evenRowBackground"), UIManager.getColor("Tree.oddRowBackground")};
        int row = 0;
        for (int y = 0; y < height; y += rheight) {
            g.setColor(stripes[row % 2]);
            g.fillRect(insets.left, y, rwidth, rheight);
            ++row;
        }
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        boolean isCategory = path.getPathCount() == 2;
        boolean isRowSelected = this.tree.isRowSelected(row);
        this.configureCellRenderer(false, component, isCategory, row, isRowSelected);
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
        this.unconfigureCellRenderer(component);
    }

    protected void configureCellRenderer(boolean isLayout, Component component, boolean isCategory, int row, boolean isSelected) {
        if (component instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer treeCellRenderer = (DefaultTreeCellRenderer)component;
            treeCellRenderer.setBorder(new EmptyBorder(0, 0, 0, 0));
            if (!isLayout) {
                treeCellRenderer.setBackgroundNonSelectionColor(TRANSPARENT_COLOR);
                treeCellRenderer.setBackgroundSelectionColor(TRANSPARENT_COLOR);
                treeCellRenderer.setBorderSelectionColor(TRANSPARENT_COLOR);
                treeCellRenderer.setTextNonSelectionColor(this.foreground);
                treeCellRenderer.setTextSelectionColor(this.selectionForeground);
            }
        }
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            this.oldCellRendererFont = label.getFont();
            this.oldCellRendererIcon = label.getIcon();
            this.oldCellRendererDisabledIcon = label.getDisabledIcon();
            Color fc = isSelected ? this.selectionForeground : this.foreground;
            Font f = null;
            if (this.isSideBar) {
                fc = this.getSideBarForeground(isCategory, isSelected);
                Font sf = this.getSideBarFont(isCategory, isSelected);
                if (sf != null) {
                    f = this.fixFont(sf);
                }
                if (isCategory) {
                    label.setIcon(null);
                    label.setDisabledIcon(null);
                }
            }
            if (!isLayout && fc != null) {
                label.setForeground(fc);
            }
            if (f != null) {
                label.setFont(f);
            }
        }
    }

    protected void unconfigureCellRenderer(Component component) {
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setFont(this.oldCellRendererFont);
            label.setIcon(this.oldCellRendererIcon);
            label.setDisabledIcon(this.oldCellRendererDisabledIcon);
        }
    }

    protected Font getSideBarFont(boolean isTopLevel, boolean isSelected) {
        if (isTopLevel) {
            return UIManager.getFont("Tree.sideBarCategory.font");
        }
        if (isSelected) {
            return UIManager.getFont("Tree.sideBar.selectionFont");
        }
        return UIManager.getFont("Tree.sideBar.font");
    }

    protected Color getSideBarForeground(boolean isTopLevel, boolean isSelected) {
        if (isTopLevel) {
            return UIManager.getColor("Tree.sideBarCategory.foreground");
        }
        if (isSelected) {
            return UIManager.getColor("Tree.sideBar.selectionForeground");
        }
        return UIManager.getColor("Tree.sideBar.foreground");
    }

    protected Font fixFont(Font f) {
        return f instanceof FontUIResource ? new MyFont(f) : f;
    }

    protected void paintHorizontalSeparators(Graphics g, JComponent c) {
        g.setColor(UIManager.getColor("Tree.line"));
        Rectangle clipBounds = g.getClipBounds();
        int beginRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y));
        int endRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y + clipBounds.height - 1));
        if (beginRow <= -1 || endRow <= -1) {
            return;
        }
        for (int i = beginRow; i <= endRow; ++i) {
            Rectangle rowBounds;
            TreePath path = this.getPathForRow(this.tree, i);
            if (path == null || path.getPathCount() != 2 || (rowBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) == null) continue;
            g.drawLine(clipBounds.x, rowBounds.y, clipBounds.x + clipBounds.width, rowBounds.y);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Icon icon;
        Object value = path.getLastPathComponent();
        if (isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0) {
            return;
        }
        Icon icon2 = icon = isExpanded ? this.getExpandedIcon() : this.getCollapsedIcon();
        if (icon != null && !(icon instanceof UIResource)) {
            super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            return;
        }
        boolean isLeftToRight = AquaUtils.isLeftToRight(this.tree);
        int middleXOfKnob = isLeftToRight ? bounds.x - this.getRightChildIndent() + 1 : bounds.x + bounds.width + this.getRightChildIndent() - 1;
        int middleYOfKnob = bounds.y + bounds.height / 2;
        AquaUIPainter.State state = this.getState(path);
        if (!this.fIsInBounds && state == AquaUIPainter.State.PRESSED) {
            state = AquaUIPainter.State.ACTIVE;
        }
        Configuration tg = this.getDisclosureTriangleConfiguration(state, isExpanded, isLeftToRight);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)((Object)tg));
        int width = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
        int height = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
        if (width == 0) {
            width = 20;
        }
        if (height == 0) {
            height = width;
        }
        int x = middleXOfKnob - width / 2;
        int y = middleYOfKnob - height / 2;
        this.painter.configure(width, height);
        this.painter.getPainter(tg).paint(g, x, y);
    }

    protected Configuration getDisclosureTriangleConfiguration(AquaUIPainter.State state, boolean isExpanded, boolean isLeftToRight) {
        AquaUIPainter.UILayoutDirection ld;
        AquaUIPainter.ButtonWidget widget = AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE;
        AquaUIPainter.Size size = AquaUIPainter.Size.REGULAR;
        boolean isFocused = false;
        AquaUIPainter.ButtonState bs = isExpanded ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        AquaUIPainter.UILayoutDirection uILayoutDirection = ld = isLeftToRight ? AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT : AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT;
        if (this.fAnimationTransition >= 0.0f) {
            AquaUIPainter.ButtonState previousButtonState = bs == AquaUIPainter.ButtonState.ON ? AquaUIPainter.ButtonState.OFF : AquaUIPainter.ButtonState.ON;
            return new AnimatedButtonConfiguration(widget, size, state, isFocused, bs, ld, previousButtonState, this.fAnimationTransition);
        }
        return new ButtonConfiguration(widget, size, state, isFocused, bs, ld);
    }

    @Override
    public Icon getCollapsedIcon() {
        Icon icon = super.getCollapsedIcon();
        if (AquaUtils.isLeftToRight(this.tree)) {
            return icon;
        }
        if (!(icon instanceof UIResource)) {
            return icon;
        }
        return UIManager.getIcon("Tree.rightToLeftCollapsedIcon");
    }

    protected AquaUIPainter.State getState(TreePath path) {
        if (!this.tree.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (this.fIsPressed && this.fTrackingPath.equals(path)) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        this.fMouseHandler = new TreeArrowMouseInputHandler(path);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isMetaDown();
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new TreeNodeDimensions();
    }

    protected void updateDropTargetListener() {
        DropTarget dropTarget = this.tree.getDropTarget();
        if (dropTarget instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TreeDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected int getRowForPath(TreePath path) {
        return this.treeState.getRowForPath(path);
    }

    private Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
            bounds.x = AquaUtils.isLeftToRight(this.tree) ? (bounds.x += insets.left) : this.tree.getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    protected Rectangle getPathArrowBounds(TreePath path) {
        int boxLeftX;
        Rectangle bounds = this.getPathBounds(this.tree, path);
        Insets i = this.tree.getInsets();
        bounds.width = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
        int n = boxLeftX = i != null ? i.left : 0;
        boxLeftX = AquaUtils.isLeftToRight(this.tree) ? (boxLeftX += (path.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - bounds.width / 2) : (boxLeftX += this.tree.getWidth() - 1 - (path.getPathCount() - 2 + this.depthOffset) * this.totalChildIndent - this.getLeftChildIndent() - bounds.width / 2);
        bounds.x = boxLeftX;
        return bounds;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.tree.getActionMap().put("aquaExpandNode", new KeyboardExpandCollapseAction(true, false));
        this.tree.getActionMap().put("aquaCollapseNode", new KeyboardExpandCollapseAction(false, false));
        this.tree.getActionMap().put("aquaFullyExpandNode", new KeyboardExpandCollapseAction(true, true));
        this.tree.getActionMap().put("aquaFullyCollapseNode", new KeyboardExpandCollapseAction(false, true));
    }

    void expandNode(int row, boolean recursive) {
        TreePath path = this.getPathForRow(this.tree, row);
        if (path == null) {
            return;
        }
        this.tree.expandPath(path);
        if (!recursive) {
            return;
        }
        this.expandAllNodes(path, row + 1);
    }

    void expandAllNodes(TreePath parent, int initialRow) {
        int i = initialRow;
        TreePath path;
        while (parent.isDescendant(path = this.getPathForRow(this.tree, i))) {
            this.tree.expandPath(path);
            ++i;
        }
        return;
    }

    void collapseNode(int row, boolean recursive) {
        TreePath path = this.getPathForRow(this.tree, row);
        if (path == null) {
            return;
        }
        if (recursive) {
            this.collapseAllNodes(path, row + 1);
        }
        this.tree.collapsePath(path);
    }

    void collapseAllNodes(TreePath parent, int initialRow) {
        TreePath path;
        int lastRow = -1;
        int i = initialRow;
        while (lastRow == -1) {
            path = this.getPathForRow(this.tree, i);
            if (!parent.isDescendant(path)) {
                lastRow = i - 1;
            }
            ++i;
        }
        for (i = lastRow; i >= initialRow; --i) {
            path = this.getPathForRow(this.tree, i);
            this.tree.collapsePath(path);
        }
    }

    protected static JTree getComponent(DropTargetEvent e) {
        DropTargetContext context = e.getDropTargetContext();
        return (JTree)context.getComponent();
    }

    public static class TreeDropTargetListener
    extends DropTargetAdapter {
        private boolean isStateSaved;
        private int[] selectedIndices;

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            JTree c = AquaTreeUI.getComponent(e);
            TransferHandler th = c.getTransferHandler();
            if (th.canImport(c, e.getCurrentDataFlavors())) {
                this.saveComponentState(c);
                this.isStateSaved = true;
            } else {
                this.isStateSaved = false;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            JTree c = AquaTreeUI.getComponent(e);
            TransferHandler th = c.getTransferHandler();
            if (th.canImport(c, e.getCurrentDataFlavors())) {
                this.updateInsertionLocation(c, e.getLocation());
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            if (this.isStateSaved) {
                JTree c = AquaTreeUI.getComponent(e);
                this.restoreComponentState(c);
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
        }

        protected void saveComponentState(JTree c) {
            this.selectedIndices = c.getSelectionRows();
        }

        protected void restoreComponentState(JTree c) {
            c.setSelectionRows(this.selectedIndices);
        }

        protected void updateInsertionLocation(JTree c, Point p) {
            BasicTreeUI ui = (BasicTreeUI)c.getUI();
            TreePath path = ui.getClosestPathForLocation(c, p.x, p.y);
            if (path != null) {
                c.setSelectionPath(path);
            }
        }
    }

    class KeyboardExpandCollapseAction
    extends AbstractAction {
        final boolean expand;
        final boolean recursive;

        public KeyboardExpandCollapseAction(boolean expand, boolean recursive) {
            this.expand = expand;
            this.recursive = recursive;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AquaTreeUI.this.tree == null || 0 > AquaTreeUI.this.getRowCount(AquaTreeUI.this.tree)) {
                return;
            }
            TreePath[] selectionPaths = AquaTreeUI.this.tree.getSelectionPaths();
            if (selectionPaths == null) {
                return;
            }
            for (int i = selectionPaths.length - 1; i >= 0; --i) {
                TreePath path = selectionPaths[i];
                if (this.expand) {
                    AquaTreeUI.this.expandNode(AquaTreeUI.this.tree.getRowForPath(path), this.recursive);
                    continue;
                }
                if (selectionPaths.length == 1 && AquaTreeUI.this.tree.isCollapsed(path)) {
                    TreePath parentPath = path.getParentPath();
                    if (parentPath == null || parentPath.getParentPath() == null && !AquaTreeUI.this.tree.isRootVisible()) continue;
                    AquaTreeUI.this.tree.scrollPathToVisible(parentPath);
                    AquaTreeUI.this.tree.setSelectionPath(parentPath);
                    continue;
                }
                AquaTreeUI.this.collapseNode(AquaTreeUI.this.tree.getRowForPath(path), this.recursive);
            }
        }

        @Override
        public boolean isEnabled() {
            return AquaTreeUI.this.tree != null && AquaTreeUI.this.tree.isEnabled();
        }
    }

    class TreeArrowMouseInputHandler
    extends MouseInputAdapter {
        protected Rectangle fPathBounds = new Rectangle();
        protected boolean fIsLeaf;
        protected boolean fIsExpanded;
        protected boolean fHasBeenExpanded;
        protected Rectangle fBounds;
        protected Rectangle fVisibleRect;
        int fTrackingRow;
        Insets fInsets;

        TreeArrowMouseInputHandler(TreePath path) {
            AquaTreeUI.this.fTrackingPath = path;
            this.fTrackingRow = AquaTreeUI.this.getRowForPath(AquaTreeUI.this.fTrackingPath);
            AquaTreeUI.this.fIsPressed = true;
            AquaTreeUI.this.fIsInBounds = true;
            this.fPathBounds = AquaTreeUI.this.getPathArrowBounds(path);
            AquaTreeUI.this.tree.addMouseListener(this);
            AquaTreeUI.this.tree.addMouseMotionListener(this);
            this.fVisibleRect = AquaTreeUI.this.tree.getVisibleRect();
            this.fInsets = AquaTreeUI.this.tree.getInsets();
            if (this.fInsets == null) {
                this.fInsets = new Insets(0, 0, 0, 0);
            }
            this.fIsLeaf = AquaTreeUI.this.treeModel.isLeaf(path.getLastPathComponent());
            if (this.fIsLeaf) {
                this.fHasBeenExpanded = false;
                this.fIsExpanded = false;
            } else {
                this.fIsExpanded = AquaTreeUI.this.treeState.getExpandedState(path);
                this.fHasBeenExpanded = AquaTreeUI.this.tree.hasBeenExpanded(path);
            }
            Rectangle boundsBuffer = new Rectangle();
            this.fBounds = AquaTreeUI.this.getPathBounds(AquaTreeUI.this.fTrackingPath, this.fInsets, boundsBuffer);
            this.paintOneControl();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(e.getX(), e.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(e.getX(), e.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            if (AquaTreeUI.this.fIsPressed) {
                boolean wasInBounds = AquaTreeUI.this.fIsInBounds;
                AquaTreeUI.this.fIsPressed = false;
                AquaTreeUI.this.fIsInBounds = false;
                if (wasInBounds) {
                    this.fIsExpanded = !this.fIsExpanded;
                    this.paintAnimation(this.fIsExpanded);
                    if (e.isAltDown()) {
                        if (this.fIsExpanded) {
                            AquaTreeUI.this.expandNode(this.fTrackingRow, true);
                        } else {
                            AquaTreeUI.this.collapseNode(this.fTrackingRow, true);
                        }
                    } else {
                        AquaTreeUI.this.toggleExpandState(AquaTreeUI.this.fTrackingPath);
                    }
                }
            }
            AquaTreeUI.this.fTrackingPath = null;
            this.removeFromSource();
        }

        protected void paintAnimation(boolean expanding) {
            this.paintAnimationFrame(0.0f);
            this.paintAnimationFrame(0.5f);
            this.paintAnimationFrame(1.0f);
            AquaTreeUI.this.fAnimationTransition = -1.0f;
        }

        protected void paintAnimationFrame(float transition) {
            AquaTreeUI.this.fAnimationTransition = transition;
            this.paintOneControl();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void paintOneControl() {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            Graphics g = AquaTreeUI.this.tree.getGraphics();
            if (g == null) {
                return;
            }
            try {
                g.setClip(this.fVisibleRect);
                if (AquaTreeUI.this.fTrackingPath == null) {
                    return;
                }
                TreePath parentPath = AquaTreeUI.this.fTrackingPath.getParentPath();
                if (parentPath != null) {
                    AquaTreeUI.this.paintVerticalPartOfLeg(g, this.fPathBounds, this.fInsets, parentPath);
                    AquaTreeUI.this.paintHorizontalPartOfLeg(g, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                } else if (AquaTreeUI.this.isRootVisible() && this.fTrackingRow == 0) {
                    AquaTreeUI.this.paintHorizontalPartOfLeg(g, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                }
                AquaTreeUI.this.paintExpandControl(g, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
            }
            finally {
                g.dispose();
            }
        }

        protected void removeFromSource() {
            AquaTreeUI.this.tree.removeMouseListener(this);
            AquaTreeUI.this.tree.removeMouseMotionListener(this);
        }
    }

    public class MacPropertyChangeHandler
    extends BasicTreeUI.PropertyChangeHandler {
        public MacPropertyChangeHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == null) {
                return;
            }
            if (evt.getSource() == AquaTreeUI.this.tree) {
                if (name.equals("leadSelectionPath") && AquaTreeUI.this.ignoreLAChange) {
                    return;
                }
                if (name.equals("anchorSelectionPath") && AquaTreeUI.this.ignoreLAChange) {
                    return;
                }
                if (name.equals("Frame.active")) {
                    JViewport vp;
                    Container vpp;
                    Container parent;
                    AquaFocusHandler.swapSelectionColors("Tree", AquaTreeUI.this.tree, evt.getNewValue());
                    AquaTreeUI.this.tree.repaint();
                    if (AquaTreeUI.this.isSideBar && (parent = AquaTreeUI.this.tree.getParent()) instanceof JViewport && (vpp = (vp = (JViewport)parent).getParent()) instanceof JScrollPane) {
                        JScrollPane sp = (JScrollPane)vpp;
                        sp.repaint();
                    }
                    return;
                }
                if (name.equals("transferHandler")) {
                    AquaTreeUI.this.updateDropTargetListener();
                    return;
                }
                if (AquaTreeUI.this.isCellFilledProperty(name)) {
                    AquaTreeUI.this.updateProperties();
                    AquaTreeUI.this.tree.repaint();
                    if (AquaTreeUI.this.treeState != null) {
                        AquaTreeUI.this.treeState.invalidateSizes();
                    }
                    return;
                }
                if (AquaTreeUI.this.isStyleProperty(name)) {
                    AquaTreeUI.this.updateProperties();
                    AquaTreeUI.this.tree.repaint();
                    return;
                }
                super.propertyChange(evt);
            }
        }
    }

    protected class FocusHandler
    extends BasicTreeUI.FocusHandler {
        protected FocusHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            AquaTreeUI.this.repaintSelection();
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            AquaTreeUI.this.repaintSelection();
        }
    }

    class LineListener
    implements PropertyChangeListener {
        LineListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(AquaTreeUI.LINE_STYLE)) {
                AquaTreeUI.this.decodeLineStyle(e.getNewValue());
            }
        }
    }

    protected class MyFont
    extends Font {
        public MyFont(Font f) {
            super(f);
        }
    }

    protected class TreeNodeDimensions
    extends BasicTreeUI.NodeDimensionsHandler {
        protected TreeNodeDimensions() {
            super(AquaTreeUI.this);
        }

        @Override
        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            Rectangle r = this.getBasicNodeDimensions(value, row, depth, expanded, size);
            if (AquaTreeUI.this.isCellFilled && r != null && (AquaTreeUI.this.editingComponent == null || AquaTreeUI.this.editingRow != row) && AquaTreeUI.this.tree.getWidth() > 0) {
                int width;
                Insets s = AquaTreeUI.this.tree.getInsets();
                r.width = width = AquaTreeUI.this.tree.getWidth() - s.right - r.x;
            }
            return r;
        }

        public Rectangle getBasicNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            if (AquaTreeUI.this.editingComponent != null && AquaTreeUI.this.editingRow == row) {
                Dimension prefSize = AquaTreeUI.this.editingComponent.getPreferredSize();
                int rh = AquaTreeUI.this.getRowHeight();
                if (rh > 0 && rh != prefSize.height) {
                    prefSize.height = rh;
                }
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            if (AquaTreeUI.this.currentCellRenderer != null) {
                boolean isSelected = true;
                Component aComponent = AquaTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(AquaTreeUI.this.tree, value, isSelected, expanded, AquaTreeUI.this.treeModel.isLeaf(value), row, false);
                boolean isCategory = depth == 1;
                AquaTreeUI.this.configureCellRenderer(true, aComponent, isCategory, row, isSelected);
                if (AquaTreeUI.this.tree != null) {
                    AquaTreeUI.this.rendererPane.add(aComponent);
                    aComponent.validate();
                }
                Dimension prefSize = aComponent.getPreferredSize();
                AquaTreeUI.this.unconfigureCellRenderer(aComponent);
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            return null;
        }
    }

    protected class EditingComponentFocusListener
    implements FocusListener {
        protected EditingComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            AquaTreeUI.this.stopEditing(AquaTreeUI.this.tree);
        }
    }

    protected class SidebarVibrantEffects
    extends VisualEffectView {
        protected TreeSelectionBoundsTracker bt;

        public SidebarVibrantEffects(final JComponent top) {
            super(top, 2, true);
            this.bt = new TreeSelectionBoundsTracker(AquaTreeUI.this.tree, this::updateSelectionBackgrounds){

                @Override
                protected int convertRowYCoordinateToSelectionDescription(int y) {
                    if (top != this.tree) {
                        Point p = SwingUtilities.convertPoint(this.tree, 0, y, top);
                        return p.y;
                    }
                    return y;
                }
            };
        }

        public void update() {
            if (this.bt != null) {
                this.bt.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.bt != null) {
                this.bt.dispose();
                this.bt = null;
            }
        }

        @Override
        protected void windowChanged(Window newWindow) {
            super.windowChanged(newWindow);
            if (this.bt != null) {
                this.bt.reset();
            }
        }
    }
}

