/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaUtilControlSize {
    protected static final String CLIENT_PROPERTY_KEY = "JComponent.sizeVariant";
    protected static final String SYSTEM_PROPERTY_KEY = "swing.component.sizevariant";
    protected static final AquaUtils.RecyclableSingleton<PropertySizeListener> sizeListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<PropertySizeListener>(PropertySizeListener.class);
    protected static final AquaUIPainter.Size defaultSize = AquaUtilControlSize.getDefaultSize();

    protected static PropertySizeListener getSizeListener() {
        return sizeListener.get();
    }

    protected static void addSizePropertyListener(JComponent c) {
        c.addPropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
        AquaUtilControlSize.applyComponentSize(c, c.getClientProperty(CLIENT_PROPERTY_KEY));
    }

    protected static void removeSizePropertyListener(JComponent c) {
        c.removePropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
    }

    private static AquaUIPainter.Size getSizeFromString(String name) {
        if ("regular".equalsIgnoreCase(name)) {
            return AquaUIPainter.Size.REGULAR;
        }
        if ("small".equalsIgnoreCase(name)) {
            return AquaUIPainter.Size.SMALL;
        }
        if ("mini".equalsIgnoreCase(name)) {
            return AquaUIPainter.Size.MINI;
        }
        if ("large".equalsIgnoreCase(name)) {
            return AquaUIPainter.Size.LARGE;
        }
        return null;
    }

    public static String getStringFromSize(AquaUIPainter.Size sz) {
        if (sz == AquaUIPainter.Size.REGULAR) {
            return "regular";
        }
        if (sz == AquaUIPainter.Size.SMALL) {
            return "small";
        }
        if (sz == AquaUIPainter.Size.MINI) {
            return "mini";
        }
        if (sz == AquaUIPainter.Size.LARGE) {
            return "large";
        }
        return null;
    }

    private static AquaUIPainter.Size getDefaultSize() {
        String sizeProperty = AccessController.doPrivileged(() -> System.getProperty(SYSTEM_PROPERTY_KEY));
        AquaUIPainter.Size size = AquaUtilControlSize.getSizeFromString(sizeProperty);
        if (size != null) {
            return size;
        }
        return AquaUIPainter.Size.REGULAR;
    }

    public static AquaUIPainter.Size getUserSizeFrom(JComponent c) {
        Object sizeProp = c.getClientProperty(CLIENT_PROPERTY_KEY);
        if (sizeProp == null) {
            return defaultSize;
        }
        AquaUIPainter.Size size = AquaUtilControlSize.getSizeFromString(sizeProp.toString());
        return size != null ? size : AquaUIPainter.Size.REGULAR;
    }

    private static boolean applyUISizing(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        Sizeable sizeable = AquaUtils.getUI(c, Sizeable.class);
        if (sizeable != null) {
            sizeable.applySizeFor(c, size, isDefaultSize);
            return true;
        }
        return false;
    }

    private static void applyComponentSize(JComponent c, Object value) {
        AquaUIPainter.Size size = null;
        boolean isDefaultSize = false;
        if (value != null) {
            size = AquaUtilControlSize.getSizeFromString(value.toString());
        }
        if (size == null) {
            size = defaultSize;
            isDefaultSize = true;
        }
        if (!AquaUtilControlSize.applyUISizing(c, size, isDefaultSize)) {
            AquaUtilControlSize.configureFontFromSize(c, size);
        }
    }

    public static void configureFontFromSize(JComponent c, AquaUIPainter.Size size) {
        Font priorFont;
        if (AquaUtilControlSize.isOKToInstallDefaultFont(c) && (priorFont = c.getFont()) != null) {
            AquaUtilControlSize.installDefaultFont(c, AquaUtilControlSize.getFontForSize(priorFont, size));
        }
    }

    public static void installDefaultFont(JComponent c, Font f) {
        if (AquaUtilControlSize.isOKToInstallDefaultFont(c)) {
            c.setFont(f);
        }
    }

    public static boolean isOKToInstallDefaultFont(JComponent c) {
        Font f = c.getFont();
        return f == null || f instanceof UIResource;
    }

    public static void uninstallDefaultFont(JComponent c) {
        Font f = c.getFont();
        if (f instanceof UIResource) {
            c.setFont(null);
        }
    }

    public static Font getFontForSize(Font f, AquaUIPainter.Size size) {
        if (!(f instanceof AquaFonts.DerivedUIResourceFont)) {
            f = new AquaFonts.DerivedUIResourceFont(f);
        }
        if (size == AquaUIPainter.Size.MINI) {
            return f.deriveFont(AquaFonts.getMiniControlTextFont().getSize2D());
        }
        if (size == AquaUIPainter.Size.SMALL) {
            return f.deriveFont(AquaFonts.getSmallControlTextFont().getSize2D());
        }
        return f.deriveFont(AquaFonts.getControlTextFont().getSize2D());
    }

    protected static class PropertySizeListener
    implements PropertyChangeListener {
        protected PropertySizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String key = evt.getPropertyName();
            if (!AquaUtilControlSize.CLIENT_PROPERTY_KEY.equalsIgnoreCase(key)) {
                return;
            }
            Object source = evt.getSource();
            if (!(source instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)source;
            AquaUtilControlSize.applyComponentSize(c, evt.getNewValue());
        }
    }

    static interface Sizeable {
        public void applySizeFor(JComponent var1, AquaUIPainter.Size var2, boolean var3);
    }
}

