/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.SwingUtilitiesModified;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import sun.java2d.opengl.OGLRenderQueue;
import sun.swing.SwingUtilities2;

public final class AquaUtils
extends SwingUtilitiesModified {
    private static final String ANIMATIONS_PROPERTY = "swing.enableAnimations";
    private static final int javaVersion = AquaUtils.obtainJavaVersion();
    private static final RecyclableSingleton<Boolean> enableAnimations = new RecyclableSingleton<Boolean>(){

        @Override
        protected Boolean getInstance() {
            String sizeProperty = AccessController.doPrivileged(() -> System.getProperty(AquaUtils.ANIMATIONS_PROPERTY));
            return !"false".equals(sizeProperty);
        }
    };
    private static final int MENU_BLINK_DELAY = 50;
    private static final RecyclableSingleton<Method> getJComponentGetFlagMethod = new RecyclableSingleton<Method>(){

        @Override
        protected Method getInstance() {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method method = JComponent.class.getDeclaredMethod("getFlag", Integer.TYPE);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                }
            });
        }
    };
    private static final Integer OPAQUE_SET_FLAG = 24;
    public static final int ERASE_IF_TEXTURED = 1;
    public static final int ERASE_IF_VIBRANT = 2;
    public static final int ERASE_ALWLAYS = 4;
    static final Map<Object, Object> appContextMap = new HashMap<Object, Object>();
    public static final int TITLE_BAR_NONE = 0;
    public static final int TITLE_BAR_ORDINARY = 1;
    public static final int TITLE_BAR_TRANSPARENT = 2;
    public static final int TITLE_BAR_HIDDEN = 3;
    public static final int TITLE_BAR_OVERLAY = 4;

    private AquaUtils() {
    }

    public static int getJavaVersion() {
        return javaVersion;
    }

    private static int obtainJavaVersion() {
        String s = System.getProperty("java.version");
        int version = 0;
        int tokenCount = 0;
        StringTokenizer st = new StringTokenizer(s, "._");
        try {
            while (st.hasMoreTokens()) {
                int limit;
                String token = st.nextToken();
                int n = Integer.parseInt(token);
                int n2 = limit = ++tokenCount < 4 ? 100 : 1000;
                if (n < 0 || n >= limit) {
                    return 0;
                }
                version = version * limit + n;
            }
        }
        catch (NumberFormatException ex) {
            return 0;
        }
        if (tokenCount != 4) {
            return 0;
        }
        return version;
    }

    public static <T> T getUI(JComponent c, Class<T> requestedClass) {
        try {
            Class<?> clazz = c.getClass();
            Method getUIMethod = clazz.getMethod("getUI", new Class[0]);
            Object ui = getUIMethod.invoke((Object)c, new Object[0]);
            return requestedClass.cast(ui);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static Insets combineAsInsets(Insetter s, Insets adjustments) {
        if (s != null) {
            Insets n = s.asInsets();
            return AquaUtils.combineInsets(n, adjustments);
        }
        return adjustments != null ? adjustments : new Insets(0, 0, 0, 0);
    }

    public static Insets2D combineAsInsets2D(Insetter s, Insets adjustments) {
        if (s != null) {
            Insets2D n = s.asInsets2D();
            return AquaUtils.combineInsets(n, adjustments);
        }
        return adjustments != null ? AquaUtils.asInsets2D(adjustments) : new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Insets combineInsets(Insets s1, Insets s2) {
        if (s1 != null) {
            if (s2 != null) {
                return new Insets(s1.top + s2.top, s1.left + s2.left, s1.bottom + s2.bottom, s1.right + s2.right);
            }
            return s1;
        }
        if (s2 != null) {
            return s2;
        }
        return new Insets(0, 0, 0, 0);
    }

    public static Insets2D combineInsets(Insets2D s1, Insets s2) {
        if (s1 != null) {
            if (s2 != null) {
                return new Insets2D(s1.getTop() + (float)s2.top, s1.getLeft() + (float)s2.left, s1.getBottom() + (float)s2.bottom, s1.getRight() + (float)s2.right);
            }
            return s1;
        }
        if (s2 != null) {
            return AquaUtils.asInsets2D(s2);
        }
        return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Insets2D asInsets2D(Insets s) {
        return new Insets2D(s.top, s.left, s.bottom, s.right);
    }

    public static Rectangle toRectangle(Rectangle2D r) {
        if (r instanceof Rectangle) {
            return (Rectangle)r;
        }
        int x = (int)Math.floor(r.getX());
        int y = (int)Math.floor(r.getY());
        int width = (int)Math.ceil(r.getWidth());
        int height = (int)Math.ceil(r.getHeight());
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle toMinimumRectangle(Rectangle2D r) {
        if (r instanceof Rectangle) {
            return (Rectangle)r;
        }
        double xx = r.getX();
        double ww = r.getWidth();
        int x = (int)Math.ceil(xx);
        int w = (int)Math.floor(ww -= (double)x - xx);
        double yy = r.getY();
        double hh = r.getHeight();
        int y = (int)Math.ceil(yy);
        int h = (int)Math.floor(hh -= (double)y - yy);
        return new Rectangle(x, y, w, h);
    }

    public static Point getScreenLocation(Component c) {
        Point p = new Point(0, 0);
        SwingUtilities.convertPointToScreen(p, c);
        return p;
    }

    public static Rectangle getScreenBounds(Point location, Component invoker) {
        GraphicsConfiguration gc = AquaUtils.getCurrentGraphicsConfiguration(location, invoker);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle bounds = gc != null ? gc.getBounds() : new Rectangle(toolkit.getScreenSize());
        Insets insets = toolkit.getScreenInsets(gc);
        int top = insets.top / 2;
        int bottom = insets.bottom;
        int left = insets.left;
        int right = insets.right;
        return new Rectangle(bounds.x + left, bounds.y + top, bounds.width - left - right, bounds.height - top - bottom);
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration(Point location, Component invoker) {
        GraphicsDevice[] gds;
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration dgc;
            if (gd.getType() != 0 || !(dgc = gd.getDefaultConfiguration()).getBounds().contains(location)) continue;
            gc = dgc;
            break;
        }
        if (gc == null && invoker != null) {
            gc = invoker.getGraphicsConfiguration();
        }
        return gc;
    }

    public static JRootPane getRootPane(Window w) {
        if (w instanceof RootPaneContainer) {
            RootPaneContainer rpc = (RootPaneContainer)((Object)w);
            return rpc.getRootPane();
        }
        return null;
    }

    public static boolean isLeftToRight(Component c) {
        return c == null || c.getComponentOrientation().isLeftToRight();
    }

    public static AquaUIPainter.UILayoutDirection getLayoutDirection(Component c) {
        return c == null || c.getComponentOrientation().isLeftToRight() ? AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT : AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT;
    }

    static void enforceComponentOrientation(Component c, ComponentOrientation orientation) {
        c.setComponentOrientation(orientation);
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                AquaUtils.enforceComponentOrientation(child, orientation);
            }
        }
    }

    public static void paintImmediately(JComponent c) {
        try {
            Method m = JComponent.class.getDeclaredMethod("_paintImmediately", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            m.invoke((Object)c, 0, 0, c.getWidth(), c.getHeight());
        }
        catch (Exception ex) {
            System.err.println("Unable to paint immediately: " + ex);
        }
    }

    private static boolean animationsEnabled() {
        return enableAnimations.get();
    }

    static void blinkMenu(Selectable selectable) {
        if (!AquaUtils.animationsEnabled()) {
            return;
        }
        try {
            selectable.paintSelected(false);
            Thread.sleep(50L);
            selectable.paintSelected(true);
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static boolean hasOpaqueBeenExplicitlySet(JComponent c) {
        Method method = getJComponentGetFlagMethod.get();
        if (method == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(method.invoke((Object)c, OPAQUE_SET_FLAG));
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static void fillRect(Graphics g, Component c, int eraserMode) {
        AquaUtils.fillRect(g, c, eraserMode, 0, 0, c.getWidth(), c.getHeight());
    }

    public static void fillRect(Graphics g, Component c, int eraserMode, int x, int y, int w, int h) {
        Color color = AquaUtils.getFillColor(c, eraserMode);
        AquaUtils.fillRect(g, color, x, y, w, h);
    }

    private static Color getFillColor(Component c, int eraserMode) {
        if ((eraserMode & 4) != 0) {
            return null;
        }
        Color bc = c.getBackground();
        if (bc != null && !(bc instanceof UIResource)) {
            return bc;
        }
        return !AquaUtils.isMagicEraser(c, eraserMode) ? bc : null;
    }

    private static boolean isMagicEraser(Component c, int eraserMode) {
        boolean isVibrant;
        boolean isTextured = (eraserMode & 1) != 0;
        boolean bl = isVibrant = (eraserMode & 2) != 0;
        while (c != null) {
            if (c instanceof JRootPane) {
                JRootPane rp = (JRootPane)c;
                Object prop = rp.getClientProperty("apple.awt.brushMetalLook");
                if (prop != null && isTextured && Boolean.parseBoolean(prop.toString())) {
                    return true;
                }
                prop = rp.getClientProperty("Window.style");
                if (prop != null && prop.equals("textured") && isTextured) {
                    return true;
                }
            }
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                if (isVibrant && AquaVibrantSupport.isVibrant(jc)) {
                    return true;
                }
            }
            c = c.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRect(Graphics g, Color color, int x, int y, int w, int h) {
        Graphics cg = g.create();
        try {
            if (color != null) {
                cg.setColor(color);
                cg.fillRect(x, y, w, h);
            } else if (cg instanceof Graphics2D) {
                ((Graphics2D)cg).setComposite(AlphaComposite.Src);
                cg.setColor(new Color(0, 0, 0, 0));
                cg.fillRect(x, y, w, h);
            }
        }
        finally {
            cg.dispose();
        }
    }

    public static Graphics2D toGraphics2D(Graphics g) {
        try {
            return (Graphics2D)g;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static boolean isProperty(String s, String ... props) {
        if (s != null) {
            for (String prop : props) {
                if (!prop.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getProperty(JComponent c, String ... props) {
        for (String prop : props) {
            Object o = c.getClientProperty(prop);
            if (o == null) continue;
            return AquaUtils.toString(o);
        }
        return null;
    }

    public static String toString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static Boolean getBooleanProperty(JComponent c, String ... props) {
        for (String prop : props) {
            Object o = c.getClientProperty(prop);
            if (o == null) continue;
            return AquaUtils.toBoolean(o);
        }
        return null;
    }

    public static Boolean toBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    public static String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static String getProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException ex) {
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object key) {
        Map<Object, Object> map = appContextMap;
        synchronized (map) {
            return appContextMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object put(Object key, Object value) {
        Map<Object, Object> map = appContextMap;
        synchronized (map) {
            return appContextMap.put(key, value);
        }
    }

    public static <T> T getSoftReferenceValue(Object key, Supplier<T> supplier) {
        Object object;
        SoftReference ref = (SoftReference)AquaUtils.get(key);
        if (ref != null && (object = ref.get()) != null) {
            return object;
        }
        object = supplier.get();
        ref = new SoftReference(object);
        AquaUtils.put(key, ref);
        return object;
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        SwingUtilities2.drawString(c, g, text, x, y);
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, underlinedIndex, x, y);
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        return SwingUtilities2.clipStringIfNecessary(c, fm, string, availTextWidth);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        return SwingUtilities2.stringWidth(c, fm, string);
    }

    public static void installAATextInfo(UIDefaults table) {
        SwingUtilities2.AATextInfo aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo((boolean)true);
        table.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
    }

    public static Object beginGraphics(Graphics2D graphics2d) {
        Object object = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static void endGraphics(Graphics2D graphics2d, Object oldHints) {
        if (oldHints != null) {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHints);
        }
    }

    public static void drawHLine(Graphics g, int x1, int x2, int y) {
        if (x2 < x1) {
            int temp = x2;
            x2 = x1;
            x1 = temp;
        }
        g.fillRect(x1, y, x2 - x1 + 1, 1);
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static JScrollPane getScrollPaneAncestor(Component c) {
        Container p = c.getParent();
        if (p instanceof JViewport) {
            JViewport v = (JViewport)p;
            if ((p = v.getParent()) instanceof JScrollPane) {
                return AquaUtils.verifyScrollPaneAncestor(c, (JScrollPane)p);
            }
            if (p instanceof JComponent && !((JComponent)p).isOptimizedDrawingEnabled() && (p = p.getParent()) instanceof JScrollPane) {
                return AquaUtils.verifyScrollPaneAncestor(c, (JScrollPane)p);
            }
        }
        return null;
    }

    private static JScrollPane verifyScrollPaneAncestor(Component view, JScrollPane p) {
        JViewport v = p.getViewport();
        return v != null && v.getView() == view ? p : null;
    }

    public static void setTitleBarStyle(Window w, int style) {
        AquaUtils.ensureWindowPeer(w);
        int result = AquaUtils.nativeSetTitleBarStyle(w, style);
        if (result != 0) {
            throw new UnsupportedOperationException("Unable to set window title bar style");
        }
        if (style == 3) {
            AquaUtils.setWindowTitle(w, "");
        }
    }

    public static void setWindowTitle(Window w, String title) {
        if (w instanceof Frame) {
            ((Frame)w).setTitle(title);
        } else if (w instanceof Dialog) {
            ((Dialog)w).setTitle(title);
        }
    }

    public static void addNativeToolbarToWindow(Window w) throws UnsupportedOperationException {
        AquaUtils.ensureWindowPeer(w);
        int result = AquaUtils.nativeAddToolbarToWindow(w);
        if (result != 0) {
            throw new UnsupportedOperationException("Unable to add native toolbar to window");
        }
    }

    public static void ensureWindowPeer(Window w) {
        if (!w.isDisplayable()) {
            w.setSize(w.getPreferredSize());
            w.addNotify();
        }
    }

    public static int unsetTitledWindowStyle(Window w) {
        Rectangle oldBounds = w.getBounds();
        Insets oldInsets = w.getInsets();
        int top = oldInsets.top;
        if (top > 0) {
            int newHeight = oldBounds.height - oldInsets.top;
            try {
                Method m = w.getClass().getMethod("getPeer", new Class[0]);
                m.setAccessible(true);
                Object peer = m.invoke((Object)w, new Object[0]);
                if (peer != null) {
                    m = peer.getClass().getDeclaredMethod("getPlatformWindow", new Class[0]);
                    m.setAccessible(true);
                    Object platformWindow = m.invoke(peer, new Object[0]);
                    if (platformWindow != null) {
                        m = platformWindow.getClass().getDeclaredMethod("setStyleBits", Integer.TYPE, Boolean.TYPE);
                        m.setAccessible(true);
                        int DECORATED = 2;
                        m.invoke(platformWindow, DECORATED, false);
                        Field f = Component.class.getDeclaredField("height");
                        f.setAccessible(true);
                        f.setInt(w, newHeight);
                        m = peer.getClass().getDeclaredMethod("updateInsets", Insets.class);
                        m.setAccessible(true);
                        m.invoke(peer, new Insets(0, 0, 0, 0));
                        w.invalidate();
                        w.validate();
                        return top;
                    }
                    System.err.println("Unable to unset titled window style: no platform window");
                } else {
                    System.err.println("Unable to unset titled window style: no peer");
                }
            }
            catch (Exception ex) {
                System.err.println("Unable to unset titled window style: " + ex);
            }
        }
        return top;
    }

    public static void restoreTitledWindowStyle(Window w, int top) {
        Rectangle oldBounds = w.getBounds();
        Insets oldInsets = w.getInsets();
        int newHeight = oldBounds.height + top;
        try {
            Method m = w.getClass().getMethod("getPeer", new Class[0]);
            m.setAccessible(true);
            Object peer = m.invoke((Object)w, new Object[0]);
            if (peer != null) {
                m = peer.getClass().getDeclaredMethod("getPlatformWindow", new Class[0]);
                m.setAccessible(true);
                Object platformWindow = m.invoke(peer, new Object[0]);
                if (platformWindow != null) {
                    m = platformWindow.getClass().getDeclaredMethod("setStyleBits", Integer.TYPE, Boolean.TYPE);
                    m.setAccessible(true);
                    int DECORATED = 2;
                    m.invoke(platformWindow, DECORATED, true);
                    Field f = Component.class.getDeclaredField("height");
                    f.setAccessible(true);
                    f.setInt(w, newHeight);
                    m = peer.getClass().getDeclaredMethod("updateInsets", Insets.class);
                    m.setAccessible(true);
                    m.invoke(peer, new Insets(top, 0, 0, 0));
                    w.invalidate();
                    w.validate();
                } else {
                    System.err.println("Unable to restore titled window style: no platform window");
                }
            } else {
                System.err.println("Unable to restore titled window style: no peer");
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to restore titled window style: " + ex);
        }
    }

    public static void setWindowBackgroundClear(Window w, boolean isClear) {
        Color c = isClear ? new Color(0, 0, 0, 0) : AquaImageFactory.getWindowBackgroundColorUIResource();
        AquaUtils.setWindowTextured(w, isClear);
        AquaUtils.setWindowBackground(w, c);
        new ShadowMaker(w);
    }

    private static void setWindowTextured(Window w, boolean isTextured) {
        try {
            Method mp = w.getClass().getMethod("getPeer", new Class[0]);
            mp.setAccessible(true);
            Object peer = mp.invoke((Object)w, new Object[0]);
            if (peer == null) {
                System.err.println("Unable to set window textured: no peer for " + w);
                return;
            }
            Method m = peer.getClass().getDeclaredMethod("setTextured", Boolean.TYPE);
            m.setAccessible(true);
            m.invoke(peer, isTextured);
        }
        catch (Exception ex) {
            System.err.println("Unable to set textured: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowBackground(Window w, Color c) {
        if (c.equals(w.getBackground())) {
            return;
        }
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            w.setBackground(c);
        }
        catch (Throwable e) {
            Object peer;
            block12: {
                Method mp = w.getClass().getMethod("getPeer", new Class[0]);
                mp.setAccessible(true);
                peer = mp.invoke((Object)w, new Object[0]);
                if (peer != null) break block12;
                System.err.println("Unable to set window background: no peer for " + w);
                return;
            }
            try {
                Method mb = peer.getClass().getDeclaredMethod("setBackground", Color.class);
                mb.setAccessible(true);
                mb.invoke(peer, c);
                Method mo = peer.getClass().getDeclaredMethod("setOpaque", Boolean.TYPE);
                mo.setAccessible(true);
                mo.invoke(peer, c.getAlpha() == 255);
            }
            catch (Throwable th) {
                if (th instanceof InvocationTargetException) {
                    th = ((InvocationTargetException)th).getTargetException();
                }
                System.err.println("Unable to set window background: " + th);
            }
        }
        finally {
            rq.unlock();
        }
    }

    public static void setCornerRadius(Window w, float radius) {
        AquaUtils.nativeSetWindowCornerRadius(w, radius);
    }

    public static void setAWTViewVisibility(Window w, boolean isVisible) {
        AquaUtils.nativeSetAWTViewVisibility(w, isVisible);
    }

    public static void syncAWTView(Window w) {
        Toolkit.getDefaultToolkit().sync();
        AquaUtils.nativeSyncAWTView(w);
    }

    private static native int nativeSetTitleBarStyle(Window var0, int var1);

    private static native int nativeAddToolbarToWindow(Window var0);

    private static native int nativeSetWindowCornerRadius(Window var0, float var1);

    private static native void nativeSetAWTViewVisibility(Window var0, boolean var1);

    private static native void nativeSyncAWTView(Window var0);

    public static native void debugWindow(Window var0);

    public static native void syslog(String var0);

    private static class ShadowMaker
    implements ActionListener,
    Runnable {
        private final Window w;

        public ShadowMaker(Window w) {
            this.w = w;
            SwingUtilities.invokeLater(this);
            Timer t = new Timer(100, this);
            t.setRepeats(false);
            t.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        @Override
        public void run() {
            if (this.w instanceof RootPaneContainer) {
                AquaUtils.syncAWTView(this.w);
                JRootPane rp = ((RootPaneContainer)((Object)this.w)).getRootPane();
                rp.putClientProperty("apple.awt.windowShadow.revalidateNow", Math.random());
            }
        }
    }

    static class SlicedShadowBorder
    extends ShadowBorder {
        private final AquaImageFactory.SlicedImageControl slices;

        SlicedShadowBorder(Painter prePainter, Painter postPainter, int offsetX, int offsetY, float distance, float intensity, int blur, int templateWidth, int templateHeight, int leftCut, int topCut, int rightCut, int bottomCut) {
            super(prePainter, postPainter, offsetX, offsetY, distance, intensity, blur);
            BufferedImage i = new BufferedImage(templateWidth, templateHeight, 3);
            super.paintBorder(null, i.getGraphics(), 0, 0, templateWidth, templateHeight);
            this.slices = new AquaImageFactory.SlicedImageControl(i, leftCut, topCut, rightCut, bottomCut, false);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.slices.paint(g, x, y, width, height);
        }
    }

    static class ShadowBorder
    implements Border {
        private final Painter prePainter;
        private final Painter postPainter;
        private final int offsetX;
        private final int offsetY;
        private final float distance;
        private final int blur;
        private final Insets insets;
        private final ConvolveOp blurOp;

        ShadowBorder(Painter prePainter, Painter postPainter, int offsetX, int offsetY, float distance, float intensity, int blur) {
            this.prePainter = prePainter;
            this.postPainter = postPainter;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.distance = distance;
            this.blur = blur;
            int halfBlur = blur / 2;
            this.insets = new Insets(halfBlur - offsetY, halfBlur - offsetX, halfBlur + offsetY, halfBlur + offsetX);
            float blurry = intensity / (float)(blur * blur);
            float[] blurKernel = new float[blur * blur];
            for (int i = 0; i < blurKernel.length; ++i) {
                blurKernel[i] = blurry;
            }
            this.blurOp = new ConvolveOp(new Kernel(blur, blur, blurKernel));
        }

        @Override
        public final boolean isBorderOpaque() {
            return false;
        }

        @Override
        public final Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BufferedImage img = new BufferedImage(width + this.blur * 2, height + this.blur * 2, 3);
            this.paintToImage(img, x, y, width, height);
            g.drawImage(img, -this.blur, -this.blur, null);
        }

        private void paintToImage(BufferedImage img, int x, int y, int width, int height) {
            Graphics2D imgG = (Graphics2D)img.getGraphics();
            imgG.setComposite(AlphaComposite.Clear);
            imgG.setColor(Color.black);
            imgG.fillRect(0, 0, width + this.blur * 2, height + this.blur * 2);
            int adjX = (int)((float)(x + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
            int adjY = (int)((float)(y + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
            int adjW = (int)((float)width - (float)(this.insets.left + this.insets.right) * this.distance);
            int adjH = (int)((float)height - (float)(this.insets.top + this.insets.bottom) * this.distance);
            imgG.setComposite(AlphaComposite.DstAtop);
            if (this.prePainter != null) {
                this.prePainter.paint(imgG, adjX, adjY, adjW, adjH);
            }
            imgG.dispose();
            imgG = (Graphics2D)img.getGraphics();
            imgG.setComposite(AlphaComposite.DstAtop);
            imgG.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            imgG.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            imgG.drawImage(img, this.blurOp, 0, 0);
            if (this.postPainter != null) {
                this.postPainter.paint(imgG, adjX, adjY, adjW, adjH);
            }
            imgG.dispose();
        }
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }

    static interface JComponentPainter {
        public void paint(JComponent var1, Graphics var2, int var3, int var4, int var5, int var6);
    }

    static interface Selectable {
        public void paintSelected(boolean var1);
    }

    static abstract class LazyKeyedSingleton<K, V> {
        private Map<K, V> refs;

        LazyKeyedSingleton() {
        }

        V get(K key) {
            V cachedValue;
            if (this.refs == null) {
                this.refs = new HashMap();
            }
            if ((cachedValue = this.refs.get(key)) != null) {
                return cachedValue;
            }
            V value = this.getInstance(key);
            this.refs.put(key, value);
            return value;
        }

        protected abstract V getInstance(K var1);
    }

    static class RecyclableSingletonFromDefaultConstructor<T>
    extends RecyclableSingleton<T> {
        private final Class<T> clazz;

        RecyclableSingletonFromDefaultConstructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected T getInstance() {
            try {
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                return null;
            }
        }
    }

    public static abstract class RecyclableSingleton<T> {
        final T get() {
            return (T)AquaUtils.getSoftReferenceValue(this, () -> this.getInstance());
        }

        void reset() {
            AquaUtils.put(this, null);
        }

        protected abstract T getInstance();
    }

    static abstract class RecyclableObject<T> {
        private SoftReference<T> objectRef;

        RecyclableObject() {
        }

        T get() {
            T referent;
            if (this.objectRef != null && (referent = this.objectRef.get()) != null) {
                return referent;
            }
            referent = this.create();
            this.objectRef = new SoftReference<T>(referent);
            return referent;
        }

        protected abstract T create();
    }
}

