/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ComponentVibrantEffects;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.aqua.VisualEffectViewPeer;

public class AquaVibrantSupport {
    public static final int LIGHT_STYLE = 0;
    public static final int DARK_STYLE = 1;
    public static final int SIDEBAR_STYLE = 2;
    public static final int TITLE_BAR_STYLE = 3;
    public static final int MENU_STYLE = 4;
    public static final int POPOVER_STYLE = 5;
    public static final int MEDIUM_LIGHT_STYLE = 6;
    public static final int ULTRA_DARK_STYLE = 7;
    public static final int SHEET_STYLE = 8;
    public static final String BACKGROUND_STYLE_KEY = "Aqua.backgroundStyle";
    public static final String POPUP_BACKGROUND_STYLE_KEY = "AquaPopup.backgroundStyle";
    public static final String POPUP_CORNER_RADIUS_KEY = "AquaPopup.cornerRadius";
    public static final String VIBRANT_EFFECTS_KEY = "AquaInternal.vibrantEffects";
    public static final String VIBRANT_WINDOW_KEY = "AquaInternal.vibrantWindow";

    public static int parseVibrantStyle(Object s, boolean allowSidebar) {
        if (s instanceof String) {
            if (s.equals("vibrantLight")) {
                return 0;
            }
            if (s.equals("vibrantDark")) {
                return 1;
            }
            if (s.equals("vibrantSidebar")) {
                return allowSidebar ? 2 : 0;
            }
            if (s.equals("vibrantTitleBar")) {
                return 3;
            }
            if (s.equals("vibrantMenu")) {
                return 4;
            }
            if (s.equals("vibrantPopover")) {
                return 5;
            }
            if (s.equals("vibrantMediumLight")) {
                return 6;
            }
            if (s.equals("vibrantUltraDark")) {
                return 7;
            }
            if (s.equals("vibrantSheet")) {
                return 8;
            }
        }
        return -1;
    }

    public static boolean isVibrant(JComponent c) {
        Object o = c.getClientProperty(VIBRANT_EFFECTS_KEY);
        if (o != null) {
            return true;
        }
        return c instanceof JRootPane && (o = c.getClientProperty(VIBRANT_WINDOW_KEY)) != null;
    }

    public static boolean processVibrantStyleChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        JComponent c = (JComponent)evt.getSource();
        if (BACKGROUND_STYLE_KEY.equals(prop)) {
            AquaVibrantSupport.updateVibrantStyle(c);
            return true;
        }
        return false;
    }

    public static void updateVibrantStyle(JComponent c) {
        int style;
        Object o = c.getClientProperty(BACKGROUND_STYLE_KEY);
        if (o instanceof String && (style = AquaVibrantSupport.parseVibrantStyle(o, true)) >= 0) {
            AquaVibrantSupport.installVibrantStyle(c, style, null);
            return;
        }
        AquaVibrantSupport.uninstallVibrantStyle(c);
    }

    public static void installVibrantStyle(JComponent c, int style, SelectionBoundsTracker bt) {
        Object o = c.getClientProperty(VIBRANT_EFFECTS_KEY);
        if (o != null) {
            if (o instanceof VisualEffectView) {
                VisualEffectView effects = (VisualEffectView)o;
                if (effects.getStyle() == style) {
                    return;
                }
                effects.dispose();
            }
            c.putClientProperty(VIBRANT_EFFECTS_KEY, null);
        }
        ComponentVibrantEffects v = new ComponentVibrantEffects(c, style, bt);
        c.putClientProperty(VIBRANT_EFFECTS_KEY, v);
    }

    public static void uninstallVibrantStyle(JComponent c) {
        Object o = c.getClientProperty(VIBRANT_EFFECTS_KEY);
        if (o != null) {
            if (o instanceof VisualEffectView) {
                VisualEffectView effects = (VisualEffectView)o;
                effects.dispose();
            }
            c.putClientProperty(VIBRANT_EFFECTS_KEY, null);
        }
    }

    public static void addFullWindowVibrantView(Window w, int style) {
        boolean forceActive = w.getType() == Window.Type.POPUP || AquaVibrantSupport.isUndecorated(w);
        int rc = AquaVibrantSupport.setupVisualEffectWindow(w, style, forceActive);
        if (rc != 0) {
            System.err.println("Unable to install visual effect view");
        } else {
            JRootPane rp = AquaUtils.getRootPane(w);
            AquaUtils.setWindowBackgroundClear(w, true);
            if (rp != null) {
                rp.putClientProperty(VIBRANT_WINDOW_KEY, Boolean.TRUE);
                AquaUtils.paintImmediately(rp);
                AquaUtils.syncAWTView(w);
            }
        }
    }

    private static boolean isUndecorated(Window w) {
        if (w instanceof Frame) {
            return ((Frame)w).isUndecorated();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).isUndecorated();
        }
        return true;
    }

    public static void removeFullWindowVibrantView(Window w) {
        JRootPane rp;
        int rc = AquaVibrantSupport.removeVisualEffectWindow(w);
        if (rc != 0) {
            System.err.println("Unable to remove visual effect view");
        }
        if ((rp = AquaUtils.getRootPane(w)) != null && rp.getClientProperty(VIBRANT_WINDOW_KEY) != null) {
            AquaUtils.setWindowBackgroundClear(w, false);
            rp.repaint();
        }
    }

    public static VisualEffectViewPeer createVisualEffectView(Window w, int style, boolean supportSelections) {
        long ptr = AquaVibrantSupport.nativeCreateVisualEffectView(w, style, supportSelections);
        if (ptr != 0L) {
            AquaUtils.setWindowBackgroundClear(w, true);
            return new VisualEffectViewPeerImpl(w, ptr);
        }
        return null;
    }

    private static native int setupVisualEffectWindow(Window var0, int var1, boolean var2);

    private static native int removeVisualEffectWindow(Window var0);

    private static native long nativeCreateVisualEffectView(Window var0, int var1, boolean var2);

    private static native int setViewFrame(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int nativeUpdateSelectionBackgrounds(long var0, int[] var2);

    private static native int disposeVisualEffectView(long var0);

    private static class VisualEffectViewPeerImpl
    implements VisualEffectViewPeer {
        private Window w;
        private long nativeNSViewPointer;

        public VisualEffectViewPeerImpl(Window w, long nativeNSViewPointer) {
            this.w = w;
            this.nativeNSViewPointer = nativeNSViewPointer;
        }

        @Override
        public void dispose() {
            if (this.nativeNSViewPointer != 0L) {
                int rc = AquaVibrantSupport.disposeVisualEffectView(this.nativeNSViewPointer);
                this.nativeNSViewPointer = 0L;
                if (rc != 0) {
                    System.err.println("disposeVisualEffectView failed");
                }
                AquaUtils.setWindowBackgroundClear(this.w, false);
            }
        }

        @Override
        public void setFrame(int x, int y, int width, int height) {
            int yflipped = this.w.getHeight() - (y + height);
            int rc = AquaVibrantSupport.setViewFrame(this.nativeNSViewPointer, x, y, width, height, yflipped);
            if (rc != 0) {
                System.err.println("setViewFrame failed");
            }
        }

        @Override
        public void updateSelectionBackgrounds(SelectionBoundsDescription sd) {
            int rc = AquaVibrantSupport.nativeUpdateSelectionBackgrounds(this.nativeNSViewPointer, sd != null ? sd.getData() : null);
            if (rc != 0) {
                System.err.println("updateSelectionBackgrounds failed");
            }
        }
    }
}

