/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class ClientPropertyApplicator<T extends JComponent, N>
implements PropertyChangeListener {
    private final Map<String, Property<N>> properties = new HashMap<String, Property<N>>();

    public ClientPropertyApplicator(Property<N> ... propertyList) {
        for (Property<N> p : propertyList) {
            this.properties.put(p.name, p);
        }
    }

    void applyProperty(N target, String propName, Object value) {
        Property<N> property = this.properties.get(propName);
        if (property != null) {
            property.applyProperty(target, value);
        }
    }

    public void attachAndApplyClientProperties(T target) {
        ((Container)target).addPropertyChangeListener(this);
        N obj = this.convertJComponentToTarget(target);
        if (obj == null) {
            return;
        }
        Set<String> propNames = this.properties.keySet();
        for (String propName : propNames) {
            Object value = ((JComponent)target).getClientProperty(propName);
            if (value == null) continue;
            this.applyProperty(obj, propName, value);
        }
    }

    public void removeFrom(T target) {
        ((Component)target).removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        N obj = this.convertJComponentToTarget((JComponent)evt.getSource());
        if (obj == null) {
            return;
        }
        this.applyProperty(obj, evt.getPropertyName(), evt.getNewValue());
    }

    public N convertJComponentToTarget(T component) {
        return (N)component;
    }

    public static abstract class Property<X> {
        final String name;

        public Property(String name) {
            this.name = name;
        }

        public abstract void applyProperty(X var1, Object var2);
    }
}

