/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ComponentTracker {
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            boolean isDisplayable;
            Window w;
            long flags = e.getChangeFlags();
            if ((flags & 1L) != 0L) {
                w = SwingUtilities.getWindowAncestor(ComponentTracker.this.tracked);
                if (!Objects.equals(ComponentTracker.this.window, w)) {
                    Window oldWindow = ComponentTracker.this.window;
                    ComponentTracker.this.window = w;
                    ComponentTracker.this.windowIsDisplayable = w != null && w.isDisplayable();
                    ComponentTracker.this.windowChanged(oldWindow, ComponentTracker.this.window);
                }
            }
            if ((flags & 2L) != 0L && (w = SwingUtilities.getWindowAncestor(ComponentTracker.this.tracked)) != null && w == ComponentTracker.this.window && (isDisplayable = w.isDisplayable()) != ComponentTracker.this.windowIsDisplayable) {
                ComponentTracker.this.windowIsDisplayable = isDisplayable;
                ComponentTracker.this.windowChanged(ComponentTracker.this.window, ComponentTracker.this.window);
            }
            if ((flags & 4L) != 0L) {
                ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
            }
        }
    };
    private final HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }
    };
    private final ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent e) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }
    };
    private Component tracked;
    private Window window;
    private boolean windowIsDisplayable;

    public void attach(JComponent c) {
        if (this.tracked != c) {
            if (this.tracked != null) {
                Window w = this.window;
                this.tracked.removeHierarchyListener(this.hierarchyListener);
                this.tracked.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
                this.tracked.removeComponentListener(this.componentListener);
                this.tracked = null;
                this.window = null;
                this.windowIsDisplayable = false;
                this.detached(w);
            }
            if (c != null) {
                this.tracked = c;
                this.tracked.addHierarchyListener(this.hierarchyListener);
                this.tracked.addHierarchyBoundsListener(this.hierarchyBoundsListener);
                this.tracked.addComponentListener(this.componentListener);
                this.window = SwingUtilities.getWindowAncestor(this.tracked);
                this.windowIsDisplayable = this.window != null && this.window.isDisplayable();
                this.attached(this.window);
            }
        }
    }

    protected void detached(Window w) {
    }

    protected void attached(Window w) {
    }

    protected void windowChanged(Window oldWindow, Window newWindow) {
    }

    protected void visibleBoundsChanged(Window window) {
    }
}

