/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.violetlib.aqua.AquaNativeSupport;

public class OSXSystemProperties {
    public static final int OSVersion = OSXSystemProperties.getOSVersion();
    private static boolean hasBeenSynchronized;
    private static boolean isFullKeyboardAccessEnabled;
    private static boolean useOverlayScrollBars;
    private static boolean reduceTransparency;
    private static final List<ChangeListener> changeListeners;

    private static int getOSVersion() {
        String s = System.getProperty("os.version");
        int p = s.indexOf(46);
        int major = Integer.parseInt(s.substring(0, p));
        int minor = Integer.parseInt((p = (s = s.substring(p + 1)).indexOf(46)) >= 0 ? s.substring(0, p) : s);
        return major * 100 + minor;
    }

    public static boolean isFullKeyboardAccessEnabled() {
        OSXSystemProperties.ensureSynchronized();
        return isFullKeyboardAccessEnabled;
    }

    public static boolean isReduceTransparency() {
        OSXSystemProperties.ensureSynchronized();
        return reduceTransparency;
    }

    public static boolean doScrollPanesSupportRTL() {
        return false;
    }

    public static boolean isShowAllFiles() {
        if (AquaNativeSupport.load()) {
            return OSXSystemProperties.nativeGetShowAllFiles();
        }
        return false;
    }

    public static boolean useOverlayScrollBars() {
        OSXSystemProperties.ensureSynchronized();
        return useOverlayScrollBars;
    }

    public static boolean isScrollToClick() {
        if (AquaNativeSupport.load()) {
            return OSXSystemProperties.nativeGetScrollToClick();
        }
        return false;
    }

    public static synchronized void addChangeListener(ChangeListener l) {
        if (!changeListeners.contains(l)) {
            changeListeners.add(l);
        }
    }

    public static synchronized void removeChangeListener(ChangeListener l) {
        changeListeners.remove(l);
    }

    private static void fireChangeEvent() {
        if (!changeListeners.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangeEvent event = new ChangeEvent(OSXSystemProperties.class);
                    for (ChangeListener listener : changeListeners) {
                        listener.stateChanged(event);
                    }
                }
            });
        }
    }

    private static void ensureSynchronized() {
        if (!hasBeenSynchronized) {
            if (AquaNativeSupport.load()) {
                OSXSystemProperties.synchronize();
                Runnable synchronizer = new Runnable(){

                    @Override
                    public void run() {
                        OSXSystemProperties.synchronize();
                    }
                };
                OSXSystemProperties.enableCallback(synchronizer);
            } else {
                hasBeenSynchronized = true;
            }
        }
    }

    private static synchronized void synchronize() {
        boolean oldFullKeyboardAccessEnabled = isFullKeyboardAccessEnabled;
        isFullKeyboardAccessEnabled = OSXSystemProperties.nativeGetFullKeyboardAccessEnabled();
        boolean oldUseOverlayScrollBars = useOverlayScrollBars;
        useOverlayScrollBars = OSXSystemProperties.nativeGetUseOverlayScrollBars();
        boolean oldReduceTransparency = reduceTransparency;
        reduceTransparency = OSXSystemProperties.nativeGetReduceTransparency();
        if (hasBeenSynchronized && isFullKeyboardAccessEnabled != oldFullKeyboardAccessEnabled || useOverlayScrollBars != oldUseOverlayScrollBars || reduceTransparency != oldReduceTransparency) {
            OSXSystemProperties.fireChangeEvent();
        }
        hasBeenSynchronized = true;
    }

    private static native boolean nativeGetFullKeyboardAccessEnabled();

    private static native boolean nativeGetShowAllFiles();

    private static native boolean nativeGetScrollToClick();

    private static native boolean nativeGetUseOverlayScrollBars();

    private static native boolean nativeGetReduceTransparency();

    private static native void enableCallback(Runnable var0);

    static {
        changeListeners = new ArrayList<ChangeListener>();
    }
}

