/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ComponentTracker;

public abstract class OverlayPainterComponent
extends JComponent {
    protected final Insets margins;
    private final Integer layer;
    private final ComponentTracker tracker;
    private Component base;
    private Rectangle baseBounds;
    private Rectangle visibleBounds;
    private Window baseWindow;

    public OverlayPainterComponent(Insets margins, int layer) {
        this.margins = margins;
        this.layer = layer;
        this.tracker = new ComponentTracker(){

            @Override
            protected void attached(Window w) {
                if (w != null) {
                    OverlayPainterComponent.this.windowChanged(w);
                    OverlayPainterComponent.this.visibleBoundsChanged();
                }
            }

            @Override
            protected void windowChanged(Window oldWindow, Window newWindow) {
                OverlayPainterComponent.this.windowChanged(newWindow);
            }

            @Override
            protected void visibleBoundsChanged(Window window) {
                OverlayPainterComponent.this.visibleBoundsChanged();
            }
        };
        super.setOpaque(false);
        this.setVisible(false);
    }

    public void attach(JComponent c) {
        if (this.base != c) {
            if (c != null) {
                this.base = c;
                this.tracker.attach(c);
                this.setVisible(true);
                this.repaint();
            } else {
                this.setVisible(false);
                if (this.base != null) {
                    this.tracker.attach(null);
                    this.base = null;
                }
            }
        }
    }

    @Override
    public final void setOpaque(boolean b) {
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    private void windowChanged(Window newWindow) {
        if (newWindow == this.baseWindow) {
            return;
        }
        JRootPane orp = AquaUtils.getRootPane(this.baseWindow);
        JRootPane nrp = AquaUtils.getRootPane(newWindow);
        this.baseWindow = newWindow;
        if (orp != null) {
            Container p = this.getParent();
            p.remove(this);
        }
        if (nrp != null) {
            JLayeredPane lp = nrp.getLayeredPane();
            lp.add((Component)this, this.layer);
            this.visibleBoundsChanged();
        }
    }

    private void visibleBoundsChanged() {
        JRootPane rp = AquaUtils.getRootPane(this.baseWindow);
        if (rp == null || this.base == null || !this.base.isVisible()) {
            this.baseBounds = null;
            this.visibleBounds = null;
            return;
        }
        Dimension baseSize = this.base.getSize();
        if (baseSize.width == 0 || baseSize.height == 0) {
            this.baseBounds = null;
            this.visibleBounds = null;
            return;
        }
        JLayeredPane lp = rp.getLayeredPane();
        Point baseLoc = SwingUtilities.convertPoint(this.base.getParent(), this.base.getLocation(), lp);
        int x = baseLoc.x - this.margins.left;
        int y = baseLoc.y - this.margins.top;
        int width = baseSize.width + this.margins.left + this.margins.right;
        int height = baseSize.height + this.margins.top + this.margins.bottom;
        if (x != this.getX() || y != this.getY() || width != this.getWidth() || height != this.getHeight()) {
            super.setBounds(x, y, width, height);
            this.repaint();
        }
        this.baseBounds = new Rectangle(this.margins.left, this.margins.top, baseSize.width, baseSize.height);
        this.visibleBounds = OverlayPainterComponent.getVisibleBounds(this.base);
        if (this.visibleBounds != null) {
            this.visibleBounds = new Rectangle(this.visibleBounds.x + this.margins.left, this.visibleBounds.y + this.margins.top, this.visibleBounds.width, this.visibleBounds.height);
        }
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (this.visibleBounds != null) {
            Graphics2D gg = (Graphics2D)g.create();
            gg.setClip(-1000, -1000, 1000000, 1000000);
            gg.clip(this.visibleBounds);
            gg.translate(this.baseBounds.x, this.baseBounds.y);
            this.internalPaint(gg);
        }
    }

    protected abstract void internalPaint(Graphics2D var1);

    protected static Rectangle getVisibleBounds(Component base) {
        int x = 0;
        int y = 0;
        Component c = base;
        while (c.isVisible()) {
            if (c instanceof JRootPane) {
                Dimension size = c.getSize();
                return new Rectangle(x, y, size.width, size.height);
            }
            if (c instanceof JViewport) {
                JViewport p = (JViewport)c;
                Rectangle bounds = p.getVisibleRect();
                return new Rectangle(x + bounds.x, y + bounds.y, bounds.width, bounds.height);
            }
            Container parent = c.getParent();
            if (parent == null) {
                return null;
            }
            x -= c.getX();
            y -= c.getY();
            c = parent;
        }
        return null;
    }
}

