/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OverlayScrollPaneHack {
    protected JScrollPane scrollPane;
    protected AquaOverlayViewportHolder holder;
    protected JViewport lastKnownViewport;
    protected Component lastKnownView;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener viewportChangeListener;

    public OverlayScrollPaneHack(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.lastKnownViewport = scrollPane.getViewport();
        this.lastKnownView = this.lastKnownViewport != null ? SwingUtilities.getUnwrappedView(this.lastKnownViewport) : null;
        this.propertyChangeListener = new MyPropertyChangeListener();
        this.viewportChangeListener = new MyViewportChangeListener();
        this.holder = new AquaOverlayViewportHolder();
        this.holder.setBounds(0, 0, scrollPane.getWidth(), scrollPane.getHeight());
        scrollPane.add(this.holder);
        scrollPane.repaint();
        this.sync(true);
        scrollPane.addPropertyChangeListener(this.propertyChangeListener);
        if (this.lastKnownViewport != null) {
            this.lastKnownViewport.addChangeListener(this.viewportChangeListener);
        }
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            this.scrollPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.viewportChangeListener != null) {
            if (this.lastKnownViewport != null) {
                this.lastKnownViewport.removeChangeListener(this.viewportChangeListener);
            }
            this.viewportChangeListener = null;
        }
        if (this.lastKnownView instanceof JTable) {
            this.scrollPane.setColumnHeaderView(null);
        }
        if (this.holder != null) {
            JScrollBar vsb;
            JScrollBar hsb;
            JViewport viewport = this.scrollPane.getViewport();
            if (viewport != null && viewport.getParent() == this.holder) {
                this.scrollPane.add(viewport);
            }
            if ((hsb = this.scrollPane.getHorizontalScrollBar()) != null) {
                this.scrollPane.add(hsb);
            }
            if ((vsb = this.scrollPane.getVerticalScrollBar()) != null) {
                this.scrollPane.add(vsb);
            }
            this.scrollPane.remove(this.holder);
            this.holder = null;
        }
    }

    protected void sync(boolean isNewHolder) {
        Component view;
        JViewport viewport = this.scrollPane.getViewport();
        if (viewport != this.lastKnownViewport) {
            if (this.lastKnownViewport != null) {
                this.lastKnownViewport.removeChangeListener(this.viewportChangeListener);
                if (this.holder != null) {
                    this.holder.remove(this.lastKnownViewport);
                }
            }
            if (viewport != null) {
                viewport.addChangeListener(this.viewportChangeListener);
            }
            this.lastKnownViewport = viewport;
        }
        if (this.holder != null && viewport != null && viewport.getParent() != this.holder) {
            this.holder.add(viewport);
            this.scrollPane.revalidate();
        }
        Component component = view = viewport != null ? SwingUtilities.getUnwrappedView(viewport) : null;
        if (this.holder != null && (isNewHolder || view != this.lastKnownView)) {
            if (view instanceof JTable) {
                JTable t = (JTable)view;
                this.scrollPane.setColumnHeaderView(t.getTableHeader());
            } else if (this.lastKnownView instanceof JTable) {
                this.scrollPane.setColumnHeaderView(null);
            }
        }
        this.lastKnownView = view;
    }

    public void syncScrollPaneSize() {
        if (this.holder != null) {
            this.holder.setBounds(0, 0, this.scrollPane.getWidth(), this.scrollPane.getHeight());
        }
    }

    public void reconfigure(JScrollBar sb, String which) {
        if (this.holder != null) {
            this.scrollPane.remove(sb);
            this.holder.remove(sb);
            this.holder.add((Component)sb, 0);
        }
    }

    protected class AquaOverlayViewportHolder
    extends JComponent {
        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    }

    protected class MyViewportChangeListener
    implements ChangeListener {
        private Component lastKnownView;

        protected MyViewportChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component view;
            JViewport v = OverlayScrollPaneHack.this.scrollPane.getViewport();
            if (v != null && (view = SwingUtilities.getUnwrappedView(v)) != this.lastKnownView) {
                OverlayScrollPaneHack.this.sync(false);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name != null && name.equals("viewport")) {
                OverlayScrollPaneHack.this.sync(false);
            }
        }
    }
}

