/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;

public abstract class TreeSelectionBoundsTracker
implements SelectionBoundsTracker {
    protected JTree tree;
    protected Consumer<SelectionBoundsDescription> consumer;
    private SelectionBoundsDescription currentSelectionDescription;

    public TreeSelectionBoundsTracker(JTree tree, Consumer<SelectionBoundsDescription> consumer) {
        this.tree = tree;
        this.consumer = consumer;
        this.update();
        if (consumer != null && this.currentSelectionDescription == null) {
            consumer.accept(null);
        }
    }

    @Override
    public void dispose() {
        this.tree = null;
        this.consumer = null;
    }

    @Override
    public void reset() {
        if (this.currentSelectionDescription != null) {
            this.currentSelectionDescription = null;
            if (this.consumer != null) {
                this.consumer.accept(null);
            }
        }
    }

    @Override
    public void setConsumer(Consumer<SelectionBoundsDescription> consumer) {
        if (consumer != this.consumer) {
            this.consumer = consumer;
            if (consumer != null) {
                consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    @Override
    public void update() {
        if (this.tree != null) {
            int[] selectedRows;
            TreeSelectionModel sm = this.tree.getSelectionModel();
            int[] nArray = selectedRows = sm != null ? sm.getSelectionRows() : null;
            if (selectedRows != null && selectedRows.length == 0) {
                selectedRows = null;
            }
            this.updateFromSelectedRows(selectedRows);
        }
    }

    protected void updateFromSelectedRows(int[] rows) {
        SelectionBoundsDescription newSelectionDescription = this.createSelectionDescription(rows);
        if (!Objects.equals(newSelectionDescription, this.currentSelectionDescription)) {
            this.currentSelectionDescription = newSelectionDescription;
            if (this.consumer != null) {
                this.consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    private SelectionBoundsDescription createSelectionDescription(int[] rows) {
        if (rows == null) {
            return null;
        }
        SelectionBoundsDescription sd = new SelectionBoundsDescription(rows.length);
        for (int row : rows) {
            Rectangle bounds = this.tree.getRowBounds(row);
            int y = this.convertRowYCoordinateToSelectionDescription(bounds.y);
            sd.addRegion(y, bounds.height);
        }
        return sd;
    }

    protected int convertRowYCoordinateToSelectionDescription(int y) {
        return y;
    }
}

