/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.violetlib.aqua.GenericList;
import org.violetlib.treetable.TreeTable;

public class TreeTableModel
implements GenericList {
    protected final TreeTable tt;
    protected final int designatedColumnIndex;

    public TreeTableModel(TreeTable tt) {
        this.tt = tt;
        this.designatedColumnIndex = tt.getHierarchicalColumn();
    }

    @Override
    public JComponent getComponent() {
        return this.tt;
    }

    @Override
    public void requestFocus() {
        if (this.tt.isEnabled() && this.tt.isRequestFocusEnabled()) {
            this.tt.requestFocusInWindow();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.tt.isEnabled();
    }

    @Override
    public int getRowCount() {
        return this.tt.getRowCount();
    }

    @Override
    public Object getRow(int index) {
        return this.tt.getValueAt(index, this.designatedColumnIndex);
    }

    @Override
    public boolean isMultipleSelection() {
        return this.tt.getSelectionModel().getSelectionMode() != 0;
    }

    @Override
    public boolean isRowSelected(int index) {
        return this.tt.isRowSelected(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.tt.getSelectionModel().isSelectionEmpty();
    }

    @Override
    public void clearSelection() {
        this.tt.clearSelection();
    }

    @Override
    public void setSelectionInterval(int index1, int index2) {
        this.tt.setSelectionInterval(index1, index2);
    }

    @Override
    public void addSelectionInterval(int index1, int index2) {
        this.tt.addSelectionInterval(index1, index2);
    }

    @Override
    public void removeSelectionInterval(int index1, int index2) {
        this.tt.removeSelectionInterval(index1, index2);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.tt.getRowSelectionModel().getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.tt.getRowSelectionModel().setAnchorSelectionIndex(index);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.tt.getRowSelectionModel().getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.tt.getRowSelectionModel().getMaxSelectionIndex();
    }

    @Override
    public boolean isValueAdjusting() {
        return this.tt.getRowSelectionModel().getValueIsAdjusting();
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.tt.getRowSelectionModel().setValueIsAdjusting(b);
    }

    @Override
    public int identifyRowAtLocation(Point loc) {
        return this.tt.rowAtPoint(loc);
    }

    @Override
    public void scrollToViewRows(int index1, int index2) {
        int columnCount = this.tt.getColumnCount();
        Rectangle r1 = this.tt.getCellRect(index1, 0, false);
        Rectangle r2 = this.tt.getCellRect(index2, columnCount - 1, false);
        this.tt.scrollRectToVisible(r1.union(r2));
    }

    @Override
    public boolean isDragEnabled() {
        return this.tt.getDragEnabled();
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.tt.getTransferHandler();
    }
}

