/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.ComponentTracker;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.VisualEffectViewPeer;

public class VisualEffectView {
    private final JComponent component;
    private final int style;
    private final boolean supportSelections;
    private VisualEffectViewPeer peer;
    private Rectangle oldBounds;
    private Window window;
    private int windowHeight;
    private ComponentTracker tracker;

    public VisualEffectView(JComponent c, int style, boolean supportSelections) {
        this.component = c;
        this.style = style;
        this.supportSelections = supportSelections;
        this.tracker = new MyComponentTracker();
        this.tracker.attach(this.component);
    }

    public int getStyle() {
        return this.style;
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.attach(null);
            this.tracker = null;
        }
    }

    public void updateSelectionBackgrounds(SelectionBoundsDescription sd) {
        if (this.peer != null && this.supportSelections) {
            this.peer.updateSelectionBackgrounds(sd);
        }
    }

    protected void windowChanged(Window newWindow) {
        if (newWindow != null && !newWindow.isDisplayable()) {
            newWindow = null;
        }
        if (newWindow != this.window) {
            if (this.window != null && this.peer != null) {
                this.peer.dispose();
                this.peer = null;
            }
            this.window = newWindow;
            this.oldBounds = null;
            if (this.window != null) {
                this.peer = AquaVibrantSupport.createVisualEffectView(this.window, this.style, this.supportSelections);
                this.visibleBoundsChanged();
            }
        }
    }

    protected void visibleBoundsChanged() {
        Rectangle bounds = VisualEffectView.getVisibleBounds(this.component);
        if (bounds != null && bounds.width > 0 && bounds.height > 0) {
            this.setFrame(bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            this.setFrame(0, 0, 0, 0);
        }
    }

    private void setFrame(int x, int y, int w, int h) {
        int newWindowHeight;
        int n = newWindowHeight = this.window != null ? this.window.getHeight() : 0;
        if (this.oldBounds == null || x != this.oldBounds.x || y != this.oldBounds.y || w != this.oldBounds.width || h != this.oldBounds.height || this.windowHeight != newWindowHeight) {
            this.oldBounds = new Rectangle(x, y, w, h);
            this.windowHeight = newWindowHeight;
            if (this.peer != null) {
                this.peer.setFrame(x, y, w, h);
            }
        }
    }

    protected static Rectangle getVisibleBounds(Component tc) {
        Component c = tc;
        Rectangle bounds = c.getBounds();
        Window w = SwingUtilities.getWindowAncestor(c);
        while (true) {
            if (!c.isVisible()) {
                return null;
            }
            if (c instanceof JRootPane) break;
            if (c instanceof JViewport && c != tc) {
                JViewport p = (JViewport)c;
                bounds = p.getBounds();
                return SwingUtilities.convertRectangle(p.getParent(), bounds, w);
            }
            Container parent = c.getParent();
            if (parent == null) {
                return null;
            }
            c = parent;
        }
        return SwingUtilities.convertRectangle(tc.getParent(), bounds, w);
    }

    private class MyComponentTracker
    extends ComponentTracker {
        private MyComponentTracker() {
        }

        @Override
        protected void attached(Window w) {
            if (w != null) {
                VisualEffectView.this.windowChanged(w);
                VisualEffectView.this.visibleBoundsChanged();
            }
        }

        @Override
        protected void detached(Window w) {
            if (VisualEffectView.this.window != null) {
                VisualEffectView.this.windowChanged(null);
            }
        }

        @Override
        protected void windowChanged(Window oldWindow, Window newWindow) {
            VisualEffectView.this.windowChanged(newWindow);
        }

        @Override
        protected void visibleBoundsChanged(Window window) {
            if (window != null) {
                VisualEffectView.this.visibleBoundsChanged();
            }
        }
    }
}

