/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class WindowDraggingMouseListener
extends MouseInputAdapter {
    private Window w;
    private int xOffset;
    private int yOffset;

    public void attach(JComponent c) {
        if (c != null) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
        }
    }

    public void detach(JComponent c) {
        if (c != null) {
            c.removeMouseListener(this);
            c.removeMouseMotionListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p;
        Component c = e.getComponent();
        Window ancestor = SwingUtilities.getWindowAncestor(c);
        if (ancestor != null && this.isDragArea(c, p = e.getPoint())) {
            this.w = ancestor;
            this.xOffset = e.getX();
            this.yOffset = e.getY();
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.w != null) {
            this.w = null;
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.w != null) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            int x = p.x - this.xOffset;
            int y = p.y - this.yOffset;
            this.w.setLocation(x, y);
            e.consume();
        }
    }

    protected boolean isDragArea(Component c, Point p) {
        return true;
    }
}

