/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.violetlib.aqua.fc.AquaFileChooserBrowserListUI;
import org.violetlib.aqua.fc.AquaFileChooserListMouseBehavior;
import org.violetlib.aqua.fc.JBrowser;

public class AquaFileChooserBrowser
extends JBrowser {
    protected final JFileChooser fc;
    protected final ColumnScrollPaneMouseWheelListener columnScrollPaneMouseWheelListener;

    public AquaFileChooserBrowser(JFileChooser fc) {
        this.fc = fc;
        this.columnScrollPaneMouseWheelListener = new ColumnScrollPaneMouseWheelListener();
    }

    @Override
    protected ListUI getColumnListUI(ListUI basicUI) {
        AquaFileChooserBrowserListUI ui = new AquaFileChooserBrowserListUI(this.fc);
        ui.setFileSelectionHandler(new AquaFileChooserListMouseBehavior.FileSelectionHandler(){

            @Override
            public void fileSelected(File f) {
                AquaFileChooserBrowser.this.fileSelectedInSavePanel(f);
            }
        });
        return ui;
    }

    @Override
    protected JScrollPane createScrollPane(JComponent c, int columnIndex) {
        JScrollPane sp = super.createScrollPane(c, columnIndex);
        sp.addMouseWheelListener(this.columnScrollPaneMouseWheelListener);
        return sp;
    }

    protected void fileSelectedInSavePanel(File f) {
    }

    protected class ColumnScrollPaneMouseWheelListener
    implements MouseWheelListener {
        protected ColumnScrollPaneMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JScrollPane browserScrollPane;
            if (e.isShiftDown() && (browserScrollPane = this.getBrowserScrollPane(e.getComponent())) != null) {
                MouseWheelEvent ce = (MouseWheelEvent)SwingUtilities.convertMouseEvent(e.getComponent(), e, browserScrollPane);
                browserScrollPane.dispatchEvent(ce);
            }
        }

        protected JScrollPane getBrowserScrollPane(Component c) {
            Container p;
            while ((p = c.getParent()) != null && !(p instanceof JFileChooser)) {
                if (p instanceof JScrollPane) {
                    return (JScrollPane)p;
                }
                c = p;
            }
            return null;
        }
    }
}

