/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.GenericList;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.JBrowser;

public class AquaFileChooserListMouseBehavior
extends AquaListMouseBehavior {
    protected final JFileChooser fc;
    protected FileSelectionHandler fileSelectionHandler;
    protected final int OP_INSTALL_NAME = 1000;
    protected boolean isAcceptableTarget;
    protected boolean isTraversableDirectory;

    public AquaFileChooserListMouseBehavior(JFileChooser fc, GenericList list) {
        super(list);
        this.fc = fc;
    }

    public void setFileSelectionHandler(FileSelectionHandler h) {
        this.fileSelectionHandler = h;
    }

    @Override
    protected void interpretLocation(MouseEvent e) {
        this.targetIndex = this.getIndex(e);
        this.dragWouldTransfer = this.list.isDragEnabled();
        this.isAcceptableTarget = this.isAcceptableTarget(this.targetIndex);
        this.isTraversableDirectory = this.isTraversable(this.targetIndex);
    }

    @Override
    protected int getSelectionOperation(MouseEvent e) {
        int op = super.getSelectionOperation(e);
        if (this.fc.getDialogType() == 1) {
            if (op == 1) {
                return this.isTraversableDirectory ? 1 : 1000;
            }
            return 0;
        }
        if (op == 3 && !this.isAcceptableTarget && this.isTraversableDirectory) {
            return this.list.isSelectionEmpty() || this.list.isRowSelected(this.targetIndex) ? op : 0;
        }
        if (op == 3 && this.isAcceptableTarget && !this.isTraversableDirectory && this.shouldDeselectDirectory()) {
            return 1;
        }
        return op;
    }

    private boolean shouldDeselectDirectory() {
        if (!this.fc.isMultiSelectionEnabled()) {
            return false;
        }
        if (this.fc.isDirectorySelectionEnabled()) {
            return false;
        }
        if (this.list.isRowSelected(this.targetIndex)) {
            return false;
        }
        if (this.list.isSelectionEmpty()) {
            return false;
        }
        int minIndex = this.list.getMinSelectionIndex();
        int maxIndex = this.list.getMaxSelectionIndex();
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (!this.list.isRowSelected(index) || !this.isTraversable(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performSelectionOperation(int op) {
        if (op == 1000) {
            File f = this.getFile(this.targetIndex);
            if (f != null && this.fileSelectionHandler != null) {
                this.fileSelectionHandler.fileSelected(f);
            }
        } else {
            super.performSelectionOperation(op);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.mouseReleaseOp == 1 && !this.isAcceptableTarget && !this.isTraversableDirectory) {
            this.mouseReleaseOp = 0;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JBrowser b;
        super.mouseReleased(e);
        if (this.list.isSelectionEmpty() && (b = this.findBrowser(this.list.getComponent())) != null) {
            b.requestFocus();
        }
    }

    private JBrowser findBrowser(Component c) {
        while (c != null) {
            if (c instanceof JBrowser) {
                return (JBrowser)c;
            }
            c = c.getParent();
        }
        return null;
    }

    private boolean isAcceptableTarget(int index) {
        Object e;
        if (index >= 0 && (e = this.list.getRow(index)) instanceof FileInfo) {
            FileInfo fi = (FileInfo)e;
            return fi.isAcceptable();
        }
        return false;
    }

    private boolean isTraversable(int index) {
        Object e;
        if (index >= 0 && (e = this.list.getRow(index)) instanceof FileInfo) {
            FileInfo fi = (FileInfo)e;
            return fi.isTraversable();
        }
        return false;
    }

    @Override
    protected void trimSelectedInterval(int index, int direction) {
        block4: {
            block5: {
                if (direction <= 0) break block5;
                int count = this.list.getRowCount();
                while (++index < count) {
                    if (this.list.isRowSelected(index)) {
                        this.list.removeSelectionInterval(index, index);
                        continue;
                    }
                    if (!this.isAcceptableTarget(index)) continue;
                    break block4;
                }
                break block4;
            }
            if (direction >= 0) break block4;
            while (--index >= 0) {
                if (this.list.isRowSelected(index)) {
                    this.list.removeSelectionInterval(index, index);
                    continue;
                }
                if (!this.isAcceptableTarget(index)) continue;
                break;
            }
        }
    }

    @Override
    protected void setSelectionInterval(int index1, int index2) {
        if (index1 == index2) {
            if (this.isAcceptableTarget(index1) || this.isTraversable(index1)) {
                this.list.setSelectionInterval(index1, index1);
            }
            return;
        }
        boolean old = this.list.isValueAdjusting();
        this.list.setValueIsAdjusting(true);
        this.list.clearSelection();
        int delta = index2 > index1 ? -1 : 1;
        int index = index2;
        while (true) {
            if (this.isAcceptableTarget(index)) {
                this.list.addSelectionInterval(index, index);
            }
            if (index == index1) break;
            index += delta;
        }
        this.list.setValueIsAdjusting(old);
    }

    @Override
    protected void addSelectionInterval(int index1, int index2) {
        int delta = index1 > index2 ? -1 : 1;
        int index = index1;
        while (true) {
            if (this.isAcceptableTarget(index)) {
                this.list.addSelectionInterval(index, index);
            } else {
                this.list.removeSelectionInterval(index, index);
            }
            if (index == index2) {
                return;
            }
            index += delta;
        }
    }

    @Override
    protected void toggleSelectionInterval(int index1, int index2) {
        int delta = index1 > index2 ? -1 : 1;
        int index = index1;
        while (true) {
            if (this.isAcceptableTarget(index) && !this.list.isRowSelected(index)) {
                this.list.addSelectionInterval(index, index);
            } else {
                this.list.removeSelectionInterval(index, index);
            }
            if (index == index2) {
                return;
            }
            index += delta;
        }
    }

    private File getFile(int index) {
        Object e;
        if (index >= 0 && (e = this.list.getRow(index)) instanceof FileInfo) {
            FileInfo fi = (FileInfo)e;
            return fi.getFile();
        }
        return null;
    }

    public static interface FileSelectionHandler {
        public void fileSelected(File var1);
    }
}

