/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaTreeTableUI;
import org.violetlib.aqua.TreeTableModel;
import org.violetlib.aqua.fc.AquaFileChooserListMouseBehavior;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.SubtreeTreeModel;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.ui.BasicTreeTableUI;

public abstract class AquaFileChooserTreeTableUI
extends AquaTreeTableUI {
    protected AquaFileChooserListMouseBehavior mouseBehavior;

    public AquaFileChooserTreeTableUI(JFileChooser fc, final TreeTable tt) {
        this.mouseBehavior = new AquaFileChooserListMouseBehavior(fc, new TreeTableModel(tt));
        this.mouseBehavior.setFileSelectionHandler(new AquaFileChooserListMouseBehavior.FileSelectionHandler(){

            @Override
            public void fileSelected(File f) {
                SubtreeTreeModel model = (SubtreeTreeModel)tt.getTreeModel();
                FileSystemTreeModel fullModel = (FileSystemTreeModel)model.getTargetModel();
                TreePath path = fullModel.toPath(f, null);
                AquaFileChooserTreeTableUI.this.select(path);
            }
        });
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree tree = super.createAndConfigureTree();
        tree.putClientProperty("JTree.isCellFilled", true);
        return tree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable table = super.createAndConfigureTable();
        table.putClientProperty("JTable.style", "striped");
        return table;
    }

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return new MyHandler();
    }

    @Override
    protected void installListeners() {
        JTree tree;
        InputMap newMap;
        super.installListeners();
        JTable table = this.getTable();
        InputMap map = table.getInputMap(1).getParent();
        KeyStroke ks = KeyStroke.getKeyStroke("shift meta A");
        Object v = map.get(ks);
        if (v != null && v.equals("clearSelection")) {
            newMap = new InputMap();
            newMap.setParent(map);
            newMap.put(ks, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(table, 0, newMap);
        }
        if ((v = (map = (tree = this.getTree()).getInputMap(0).getParent()).get(ks = KeyStroke.getKeyStroke("shift meta A"))) != null && v.equals("clearSelection")) {
            newMap = new InputMap();
            newMap.setParent(map);
            newMap.put(ks, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(tree, 0, newMap);
        }
    }

    @Override
    protected void handleDoubleClick(TreePath path) {
        FileInfo info;
        Object node = path.getLastPathComponent();
        if (node instanceof FileInfo && ((info = (FileInfo)node).isAcceptable() || info.isTraversable())) {
            this.select(path);
        }
    }

    protected abstract void select(TreePath var1);

    protected class MyHandler
    extends AquaTreeTableUI.MyHandler {
        protected MyHandler() {
        }

        @Override
        protected void dispatchMouseEvent(MouseEvent e, JComponent c) {
            TreePath path;
            int id = e.getID();
            if (id == 500 && e.getClickCount() == 2 && (path = AquaFileChooserTreeTableUI.this.treeTable.getPathForLocation(e.getX(), e.getY())) != null) {
                AquaFileChooserTreeTableUI.this.handleDoubleClick(path);
                e.consume();
                return;
            }
            JTable table = AquaFileChooserTreeTableUI.this.getTable();
            if (c == table) {
                AquaFileChooserTreeTableUI.this.mouseBehavior.processMouseEvent(e);
                return;
            }
            super.dispatchMouseEvent(e, c);
        }
    }
}

