/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaComboBoxRendererInternal;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaSheetSupport;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.ColumnView;
import org.violetlib.aqua.fc.FileChooserView;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileRenderer;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.FileTransferHandler;
import org.violetlib.aqua.fc.FilenameDocument;
import org.violetlib.aqua.fc.ListView;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SavedSearchFileSystemTreeModel;
import org.violetlib.aqua.fc.SidebarTreeFileNode;
import org.violetlib.aqua.fc.SidebarTreeModel;
import org.violetlib.aqua.fc.SubtreeTreeModel;
import org.violetlib.aqua.fc.ViewModeControl;

public class AquaFileChooserUI
extends BasicFileChooserUI {
    public static final String PACKAGE_TRAVERSABLE_PROPERTY = "JFileChooser.packageIsTraversable";
    public static final String APPLICATION_TRAVERSABLE_PROPERTY = "JFileChooser.appBundleIsTraversable";
    private JFileChooser fc;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private Action optionsAction = new OptionsAction();
    private FileView fileView;
    private FilterComboBoxModel filterComboBoxModel;
    private FileSystemTreeModel model = null;
    private SubtreeTreeModel subtreeModel = null;
    private static final boolean isOptionsAvailable = OSXSystemProperties.OSVersion >= 1011;
    private boolean isOptionsEnabled = !isOptionsAvailable;
    private Map<File, FileSystemTreeModel> savedSearches;
    private FileSystemTreeModel fileSystemModel = null;
    protected String optionsButtonText = null;
    protected String optionsButtonToolTipText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private String newFolderButtonText = null;
    private String newFolderToolTipText = null;
    protected String chooseButtonText = null;
    private String newFolderDialogPrompt;
    private String newFolderDefaultName;
    private String newFolderErrorText;
    private String newFolderExistsErrorText;
    private String newFolderTitleText;
    private String goToFolderDialogPrompt;
    private String goToFolderCancelButtonText;
    private String goToFolderAcceptButtonText;
    private String goToFolderErrorText;
    private String defaultInitialSaveFileName;
    private SidebarTreeModel sidebarTreeModel;
    private HierarchyListener hierarchyListener;
    private FileTransferHandler fileTransferHandler;
    private Action newFolderAction = new NewFolderAction();
    private Action approveSelectionAction = new AquaApproveSelectionAction();
    private int isAdjusting = 0;
    private int viewMode = 2;
    private boolean isViewInstalled;
    private FileChooserView activeView;
    private static String goToFolderText = "";
    private KeyStroke[] KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(65, 5), KeyStroke.getKeyStroke(67, 5), KeyStroke.getKeyStroke(68, 4), KeyStroke.getKeyStroke(68, 5), KeyStroke.getKeyStroke(71, 5), KeyStroke.getKeyStroke(72, 5), KeyStroke.getKeyStroke(73, 5), KeyStroke.getKeyStroke(79, 5), KeyStroke.getKeyStroke(75, 5), KeyStroke.getKeyStroke(85, 5), KeyStroke.getKeyStroke(46, 5)};
    private AbstractAction keyListenerAction = new KeyListenerAction();
    protected JPanel fileNamePanel;
    protected JLabel fileNameLabel;
    protected JTextField fileNameTextField;
    protected JPanel fileNameSpringPanel;
    protected JSeparator separator;
    protected NavigationPanel navigationPanel;
    protected ViewModeControl viewModeControl;
    protected JComboBox directoryComboBox;
    protected JSplitPane splitPane;
    protected JScrollPane sidebarScrollPane;
    protected JPanel viewsPanel;
    protected JPanel controlsPanel;
    protected JPanel accessoryViewPanel;
    protected JPanel accessoryPanel;
    protected JPanel formatPanel;
    protected JLabel filesOfTypeLabel;
    protected JComboBox filterComboBox;
    protected JPanel formatSpringPanel;
    protected ButtonPanel buttonsPanel;
    protected JButton newFolderButton;
    protected JButton optionsButton;
    protected JButton cancelButton;
    protected JButton approveButton;
    protected ListView listView;
    protected ColumnView columnView;
    protected JTree sidebarTree;
    protected final int SELECT_DIRECTORY_FROM_API = 1;
    protected final int SELECT_DIRECTORY_FROM_COMBO_BOX = 2;
    protected final int SELECT_DIRECTORY_BY_DOUBLE_CLICK = 3;
    protected final int SELECT_DIRECTORY_BY_KEYSTROKE = 4;
    protected final int SELECT_DIRECTORY_FROM_SIDEBAR = 5;
    protected final int SELECT_DIRECTORY_TO_INITIALIZE = 6;
    protected final int SELECT_DIRECTORY_NEW_VIEW = 7;
    static final int space = 10;

    protected void requestFileSelectionPath(String initialText) {
        Window parent = SwingUtilities.getWindowAncestor(this.fc);
        String prompt = this.goToFolderDialogPrompt;
        String cancelLabel = this.goToFolderCancelButtonText;
        String acceptLabel = this.goToFolderAcceptButtonText;
        String errorText = this.goToFolderErrorText;
        JDialog dialog = parent instanceof Frame ? new JDialog((Frame)parent) : new JDialog((Dialog)parent);
        RequestFileSelectionPathPane pane = new RequestFileSelectionPathPane(dialog, initialText, prompt, cancelLabel, acceptLabel, errorText){

            @Override
            protected void canceled() {
            }

            @Override
            protected void accepted() {
                File file = this.getSelection();
                if (file.isDirectory()) {
                    AquaFileChooserUI.this.selectDirectory(file, 4, null);
                } else if (AquaFileChooserUI.this.isAcceptable(file)) {
                    AquaFileChooserUI.this.fc.setSelectedFile(file);
                }
            }
        };
        pane.setBorder(new EmptyBorder(20, 15, 10, 15));
        pane.setComponentOrientation(parent.getComponentOrientation());
        dialog.setContentPane(pane);
        dialog.pack();
        AquaSheetSupport.displayAsSheet(dialog, null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaFileChooserUI((JFileChooser)c);
    }

    public AquaFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installUI(JComponent c) {
        this.fc = (JFileChooser)c;
        super.installUI(c);
        this.installSelectedView(false, true);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        int h;
        this.sidebarTree = new SidebarTree();
        ChangeListener viewSelectionChangeListener = this.createViewSelectionChangeListener(fc);
        FileChooserView.SelectListener viewSelectListener = this.createViewSelectListener(fc);
        this.fileNamePanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = this.createTextField("File Name Text Field");
        this.fileNameSpringPanel = new JPanel();
        this.separator = new JSeparator();
        this.navigationPanel = new NavigationPanel();
        this.directoryComboBox = this.createComboBox();
        this.splitPane = new JSplitPane();
        this.sidebarScrollPane = new JScrollPane();
        this.viewsPanel = new JPanel();
        this.columnView = ColumnView.create(fc);
        this.viewModeControl = ViewModeControl.create();
        this.listView = ListView.create(fc);
        this.controlsPanel = new JPanel();
        this.accessoryViewPanel = new JPanel();
        this.accessoryPanel = new JPanel();
        this.formatPanel = new JPanel();
        this.filesOfTypeLabel = new JLabel();
        this.filterComboBox = this.createComboBox();
        this.formatSpringPanel = new JPanel();
        this.buttonsPanel = new ButtonPanel();
        this.newFolderButton = this.createButton();
        this.optionsButton = this.createButton();
        this.cancelButton = this.createButton();
        this.approveButton = this.createButton();
        fc.setLayout(new GridBagLayout());
        this.fileNamePanel.setLayout(new GridBagLayout());
        this.fileNamePanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 1, 0));
        this.fileNameLabel.setHorizontalAlignment(4);
        this.fileNameLabel.setText("Save As:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        this.fileNamePanel.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.fileNamePanel.add((Component)this.fileNameTextField, gridBagConstraints);
        this.fileNameSpringPanel.setLayout(null);
        this.fileNameSpringPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.fileNamePanel.add((Component)this.fileNameSpringPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.fileNamePanel.add((Component)this.separator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        fc.add((Component)this.fileNamePanel, gridBagConstraints);
        this.viewsPanel.setLayout(new CardLayout());
        this.viewsPanel.add((Component)this.columnView, "browser");
        this.columnView.addSelectionChangeListener(viewSelectionChangeListener);
        this.columnView.addSelectListener(viewSelectListener);
        if (this.viewModeControl != null && this.listView != null) {
            this.listView.addSelectionChangeListener(viewSelectionChangeListener);
            this.listView.addSelectListener(viewSelectListener);
            this.viewModeControl.setMaximumSize(this.viewModeControl.getPreferredSize());
            this.viewModeControl.setAlignmentY(0.5f);
            this.navigationPanel.add(this.viewModeControl);
            this.navigationPanel.add(Box.createHorizontalGlue());
            this.viewModeControl.addChangeListener(new ViewModeChangeListener());
            this.viewsPanel.add((Component)this.listView, "list");
        }
        this.directoryComboBox.putClientProperty("JComboBox.style", "textured");
        this.directoryComboBox.setAlignmentY(0.5f);
        Dimension dp = this.directoryComboBox.getPreferredSize();
        this.directoryComboBox.setPreferredSize(new Dimension(300, dp.height));
        this.directoryComboBox.setMaximumSize(this.directoryComboBox.getPreferredSize());
        this.directoryComboBox.putClientProperty("Quaqua.Component.visualMargin", new Insets(1, 1, 1, 1));
        this.navigationPanel.add(this.directoryComboBox);
        this.navigationPanel.add(Box.createHorizontalGlue());
        this.navigationPanel.add(Box.createRigidArea(new Dimension(42, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        fc.add((Component)this.navigationPanel, gridBagConstraints);
        this.splitPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(153, 153, 153)));
        int scrollbarExtra = 25;
        int w = UIManager.getInt("FileChooser.sideBarWidth");
        int sidebarWidth = w > 0 ? w : 134 + scrollbarExtra;
        this.sidebarScrollPane.setMinimumSize(new Dimension(sidebarWidth, 0));
        this.splitPane.setDividerLocation(sidebarWidth);
        this.splitPane.putClientProperty("JSplitPane.style", "thin");
        this.sidebarScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sidebarScrollPane.setHorizontalScrollBarPolicy(31);
        this.sidebarTree.setRootVisible(false);
        this.sidebarTree.setShowsRootHandles(true);
        this.sidebarScrollPane.setViewportView(this.sidebarTree);
        this.sidebarScrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.style", "sidebar");
        this.splitPane.setLeftComponent(this.sidebarScrollPane);
        this.splitPane.setRightComponent(this.viewsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        fc.add((Component)this.splitPane, gridBagConstraints);
        this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 1));
        this.accessoryViewPanel.setLayout(new BoxLayout(this.accessoryViewPanel, 1));
        this.accessoryPanel.setLayout(new BorderLayout());
        this.accessoryViewPanel.add(this.accessoryPanel);
        this.controlsPanel.add(this.accessoryViewPanel);
        if (OSXSystemProperties.OSVersion < 1011) {
            AquaGroupBorder b = new AquaGroupBorder(new Insets(10, 10, 1, 10), new Insets(18, 22, 18, 22));
            this.accessoryViewPanel.setBorder(b);
            this.accessoryViewPanel.setOpaque(false);
            this.accessoryPanel.setOpaque(false);
            this.formatPanel.setOpaque(false);
        } else {
            Color c = new Color(233, 233, 233);
            this.accessoryViewPanel.setBackground(c);
            this.formatPanel.setBackground(c);
        }
        this.formatPanel.setLayout(new GridBagLayout());
        this.formatPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
        this.filesOfTypeLabel.setHorizontalAlignment(4);
        this.filesOfTypeLabel.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.formatPanel.add((Component)this.filesOfTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 250;
        this.formatPanel.add((Component)this.filterComboBox, gridBagConstraints);
        this.formatSpringPanel.setLayout(null);
        this.formatSpringPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.formatPanel.add((Component)this.formatSpringPanel, gridBagConstraints);
        this.accessoryViewPanel.add(this.formatPanel);
        this.newFolderButton.setText("New Folder");
        this.optionsButton.setText("Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.buttonsPanel.add((Component)this.optionsButton, gridBagConstraints);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.cancelButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(8));
        this.buttonsPanel.add(this.approveButton);
        this.controlsPanel.add(this.buttonsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        fc.add((Component)this.controlsPanel, gridBagConstraints);
        this.separator.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 0, 3, 0));
        TreeUI ui = this.createSidebarTreeUI();
        this.sidebarTree.setUI(ui);
        this.sidebarTree.putClientProperty("JTree.style", "sideBar");
        this.sidebarTree.setSelectionModel(new SidebarTreeSelectionModel());
        InputMap map = this.sidebarTree.getInputMap(0).getParent();
        KeyStroke ks = KeyStroke.getKeyStroke("shift meta A");
        Object v = map.get(ks);
        if (v != null && v.equals("clearSelection")) {
            InputMap newMap = new InputMap();
            newMap.setParent(map);
            newMap.put(ks, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(this.sidebarTree, 0, newMap);
        }
        if ((h = UIManager.getInt("FileChooser.sideBarRowHeight")) > 0) {
            this.sidebarTree.setRowHeight(h);
        }
        h = this.fileNameLabel.getPreferredSize().height;
        this.fileNameLabel.setMinimumSize(new Dimension(0, h));
        this.fileNameLabel.setPreferredSize(new Dimension(0, h));
        this.fileNameLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.fileNameTextField.getPreferredSize().height;
        this.fileNameTextField.setPreferredSize(new Dimension(0, h));
        this.fileNameTextField.setMinimumSize(new Dimension(0, h));
        this.fileNameTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.filesOfTypeLabel.getPreferredSize().height;
        this.filesOfTypeLabel.setMinimumSize(new Dimension(0, h));
        this.filesOfTypeLabel.setPreferredSize(new Dimension(0, h));
        this.filesOfTypeLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.filterComboBox.getPreferredSize().height;
        this.filterComboBox.setPreferredSize(new Dimension(0, h));
        this.filterComboBox.setMinimumSize(new Dimension(0, h));
        this.filterComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        FileRenderer fileRenderer = new FileRenderer(fc);
        this.columnView.setFileRenderer(fileRenderer);
        this.columnView.setMultipleSelection(this.isMultipleSelection());
        if (this.listView != null) {
            this.listView.setFileRenderer(fileRenderer);
            this.listView.setMultipleSelection(this.isMultipleSelection());
        }
        this.columnView.setModel(this.subtreeModel);
        if (this.listView != null) {
            this.listView.setModel(this.subtreeModel);
        }
        this.sidebarScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.installChoosableFileFilters(fc.getChoosableFileFilters());
        this.installAccessory(fc.getAccessory());
        this.newFolderButton.setText(this.newFolderButtonText);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.fileNameLabel.setText(this.fileNameLabelText);
        this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.optionsButton.setText(this.optionsButtonText);
        this.optionsButton.setToolTipText(this.optionsButtonToolTipText);
        this.optionsButton.addActionListener(this.optionsAction);
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        Dimension od = this.optionsButton.getPreferredSize();
        Dimension cd = this.cancelButton.getPreferredSize();
        Dimension ad = this.approveButton.getPreferredSize();
        int width = Math.max(Math.max(Math.max(od.width, cd.width), ad.width), 69);
        this.optionsButton.setPreferredSize(new Dimension(width, od.height));
        this.cancelButton.setPreferredSize(new Dimension(width, cd.height));
        this.approveButton.setPreferredSize(new Dimension(width, ad.height));
        this.newFolderButton.setMargin(new Insets(0, 10, 0, 10));
        if (!fc.getControlButtonsAreShown()) {
            this.optionsButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.approveButton.setVisible(false);
        }
        this.fileNameTextField.setDocument(new FilenameDocument());
        if (this.defaultInitialSaveFileName != null) {
            this.setFileNameTextField(this.defaultInitialSaveFileName);
        }
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(this.directoryComboBox));
        this.sidebarTreeModel = new SidebarTreeModel(fc, new TreePath(this.model.getRoot()), this.model);
        this.sidebarTree.setModel(this.sidebarTreeModel);
        this.sidebarTree.setCellRenderer(this.createSidebarCellRenderer(fc));
        for (int i = this.sidebarTree.getRowCount() - 1; i >= 0; --i) {
            this.sidebarTree.expandRow(i);
        }
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer(this.filterComboBox));
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.fileNameTextField.addFocusListener(new SaveTextFocusListener());
        this.fileNameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
        this.fileNameTextField.addActionListener(this.getApproveSelectionAction());
        this.sidebarTree.addTreeSelectionListener(this.createSidebarSelectionListener(fc));
        this.sidebarScrollPane.setFocusable(false);
        this.sidebarScrollPane.getVerticalScrollBar().setFocusable(false);
        this.sidebarScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.fileTransferHandler = new FileTransferHandler(fc);
        TextKeyListener kl = new TextKeyListener();
        if (OSXSystemProperties.OSVersion >= 1011) {
            this.controlsPanel.setOpaque(false);
            this.buttonsPanel.setOpaque(false);
        }
        Component[] dropComponents = new Component[]{fc, this.accessoryPanel, this.approveButton, this.columnView, this.buttonsPanel, this.optionsButton, this.cancelButton, this.controlsPanel, this.directoryComboBox, this.fileNameLabel, this.fileNamePanel, this.fileNameSpringPanel, this.fileNameTextField, this.filesOfTypeLabel, this.filterComboBox, this.formatPanel, this.formatSpringPanel, this.listView, this.navigationPanel, this.newFolderButton, this.separator, this.splitPane, this.viewModeControl, this.viewsPanel, this.sidebarTree, this.sidebarScrollPane};
        for (int i = 0; i < dropComponents.length; ++i) {
            Component c = dropComponents[i];
            if (c == null) continue;
            new DropTarget(c, 1, this.fileTransferHandler);
            c.addKeyListener(kl);
        }
        boolean isSave = fc.getDialogType() == 1 || fc.getDialogType() == 2;
        this.fileNameTextField.setEnabled(isSave);
        this.fileNamePanel.setVisible(isSave);
        this.doPreviewComponentChanged(null);
        this.updateApproveButtonState();
        this.updateAccessoryViewPanel();
        int columnWidth = 223;
        this.splitPane.setPreferredSize(new Dimension(sidebarWidth + 2 * columnWidth, 298));
        this.splitPane.setMinimumSize(new Dimension(sidebarWidth + columnWidth, 130));
        this.splitPane.setMaximumSize(new Dimension(100000, 100000));
        ActionMap am = fc.getActionMap();
        InputMap globalInputMap = fc.getInputMap(2);
        for (KeyStroke ks2 : this.KEYSTROKES) {
            if ((ks2.getModifiers() & 4) != 0) {
                globalInputMap.put(ks2, ks2);
            }
            am.put(ks2, this.keyListenerAction);
        }
        Dimension ps = fc.getPreferredSize();
        fc.setBounds(0, 0, ps.width, ps.height);
        fc.doLayout();
    }

    protected TreeUI createSidebarTreeUI() {
        return new SidebarTreeUI();
    }

    protected JTextField createTextField(final String theName) {
        JTextField t = new JTextField(){

            @Override
            public String toString() {
                return theName;
            }
        };
        t.setOpaque(false);
        return t;
    }

    protected JButton createButton() {
        return this.createButton(null);
    }

    protected JButton createButton(String text) {
        JButton b = new JButton(text);
        return b;
    }

    protected JComboBox createComboBox() {
        JComboBox b = new JComboBox();
        return b;
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.fileSystemModel.dispose();
        for (FileSystemTreeModel m : this.savedSearches.values()) {
            m.dispose();
        }
        this.optionsButton.removeActionListener(this.optionsAction);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.hierarchyListener = this.createHierarchyListener(fc);
        if (this.hierarchyListener != null) {
            fc.addHierarchyListener(this.hierarchyListener);
        }
        fc.addPropertyChangeListener(this.filterComboBoxModel);
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        if (this.hierarchyListener != null) {
            fc.removeHierarchyListener(this.hierarchyListener);
        }
        fc.removePropertyChangeListener(this.filterComboBoxModel);
    }

    private Locale getLocale() {
        try {
            return this.fc.getLocale();
        }
        catch (IllegalComponentStateException e) {
            return Locale.getDefault();
        }
    }

    @Override
    protected void installDefaults(JFileChooser fc) {
        super.installDefaults(fc);
        boolean isShowAllFiles = OSXSystemProperties.isShowAllFiles();
        fc.setFileHidingEnabled(!isShowAllFiles);
        this.setPackageTraversable(UIManager.getBoolean(PACKAGE_TRAVERSABLE_PROPERTY));
        this.setApplicationTraversable(UIManager.getBoolean(APPLICATION_TRAVERSABLE_PROPERTY));
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        Locale l;
        super.installStrings(fc);
        try {
            l = this.getLocale();
        }
        catch (IllegalComponentStateException e) {
            l = Locale.getDefault();
        }
        this.chooseButtonText = UIManager.getString("FileChooser.chooseButtonText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.optionsButtonText = UIManager.getString("FileChooser.optionsButtonText");
        this.optionsButtonToolTipText = UIManager.getString("FileChooser.optionsToolTipText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelToolTipText");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", l, "Error occurred during folder creation");
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", l, "That name is already taken");
        this.newFolderButtonText = this.getString("FileChooser.newFolderButtonText", l, "New Folder");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", l, "New Folder");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", l, "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", l, "untitled folder");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.goToFolderDialogPrompt = this.getString("FileChooser.goToFolderPromptText", l, "Go to the folder:");
        this.goToFolderCancelButtonText = this.getString("FileChooser.goToFolderCancelButtonText", l, "Cancel");
        this.goToFolderAcceptButtonText = this.getString("FileChooser.goToFolderAcceptButtonText", l, "Accept");
        this.goToFolderErrorText = this.getString("FileChooser.goToFolderErrorText", l, "The folder can\u2019t be found.");
        this.defaultInitialSaveFileName = this.getString("FileChooser.defaultSaveFileName", l, "Untitled");
    }

    @Override
    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    private String getString(String string, Locale l, String defaultValue) {
        String value = UIManager.getString(string);
        return value == null ? defaultValue : value;
    }

    protected HierarchyListener createHierarchyListener(JFileChooser fc) {
        return new FileChooserHierarchyListener();
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int mode) {
        if ((mode == 2 || this.listView != null && mode == 1) && mode != this.viewMode) {
            this.viewMode = mode;
            this.installSelectedView(false, false);
            if (this.activeView != null) {
                this.activeView.requestFocusInWindow();
            }
        }
    }

    private void installSelectedView(boolean forceInstall, boolean forceReconfigure) {
        if (!this.fc.isShowing() && !forceInstall) {
            this.isViewInstalled = false;
        } else {
            FileChooserView oldView;
            this.isViewInstalled = true;
            CardLayout cl = (CardLayout)this.viewsPanel.getLayout();
            FileChooserView viewToInstall = this.getViewForMode(this.viewMode);
            if (viewToInstall != (oldView = this.activeView)) {
                if (oldView != null) {
                    oldView.setActive(false);
                }
                this.activeView = viewToInstall;
                String viewName = this.getViewNameForMode(this.viewMode);
                cl.show(this.viewsPanel, viewName);
                this.activeView.setActive(true);
                forceReconfigure = true;
            }
            if (forceReconfigure) {
                this.activeView.reconfigure();
                this.model.invalidateAll();
            }
            int source = oldView != null ? 7 : 6;
            this.updateSelection(source);
        }
    }

    private FileChooserView getViewForMode(int viewMode) {
        if (viewMode == 1) {
            return this.listView;
        }
        return this.columnView;
    }

    private String getViewNameForMode(int viewMode) {
        if (viewMode == 1) {
            return "list";
        }
        return "browser";
    }

    @Override
    public void createModel() {
        this.fc.setFileSystemView(AquaFileSystemView.getAquaFileSystemView());
        this.fileView = UIManager.getBoolean("FileChooser.speed") ? new BasicFileChooserUI.BasicFileView(this) : AquaFileSystemView.getAquaFileSystemView().createFileView(this.fc);
        this.fc.setFileView(this.fileView);
        this.model = this.fileSystemModel = new FileSystemTreeModel(this.fc);
        this.subtreeModel = new SubtreeTreeModel(this.model);
        this.savedSearches = new HashMap<File, FileSystemTreeModel>();
    }

    public FileSystemTreeModel getSavedSearchTreeModel(File savedSearchFile) {
        FileSystemTreeModel m = this.savedSearches.get(savedSearchFile);
        if (m == null) {
            m = this.createSavedSearchTreeModel(savedSearchFile);
            this.savedSearches.put(savedSearchFile, m);
        }
        return m;
    }

    protected FileSystemTreeModel createSavedSearchTreeModel(File savedSearchFile) {
        return new SavedSearchFileSystemTreeModel(this.fc, savedSearchFile);
    }

    private void updateSelection(final int source) {
        if (this.activeView == null) {
            return;
        }
        List<File> files = null;
        TreePath directoryPath = null;
        if (this.fc.getDialogType() == 1 && this.fileNameTextField != null && this.isFileNameFieldVisible() && !(files = this.getChooserSelection()).isEmpty()) {
            File f = files.get(0);
            files.clear();
            File parent = f.getParentFile();
            if (this.fc.isTraversable(parent)) {
                files.add(parent);
                directoryPath = this.model.toPath(parent, null);
                ++this.isAdjusting;
                this.setFileName(f.getName());
                --this.isAdjusting;
            }
        }
        if (files == null) {
            files = this.getNormalizedChooserSelection();
        }
        final List<File> originalFiles = files;
        final ArrayList<TreePath> list = new ArrayList<TreePath>(files.size());
        TreePath commonParentPath = null;
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            TreePath fullPath = this.model.toPath(file, null);
            if (i == 0) {
                commonParentPath = fullPath.getParentPath();
            } else {
                TreePath parentPath = fullPath.getParentPath();
                if (!AquaFileChooserUI.Object_equals(commonParentPath, parentPath)) continue;
            }
            list.add(fullPath);
        }
        if (directoryPath == null) {
            directoryPath = commonParentPath;
        }
        if (directoryPath != null) {
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    List subtreePaths = AquaFileChooserUI.this.getSubtreePaths(list);
                    AquaFileChooserUI.this.setViewSelection(subtreePaths);
                    AquaFileChooserUI.this.finishUpdateSelection(originalFiles, list);
                }
            };
            FileSystemTreeModel.Node n = (FileSystemTreeModel.Node)directoryPath.getLastPathComponent();
            final File dir = n != null ? n.getResolvedFile() : new File("/");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.selectDirectory(dir, source, r);
                }
            });
        } else {
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.updateSelectedFiles(null);
                    AquaFileChooserUI.this.updateApproveButtonState();
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    File dir = AquaFileChooserUI.this.fc.getCurrentDirectory();
                    AquaFileChooserUI.this.selectDirectory(dir, source, r);
                }
            });
        }
    }

    private void finishUpdateSelection(List<File> originalFiles, List<TreePath> newSelection) {
        if (originalFiles.size() != newSelection.size()) {
            int count = newSelection.size();
            ArrayList<File> files = new ArrayList<File>(count);
            for (TreePath path : newSelection) {
                File f = ((FileInfo)path.getLastPathComponent()).getFile();
                files.add(f);
            }
            this.updateSelectedFiles(files);
        }
        this.updateApproveButtonState();
    }

    private List<TreePath> getSubtreePaths(List<TreePath> paths) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath fullPath : paths) {
            TreePath subtreePath = this.subtreeModel.toSubPath(fullPath);
            if (subtreePath == null) continue;
            result.add(subtreePath);
        }
        return result;
    }

    private TreePath getSubtreePath(File f) {
        TreePath fullPath;
        if (f != null && (fullPath = this.model.toPath(f, this.subtreeModel.getPathToRoot())) != null) {
            return this.subtreeModel.toSubPath(fullPath);
        }
        return null;
    }

    public static boolean Object_equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private boolean isFileNameFieldValid() {
        String string = this.getFileName();
        return string != null && !string.equals("");
    }

    private boolean isFileNameFieldVisible() {
        return this.fc.getDialogType() == 1 || this.fc.getDialogType() == 2;
    }

    private void updateApproveButtonState() {
        if (this.fc.getControlButtonsAreShown()) {
            boolean isEnabled = this.computeApproveButtonEnabled();
            this.setApproveButtonEnabled(isEnabled);
        }
    }

    private boolean computeApproveButtonEnabled() {
        if (this.fc.getDialogType() == 1) {
            return this.isAcceptableSaveDialogState();
        }
        if (this.isFileNameFieldVisible() && this.isFileNameFieldValid() && this.fc.getFileSelectionMode() == 0) {
            return true;
        }
        List<File> files = this.getChooserSelection();
        if (files.isEmpty()) {
            return this.fc.isDirectorySelectionEnabled() && this.isAcceptable(this.fc.getCurrentDirectory());
        }
        for (File f : files) {
            if (this.isAcceptable(f)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptableSaveDialogState() {
        File dir = this.fc.getCurrentDirectory();
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        return this.isFileNameFieldValid();
    }

    private boolean isSelected(File f) {
        File[] fs;
        if (f != null && (fs = this.fc.getSelectedFiles()) != null) {
            for (File sf : fs) {
                if (!f.equals(sf)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAcceptable(File f) {
        FileInfo info;
        Object pc;
        if (f == null) {
            return false;
        }
        TreePath path = this.model.toPath(f, null);
        if (path != null && (pc = path.getLastPathComponent()) instanceof FileInfo && (info = (FileInfo)pc).getFile().equals(f)) {
            return info.isAcceptable();
        }
        return false;
    }

    private boolean isMultipleSelection() {
        return this.fc != null && this.fc.isMultiSelectionEnabled() && this.fc.getDialogType() != 1;
    }

    private void setApproveButtonEnabled(boolean isEnabled) {
        if (this.fc.getControlButtonsAreShown()) {
            JRootPane rp;
            this.approveButton.setEnabled(isEnabled);
            if (isEnabled && (rp = this.approveButton.getRootPane()) != null) {
                rp.setDefaultButton(this.approveButton);
            }
        }
    }

    private void updateApproveButtonText() {
        this.approveButton.setText(this.getApproveButtonText(this.fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.fc));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.fc));
    }

    private void respondToUISelectionChange() {
        TreePath dirPath;
        List<TreePath> paths = this.getNormalizedUISelection();
        if (this.viewMode == 2 && (dirPath = this.getColumnViewCurrentDirectoryPath(paths)) != null) {
            this.updateCurrentDirectory(dirPath);
            this.updateComboBoxModel(dirPath);
        }
        List<File> fs = this.getFileSelectionFromViewSelection(paths);
        this.installSelectedFiles(fs);
        if (!paths.isEmpty()) {
            TreePath path = paths.get(0);
            this.model.lazyInvalidatePath(path);
            if (this.fc.isDisplayable()) {
                this.model.validatePath(path);
            }
        }
        this.updateApproveButtonState();
    }

    private TreePath getColumnViewCurrentDirectoryPath(List<TreePath> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        TreePath path = paths.get(0);
        FileInfo info = (FileInfo)path.getLastPathComponent();
        if (paths.size() == 1 && info.isTraversable()) {
            return path;
        }
        return path.getParentPath();
    }

    private List<File> getFileSelectionFromViewSelection(List<TreePath> paths) {
        ArrayList<File> fs = new ArrayList<File>();
        for (TreePath p : paths) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)p.getLastPathComponent();
            if (paths.size() == 1 && !node.isAcceptable()) {
                return new ArrayList<File>();
            }
            File f = node.getFile();
            fs.add(f);
        }
        return fs;
    }

    private void updateCurrentDirectory(TreePath subtreePath) {
        if (this.isAdjusting == 0) {
            FileInfo info = (FileInfo)subtreePath.getLastPathComponent();
            File f = info.getResolvedFile();
            File current = this.fc.getCurrentDirectory();
            if (!AquaFileChooserUI.Object_equals(current, f)) {
                ++this.isAdjusting;
                this.fc.setSelectedFiles(null);
                this.fc.setCurrentDirectory(f);
                --this.isAdjusting;
            }
        }
    }

    private void updateSelectedFile(File file) {
        if (this.isAdjusting == 0) {
            ++this.isAdjusting;
            if (this.isMultipleSelection()) {
                this.fc.setSelectedFiles(new File[]{file});
            } else {
                this.fc.setSelectedFile(file);
            }
            --this.isAdjusting;
        }
    }

    private void updateSelectedFiles(List<File> files) {
        if (this.isAdjusting == 0) {
            ++this.isAdjusting;
            if (this.isMultipleSelection()) {
                File[] fs = files != null ? files.toArray(new File[files.size()]) : null;
                this.fc.setSelectedFiles(fs);
            } else {
                this.fc.setSelectedFile(files != null && !files.isEmpty() ? files.get(0) : null);
            }
            --this.isAdjusting;
        }
    }

    private void installSelectedFiles(List<File> fs) {
        if (this.isAdjusting == 0) {
            ++this.isAdjusting;
            File currentDirectory = this.fc.getCurrentDirectory();
            this.fc.setSelectedFiles(fs.toArray(new File[fs.size()]));
            this.fc.setCurrentDirectory(currentDirectory);
            --this.isAdjusting;
        }
    }

    private TreePath first(List<TreePath> paths) {
        return paths.isEmpty() ? null : paths.get(0);
    }

    protected ChangeListener createViewSelectionChangeListener(JFileChooser fc) {
        return new ViewSelectionChangeListener();
    }

    protected FileChooserView.SelectListener createViewSelectListener(JFileChooser fc) {
        return new ViewSelectListener();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.updateSelection(1);
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.updateSelection(1);
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        if (this.activeView == null) {
            return;
        }
        File dir = (File)e.getNewValue();
        this.selectDirectory(dir, 1, null);
    }

    private void updateModel() {
        this.model.invalidateAll();
        if (this.fc.isShowing() && this.activeView != null) {
            this.reconfigureView();
            List<TreePath> oldSelection = this.activeView.getSelection();
            List<TreePath> newSelection = this.getNormalizedUISelection();
            if (oldSelection.equals(newSelection)) {
                this.model.validatePath(this.subtreeModel.toFullPath(this.first(oldSelection)));
                this.updateApproveButtonState();
            } else {
                File dir;
                TreePath viewPath;
                if (this.viewMode == 2 && newSelection.isEmpty() && (viewPath = this.getSubtreePath(dir = this.fc.getCurrentDirectory())) != null) {
                    newSelection.add(viewPath);
                }
                this.setViewSelection(newSelection);
                this.respondToUISelectionChange();
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        this.updateModel();
    }

    private void doFileHidingChanged(PropertyChangeEvent e) {
        this.updateModel();
    }

    private void doPackageTraversableChanged(PropertyChangeEvent e) {
        Boolean b = (Boolean)e.getNewValue();
        this.setPackageTraversable(b != null ? b : false);
    }

    private void doApplicationTraversableChanged(PropertyChangeEvent e) {
        Boolean b = (Boolean)e.getNewValue();
        this.setApplicationTraversable(b != null ? b : false);
    }

    private void setPackageTraversable(boolean b) {
        AquaFileView q;
        FileView fv = this.fc.getFileView();
        if (fv instanceof AquaFileView && b != (q = (AquaFileView)fv).isPackageTraversable()) {
            q.setPackageTraversable(b);
            this.updateModel();
        }
    }

    private void setApplicationTraversable(boolean b) {
        AquaFileView q;
        FileView fv = this.fc.getFileView();
        if (fv instanceof AquaFileView && b != (q = (AquaFileView)fv).isApplicationTraversable()) {
            q.setApplicationTraversable(b);
            this.updateModel();
        }
    }

    private void doFileViewChanged(PropertyChangeEvent e) {
        this.updateModel();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.updateApproveButtonText();
        this.updateApproveButtonState();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (!this.isMultipleSelection()) {
            this.fc.setSelectedFiles(null);
        }
    }

    private void doChoosableFilterChanged(PropertyChangeEvent e) {
        this.installChoosableFileFilters((FileFilter[])e.getNewValue());
        this.updateModel();
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        this.installAccessory((JComponent)e.getNewValue());
    }

    private void installChoosableFileFilters(FileFilter[] ffs) {
        this.formatPanel.setVisible(ffs.length > 1);
        this.accessoryPanel.revalidate();
        this.accessoryPanel.repaint();
        this.updateAccessoryViewPanel();
    }

    private void installAccessory(JComponent c) {
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
            if (c != null) {
                Border b = c.getBorder();
                if (!(b instanceof EmptyBorder)) {
                    c.setBorder(null);
                    c.revalidate();
                }
                JPanel wrapper = new JPanel();
                wrapper.setOpaque(false);
                wrapper.setLayout(new BorderLayout());
                wrapper.setBorder(new EmptyBorder(5, 15, 5, 15));
                wrapper.add((Component)c, "Center");
                wrapper.revalidate();
                this.accessoryPanel.add((Component)wrapper, "Center");
            }
            this.accessoryPanel.revalidate();
            this.accessoryPanel.repaint();
            this.accessoryPanel.setVisible(c != null);
            this.updateAccessoryViewPanel();
        }
    }

    private void updateAccessoryViewPanel() {
        this.accessoryViewPanel.setVisible(!(isOptionsAvailable && this.fc.getDialogType() == 0 && !this.isOptionsEnabled || !this.accessoryPanel.isVisible() && !this.formatPanel.isVisible()));
        this.updateButtons();
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        this.approveButton.setText(this.getApproveButtonText(this.fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.fc));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        this.approveButton.setText(this.getApproveButtonText(this.fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.fc));
        boolean isSave = this.isFileNameFieldVisible();
        this.fileNameTextField.setEnabled(isSave);
        this.fileNamePanel.setVisible(isSave);
        this.updateApproveButtonState();
        this.updateAccessoryViewPanel();
        this.reconfigureView();
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    private void doFileSystemViewChanged(PropertyChangeEvent e) {
        boolean isInstalled = this.model == this.fileSystemModel;
        this.fileSystemModel = new FileSystemTreeModel(this.fc);
        this.sidebarTreeModel = new SidebarTreeModel(this.fc, new TreePath(this.fileSystemModel.getRoot()), this.fileSystemModel);
        this.sidebarTree.setModel(this.sidebarTreeModel);
        if (isInstalled) {
            this.installModel(this.fileSystemModel);
        }
    }

    private void updateButtons() {
        this.optionsButton.setVisible(isOptionsAvailable && this.fc.getDialogType() == 0 && (this.accessoryPanel.isVisible() || this.formatPanel.isVisible()));
        this.newFolderButton.setVisible(this.fc.getDialogType() == 1);
    }

    private void ensureFileSystemModel() {
        this.installModel(this.fileSystemModel);
    }

    private void installModel(FileSystemTreeModel m) {
        if (m != this.model) {
            this.model = m;
            this.subtreeModel = new SubtreeTreeModel(m);
            this.columnView.setModel(this.subtreeModel);
            if (this.listView != null) {
                this.listView.setModel(this.subtreeModel);
            }
        }
    }

    private void doPreviewComponentChanged(PropertyChangeEvent e) {
        this.reconfigureView();
    }

    protected void reconfigureView() {
        if (this.activeView != null) {
            this.activeView.reconfigure();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AquaFileChooserUI.this.isAdjusting > 0) {
                    return;
                }
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    AquaFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    AquaFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    AquaFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    AquaFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("FileSystemViewChanged")) {
                    AquaFileChooserUI.this.doFileSystemViewChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    AquaFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    AquaFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    AquaFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ChoosableFileFilterChangedProperty")) {
                    AquaFileChooserUI.this.doChoosableFilterChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    AquaFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    AquaFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    AquaFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    AquaFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("fileViewChanged")) {
                    AquaFileChooserUI.this.doFileViewChanged(e);
                } else if (s.equals("FileHidingChanged")) {
                    AquaFileChooserUI.this.doFileHidingChanged(e);
                } else if (s.equals(AquaFileChooserUI.PACKAGE_TRAVERSABLE_PROPERTY)) {
                    AquaFileChooserUI.this.doPackageTraversableChanged(e);
                } else if (s.equals(AquaFileChooserUI.APPLICATION_TRAVERSABLE_PROPERTY)) {
                    AquaFileChooserUI.this.doApplicationTraversableChanged(e);
                } else if (s.equals("Aqua.FileChooser.preview")) {
                    AquaFileChooserUI.this.doPreviewComponentChanged(e);
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.optionsButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.approveButton.setVisible(false);
    }

    protected void addControlButtons() {
        this.optionsButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.approveButton.setVisible(true);
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        this.setFileNameTextField(filename);
    }

    private void selectRootFromSidebarSelection() {
        Object o;
        TreePath sidebarPath = this.sidebarTree.getSelectionPath();
        if (sidebarPath != null && (o = sidebarPath.getLastPathComponent()) instanceof SidebarTreeFileNode) {
            File file;
            SidebarTreeFileNode info = (SidebarTreeFileNode)o;
            for (file = info.getResolvedFile(); file != null && !file.isDirectory() && !this.fc.isTraversable(file); file = file.getParentFile()) {
            }
            if (file != null) {
                this.selectDirectory(file, 5, null);
            }
        }
    }

    protected void selectDirectory(File f, final int source, final Runnable r) {
        if ((source == 5 || source == 6 || source == 7) && OSXFile.isSavedSearch(f)) {
            this.installModel(this.getSavedSearchTreeModel(f));
        } else {
            f = this.toTraversableFile(f);
            if (this.viewMode != 2 || source == 5 || this.model.toPath(f, null) == null) {
                this.ensureFileSystemModel();
            }
        }
        final TreePath fullPath = this.model.toPath(f, null);
        if (source == 5) {
            this.setViewRoot(fullPath);
            this.finishSelectDirectory(source, fullPath, r);
        } else if (!(this.model instanceof SavedSearchFileSystemTreeModel)) {
            final File theFile = f;
            this.sidebarTreeModel.invokeWhenValid(new Runnable(){

                @Override
                public void run() {
                    final TreePath sidebarPath = AquaFileChooserUI.this.selectViewRoot(theFile, AquaFileChooserUI.this.viewMode == 2);
                    AquaFileChooserUI.this.finishSelectDirectory(source, fullPath, r);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AquaFileChooserUI.this.setSidebarSelection(sidebarPath);
                        }
                    });
                }
            });
        }
    }

    private void finishSelectDirectory(int source, TreePath fullPath, Runnable r) {
        TreePath viewPath;
        if (fullPath != null) {
            this.model.lazyInvalidatePath(fullPath);
        } else {
            this.model.invalidateAll();
        }
        TreePath treePath = viewPath = fullPath != null ? this.subtreeModel.toSubPath(fullPath) : null;
        if (viewPath == null) {
            viewPath = this.subtreeModel.getPathToRoot();
        }
        this.setViewSelection(viewPath);
        if (this.viewMode == 1) {
            viewPath = this.subtreeModel.getPathToRoot();
        }
        if (source != 1 && source != 6 && source != 7) {
            this.updateCurrentDirectory(viewPath);
        }
        this.updateComboBoxModel(viewPath);
        if (r != null) {
            r.run();
        }
    }

    private File toTraversableFile(File f) {
        while (f != null && !this.fc.isTraversable(f)) {
            f = f.getParentFile();
        }
        return f != null ? f : new File(System.getProperty("user.home"));
    }

    protected TreePath selectViewRoot(File f, boolean isRestrictedToSidebar) {
        if (f.getPath().equals("/Network")) {
            this.setViewRoot(this.fileSystemModel.toPath(f, null));
            return null;
        }
        if (!isRestrictedToSidebar) {
            TreePath sidebarPath = this.selectRootOneStep(f);
            if (sidebarPath == null) {
                TreePath path = this.model.toPath(f, null);
                this.setViewRoot(path);
            }
            return sidebarPath;
        }
        FileSystemTreeModel.Node root = this.fileSystemModel.getRoot();
        while (f != null) {
            TreePath sidebarPath = this.selectRootOneStep(f);
            if (sidebarPath != null) {
                return sidebarPath;
            }
            if (f.equals(root.getFile())) break;
            f = f.getParentFile();
        }
        this.setViewRoot(new TreePath(this.model.getRoot()));
        return null;
    }

    private TreePath selectRootOneStep(File target) {
        if (target == null) {
            return null;
        }
        TreePath sidebarPath = this.searchSidebarTreeForFile((TreeNode)this.sidebarTreeModel.getRoot(), target);
        if (sidebarPath != null) {
            TreePath p = this.fileSystemModel.toPath(target, null);
            this.setViewRoot(p);
            return sidebarPath;
        }
        return null;
    }

    private TreePath searchSidebarTreeForFile(TreeNode node, File f) {
        File nrf;
        File rf;
        SidebarTreeFileNode info;
        File nf;
        if (node instanceof SidebarTreeFileNode && (nf = (info = (SidebarTreeFileNode)((Object)node)).getResolvedFile()) != null && (rf = OSXFile.resolve(f)).equals(nrf = OSXFile.resolve(nf))) {
            return new TreePath(this.sidebarTreeModel.getPathToRoot(node));
        }
        if (node != null) {
            int count = this.sidebarTreeModel.getChildCount(node);
            for (int index = 0; index < count; ++index) {
                TreePath path;
                Object child = this.sidebarTreeModel.getChild(node, index);
                if (!(child instanceof TreeNode) || (path = this.searchSidebarTreeForFile((TreeNode)child, f)) == null) continue;
                return path;
            }
        }
        return null;
    }

    protected void setViewRoot(TreePath path) {
        ++this.isAdjusting;
        this.subtreeModel.setPathToRoot(path);
        --this.isAdjusting;
    }

    protected void setViewSelection(TreePath path) {
        this.setViewSelection(Arrays.asList(path));
    }

    protected void setViewSelection(List<TreePath> paths) {
        if (this.activeView != null) {
            ++this.isAdjusting;
            this.activeView.setSelection(paths);
            --this.isAdjusting;
            if (!paths.isEmpty()) {
                this.ensurePathIsVisible(paths.get(0));
            }
        }
    }

    protected void setSidebarSelection(TreePath path) {
        ++this.isAdjusting;
        if (path != null) {
            this.sidebarTree.setSelectionPath(path);
            if (this.sidebarTree.isVisible(path)) {
                this.sidebarTree.scrollPathToVisible(path);
            }
        } else {
            this.sidebarTree.clearSelection();
        }
        --this.isAdjusting;
    }

    protected void setFileNameTextField(String text) {
        ++this.isAdjusting;
        if (!(this.fileNameTextField == null || text != null && this.fileNameTextField.getText().equals(text))) {
            this.fileNameTextField.setText(text);
        }
        --this.isAdjusting;
    }

    protected void updateComboBoxModel(TreePath subtreePath) {
        TreePath fullPath;
        if (this.model instanceof SavedSearchFileSystemTreeModel && subtreePath.getPathCount() > 1) {
            FileInfo info = (FileInfo)subtreePath.getLastPathComponent();
            File f = info.getResolvedFile();
            fullPath = this.fileSystemModel.toPath(f, null);
        } else {
            fullPath = this.subtreeModel.toFullPath(subtreePath);
        }
        ++this.isAdjusting;
        this.directoryComboBoxModel.setPath(fullPath);
        --this.isAdjusting;
    }

    private void ensurePathIsVisible(final TreePath path) {
        if (this.activeView != null && path != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.activeView.ensurePathIsVisible(path);
                }
            };
            this.runAfterValidation(path, 0, path.getPathCount() - 2, r);
        }
    }

    private void runAfterValidation(final TreePath path, final int index, final int lastIndex, final Runnable r) {
        if (index > lastIndex) {
            r.run();
        } else {
            FileSystemTreeModel.Node n = (FileSystemTreeModel.Node)path.getPathComponent(index);
            n.invokeWhenValid(new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.runAfterValidation(path, index + 1, lastIndex, r);
                }
            });
        }
    }

    private DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JComboBox cb) {
        return new DirectoryComboBoxRenderer(cb);
    }

    private SidebarRenderer createSidebarCellRenderer(JFileChooser fc) {
        return new SidebarRenderer();
    }

    protected TreeSelectionListener createSidebarSelectionListener(JFileChooser fc) {
        return new SidebarSelectionListener();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer(JComboBox cb) {
        return new FilterComboBoxRenderer(cb);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void maybeApproveSelection() {
        assert (this.isAdjusting == 0);
        String filename = null;
        if (this.isFileNameFieldVisible() && (filename = this.getFileName()).equals("")) {
            filename = null;
        }
        List<File> selectedFiles = this.getUISelection(true);
        if (filename != null && selectedFiles.size() == 1) {
            File selectedFile = selectedFiles.get(0);
            if (this.isDirectorySelectedInSaveDialogListView(selectedFile)) {
                this.selectDirectory(selectedFile, 3, null);
                return;
            }
            File parent = selectedFile.isDirectory() ? selectedFile : selectedFile.getParentFile();
            File f = new File(parent, filename);
            selectedFiles = new ArrayList<File>();
            selectedFiles.add(f);
        }
        if (selectedFiles.isEmpty()) {
            return;
        }
        if (this.isMultipleSelection()) {
            this.updateSelectedFiles(selectedFiles);
        } else if (selectedFiles.size() == 1) {
            this.updateSelectedFile(selectedFiles.get(0));
        } else {
            return;
        }
        this.fc.approveSelection();
    }

    private boolean isDirectorySelectedInSaveDialogListView(File f) {
        if (this.viewMode == 1 && this.fc.isTraversable(f)) {
            File dir = this.fc.getCurrentDirectory();
            return !f.equals(dir);
        }
        return false;
    }

    protected List<TreePath> getNormalizedUISelection() {
        List<TreePath> paths = this.activeView.getSelection();
        if (!paths.isEmpty()) {
            ArrayList<TreePath> acceptablePaths = new ArrayList<TreePath>();
            List<TreePath> traversablePaths = new ArrayList();
            boolean isChanged = false;
            for (TreePath path : paths) {
                FileInfo info = (FileInfo)path.getLastPathComponent();
                if (info.getFile() == null) {
                    isChanged = true;
                    continue;
                }
                if (info.isAcceptable()) {
                    acceptablePaths.add(path);
                    continue;
                }
                if (info.isTraversable()) {
                    traversablePaths.add(path);
                    continue;
                }
                isChanged = true;
            }
            if (!traversablePaths.isEmpty()) {
                if (acceptablePaths.isEmpty()) {
                    if (traversablePaths.size() > 1) {
                        traversablePaths = traversablePaths.subList(0, 1);
                        isChanged = true;
                    }
                } else {
                    traversablePaths = new ArrayList();
                    isChanged = true;
                }
            }
            List<TreePath> result = new ArrayList<TreePath>();
            result.addAll(acceptablePaths);
            result.addAll(traversablePaths);
            if (result.size() > 1 && !this.isMultipleSelection()) {
                result = result.subList(0, 1);
                isChanged = true;
            }
            if (isChanged) {
                ++this.isAdjusting;
                this.activeView.setSelection(result);
                --this.isAdjusting;
            }
            return result;
        }
        return paths;
    }

    protected List<File> getUISelection(boolean useDefault) {
        ArrayList<File> result = new ArrayList<File>();
        List<TreePath> paths = this.activeView.getSelection();
        for (TreePath path : paths) {
            File f = ((FileSystemTreeModel.Node)path.getLastPathComponent()).getFile();
            result.add(f);
        }
        if (useDefault && result.isEmpty()) {
            FileInfo info = (FileInfo)this.subtreeModel.getRoot();
            File f = info.getFile();
            result.add(f);
        }
        return result;
    }

    protected List<File> getNormalizedChooserSelection() {
        List<File> files = this.getChooserSelection();
        if (!files.isEmpty()) {
            ArrayList<File> acceptableFiles = new ArrayList<File>();
            List<File> traversableFiles = new ArrayList<File>();
            boolean isChanged = false;
            for (File file : files) {
                if (this.isAcceptable(file)) {
                    acceptableFiles.add(file);
                    continue;
                }
                if (this.fc.isTraversable(file)) {
                    traversableFiles.add(file);
                    continue;
                }
                isChanged = true;
            }
            if (!traversableFiles.isEmpty()) {
                if (acceptableFiles.isEmpty()) {
                    if (traversableFiles.size() > 1) {
                        traversableFiles = traversableFiles.subList(0, 1);
                        isChanged = true;
                    }
                } else {
                    traversableFiles = new ArrayList();
                    isChanged = true;
                }
            }
            List<File> result = new ArrayList<File>();
            result.addAll(acceptableFiles);
            result.addAll(traversableFiles);
            if (result.size() > 1 && !this.isMultipleSelection()) {
                result = result.subList(0, 1);
                isChanged = true;
            }
            if (isChanged) {
                ++this.isAdjusting;
                this.fc.setSelectedFiles(result.toArray(new File[result.size()]));
                --this.isAdjusting;
            }
            return result;
        }
        return files;
    }

    private List<File> getChooserSelection() {
        ArrayList<File> files = new ArrayList<File>();
        File dir = this.fc.getCurrentDirectory();
        if (this.isMultipleSelection()) {
            File[] fs;
            for (File f : fs = this.fc.getSelectedFiles()) {
                if (f == null) continue;
                if (!f.isAbsolute()) {
                    f = new File(dir, f.getPath());
                }
                files.add(f);
            }
        } else {
            File f = this.fc.getSelectedFile();
            if (f != null) {
                if (!f.isAbsolute()) {
                    f = new File(dir, f.getPath());
                }
                files.add(f);
            }
        }
        return files;
    }

    @Override
    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    protected JDialog getStandardDialog() {
        Window w = SwingUtilities.getWindowAncestor(this.fc);
        if (w instanceof JDialog) {
            Component c;
            JDialog d = (JDialog)w;
            JRootPane rp = d.getRootPane();
            int style = rp.getWindowDecorationStyle();
            if (style == 6) {
                return d;
            }
            Container contentPane = d.getContentPane();
            int componentCount = contentPane.getComponentCount();
            if (componentCount == 1 && (c = contentPane.getComponent(0)) == this.fc) {
                return d;
            }
        }
        return null;
    }

    protected void configureForShowing() {
        this.installSelectedView(true, true);
        if (this.fileNameTextField != null && this.isFileNameFieldVisible()) {
            this.fileNameTextField.selectAll();
            this.fileNameTextField.requestFocusInWindow();
        } else {
            this.activeView.requestFocusInWindow();
        }
        if (this.model != null) {
            this.model.setAutoValidate(UIManager.getBoolean("FileChooser.autovalidate"));
            TreePath subtreePath = this.first(this.activeView.getSelection());
            TreePath fullPath = this.subtreeModel.toFullPath(subtreePath);
            this.model.validatePath(fullPath);
            if (this.sidebarTreeModel != null) {
                this.sidebarTreeModel.lazyValidate();
            }
        }
        this.updateApproveButtonState();
        if (this.fc.getSelectedFile() != null) {
            this.ensureFileIsVisible(this.fc, this.fc.getSelectedFile());
        }
    }

    protected void configureForHiding() {
        if (this.model != null) {
            this.model.setAutoValidate(false);
            this.model.stopValidation();
            TreePath subtreePath = this.first(this.activeView.getSelection());
            TreePath fullPath = this.subtreeModel.toFullPath(subtreePath);
            this.model.invalidatePath(fullPath);
            this.clearIconCache();
        }
    }

    protected void configureDialog(JDialog d) {
        if (d != null) {
            String style = null;
            if (this.fc.getDialogType() == 0) {
                style = OSXSystemProperties.OSVersion >= 1011 ? "texturedToolBar" : "unifiedToolBar";
            }
            d.getRootPane().putClientProperty("Aqua.windowStyle", style);
        }
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        TreePath viewPath;
        if (this.activeView != null && (viewPath = this.getSubtreePath(f)) != null) {
            this.ensurePathIsVisible(viewPath);
        }
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.isDirectorySelectionEnabled() && this.chooseButtonText != null) {
            return this.chooseButtonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        if (fc.isShowing()) {
            TreePath subtreePath = this.first(this.activeView.getSelection());
            TreePath fullPath = this.subtreeModel.toFullPath(subtreePath);
            this.model.lazyInvalidatePath(fullPath);
            this.model.validatePath(fullPath);
        }
    }

    @Override
    public void clearIconCache() {
        try {
            this.fileView.getClass().getMethod("clearIconCache", new Class[0]).invoke((Object)this.fileView, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class AquaApproveSelectionAction
    extends AbstractAction {
        protected AquaApproveSelectionAction() {
            super("approveSelection");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaFileChooserUI.this.maybeApproveSelection();
        }
    }

    private class SidebarSelectionListener
    implements TreeSelectionListener {
        private SidebarSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (AquaFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            if (AquaFileChooserUI.this.sidebarTree != null) {
                AquaFileChooserUI.this.selectRootFromSidebarSelection();
            }
        }
    }

    protected class FileChooserHierarchyListener
    implements HierarchyListener {
        protected FileChooserHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Component c = e.getChanged();
            if (e.getChangeFlags() == 1L) {
                JDialog d = AquaFileChooserUI.this.getStandardDialog();
                AquaFileChooserUI.this.configureDialog(d);
            }
            if (e.getChangeFlags() == 4L) {
                if (c.isVisible()) {
                    AquaFileChooserUI.this.configureForShowing();
                } else {
                    AquaFileChooserUI.this.configureForHiding();
                }
            }
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentevent) {
        }

        private void textChanged() {
            if (AquaFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath selection = AquaFileChooserUI.this.first(AquaFileChooserUI.this.activeView.getSelection());
                    FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)selection.getLastPathComponent();
                    File file = node.getResolvedFile();
                    if (AquaFileChooserUI.this.fileNameTextField.getText().length() != 0) {
                        if (!node.isLeaf()) {
                            AquaFileChooserUI.this.updateApproveButtonState();
                            return;
                        }
                        file = new File(AquaFileChooserUI.this.fc.getFileSystemView().getParentDirectory(file), AquaFileChooserUI.this.fileNameTextField.getText());
                    }
                    AquaFileChooserUI.this.updateSelectedFile(file);
                    AquaFileChooserUI.this.updateApproveButtonState();
                }
            });
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusevent) {
            AquaFileChooserUI.this.updateApproveButtonState();
        }

        @Override
        public void focusLost(FocusEvent focusevent) {
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        private String showNewFolderDialog() {
            JOptionPane optionPane = new JOptionPane(AquaFileChooserUI.this.newFolderDialogPrompt, -1, 2);
            optionPane.setWantsInput(true);
            optionPane.putClientProperty("JOptionPane.textFieldDocument", new FilenameDocument());
            optionPane.setInitialSelectionValue(AquaFileChooserUI.this.newFolderDefaultName);
            optionPane.setOptions(new Object[]{UIManager.getString("FileChooser.createFolderButtonText"), UIManager.getString("FileChooser.cancelButtonText")});
            optionPane.setInitialValue(UIManager.getString("FileChooser.createFolderButtonText"));
            JDialog dialog = optionPane.createDialog(AquaFileChooserUI.this.fc, AquaFileChooserUI.this.newFolderTitleText);
            dialog.setVisible(true);
            dialog.dispose();
            return optionPane.getValue() == UIManager.getString("FileChooser.createFolderButtonText") ? (String)optionPane.getInputValue() : null;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            String newFolderName = this.showNewFolderDialog();
            if (newFolderName != null) {
                File newFolder;
                TreePath selection = AquaFileChooserUI.this.first(AquaFileChooserUI.this.activeView.getSelection());
                FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)selection.getLastPathComponent();
                File currentFile = node.getResolvedFile();
                if (node.isLeaf()) {
                    currentFile = currentFile.getParentFile();
                }
                if ((newFolder = new File(currentFile, newFolderName)).exists()) {
                    JOptionPane.showMessageDialog(AquaFileChooserUI.this.fc, AquaFileChooserUI.this.newFolderExistsErrorText, AquaFileChooserUI.this.newFolderTitleText, 0);
                    return;
                }
                try {
                    if (!newFolder.mkdir() && !newFolder.isDirectory()) {
                        throw new IOException("Couldn't create folder \"" + newFolder.getName() + "\".");
                    }
                    AquaFileChooserUI.this.fc.rescanCurrentDirectory();
                    AquaFileChooserUI.this.selectDirectory(newFolder, 4, null);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(AquaFileChooserUI.this.fc, AquaFileChooserUI.this.newFolderErrorText, AquaFileChooserUI.this.newFolderTitleText, 0);
                }
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AquaFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            TreePath path = AquaFileChooserUI.this.directoryComboBoxModel.getSelectedPath();
            if (path != null) {
                FileInfo info = (FileInfo)path.getLastPathComponent();
                final File dir = info.getResolvedFile();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AquaFileChooserUI.this.selectDirectory(dir, 2, null);
                    }
                });
            }
        }
    }

    protected class OptionsAction
    extends AbstractAction {
        protected OptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaFileChooserUI.this.isOptionsEnabled = !AquaFileChooserUI.this.isOptionsEnabled;
            AquaFileChooserUI.this.updateAccessoryViewPanel();
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = AquaFileChooserUI.this.fc.getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                AquaFileChooserUI.this.fc.setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter[] filters = AquaFileChooserUI.this.fc.getChoosableFileFilters();
            if (filters.length > 1) {
                FileFilter currentFilter = AquaFileChooserUI.this.fc.getFileFilter();
                boolean found = false;
                if (currentFilter != null) {
                    for (int i = 0; i < filters.length; ++i) {
                        if (filters[i] != currentFilter) continue;
                        found = true;
                    }
                    if (!found) {
                        AquaFileChooserUI.this.fc.addChoosableFileFilter(currentFilter);
                    }
                }
            }
            return AquaFileChooserUI.this.fc.getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return AquaFileChooserUI.this.fc.getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    protected static class FilterComboBoxRenderer
    extends AquaComboBoxRendererInternal {
        public FilterComboBoxRenderer(JComboBox cb) {
            super(cb);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value instanceof FileFilter) {
                value = ((FileFilter)value).getDescription();
            }
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        TreePath path;
        FileSystemTreeModel.Node selectedDirectory = null;

        private void setPath(TreePath path) {
            if (this.path != null && this.path.getPathCount() > 0) {
                this.fireIntervalRemoved(this, 0, this.path.getPathCount() - 1);
            }
            this.path = path;
            if (this.path.getPathCount() > 0) {
                this.fireIntervalAdded(this, 0, this.path.getPathCount() - 1);
            }
            this.setSelectedItem(this.path.getLastPathComponent());
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            FileSystemTreeModel.Node node;
            this.selectedDirectory = node = (FileSystemTreeModel.Node)selectedItem;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public TreePath getSelectedPath() {
            int count = this.path.getPathCount();
            for (int i = 0; i < count; ++i) {
                Object node = this.path.getPathComponent(i);
                if (!node.equals(this.selectedDirectory)) continue;
                return this.pathPrefix(this.path, i + 1);
            }
            return null;
        }

        private TreePath pathPrefix(TreePath base, int count) {
            Object[] nodes = new Object[count];
            for (int i = 0; i < count; ++i) {
                nodes[i] = base.getPathComponent(i);
            }
            return new TreePath(nodes);
        }

        @Override
        public int getSize() {
            return this.path == null ? 0 : this.path.getPathCount();
        }

        @Override
        public Object getElementAt(int index) {
            return this.path.getPathComponent(this.path.getPathCount() - index - 1);
        }
    }

    private static class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        private IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon == null ? this.depth * 10 : this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }
    }

    public static class SidebarTreeUI
    extends AquaTreeUI {
        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            InputMap map = this.tree.getInputMap(0).getParent();
            KeyStroke ks = KeyStroke.getKeyStroke("shift meta A");
            Object v = map.get(ks);
            if (v != null && v.equals("clearSelection")) {
                InputMap newMap = new InputMap();
                newMap.setParent(map);
                newMap.put(ks, "selectApplicationsFolder");
                SwingUtilities.replaceUIInputMap(this.tree, 0, newMap);
            }
        }
    }

    private static class SidebarRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean cellHasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, false);
            if (value != null && value instanceof SidebarTreeFileNode) {
                SidebarTreeFileNode info = (SidebarTreeFileNode)value;
                this.setText(info.getUserName());
                this.setIcon(this.getSpecialFolderIcon(info));
            }
            this.putClientProperty("Aqua.selected", isSelected);
            return this;
        }

        private Icon getSpecialFolderIcon(SidebarTreeFileNode info) {
            Icon icon = info.getIcon();
            if (icon != null) {
                return icon;
            }
            File file = info.getResolvedFile();
            if (file == null) {
                return UIManager.getIcon("FileChooser.sideBarIcon.GenericFolder");
            }
            if (file.getPath().equals("/Volumes")) {
                return OSXFile.getSidebarComputerIcon();
            }
            icon = UIManager.getIcon("FileChooser.sideBarIcon." + file.getName());
            if (icon == null) {
                if (OSXFile.isSavedSearch(file)) {
                    icon = UIManager.getIcon("FileChooser.sideBarIcon.SmartFolder");
                } else if (file.getParentFile() != null && file.getParentFile().getPath().equals("/Volumes")) {
                    File bf = new File(file, "Backups.backupdb");
                    if (bf.isDirectory()) {
                        icon = UIManager.getIcon("FileChooser.sideBarIcon.TimeMachineVolume");
                    }
                    if (icon == null) {
                        icon = UIManager.getIcon("FileChooser.sideBarIcon.GenericVolume");
                    }
                } else {
                    icon = file.getParentFile() != null && file.getParentFile().getPath().equals("/Users") ? UIManager.getIcon("FileChooser.sideBarIcon.Home") : UIManager.getIcon("FileChooser.sideBarIcon.GenericFolder");
                }
            }
            return icon;
        }
    }

    private static class SidebarTreeSelectionModel
    extends DefaultTreeSelectionModel {
        public SidebarTreeSelectionModel() {
            this.setSelectionMode(1);
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            TreePath path;
            Object pc;
            if (paths != null && paths.length > 0 && !((pc = (path = paths[0]).getLastPathComponent()) instanceof SidebarTreeFileNode)) {
                return;
            }
            super.setSelectionPaths(paths);
        }
    }

    static class DirectoryComboBoxRenderer
    extends AquaComboBoxRendererInternal {
        IndentIcon ii = new IndentIcon();
        private JSeparator separator = new JSeparator();

        public DirectoryComboBoxRenderer(JComboBox cb) {
            super(cb);
            this.separator.setPreferredSize(new Dimension(9, 9));
        }

        @Override
        public Insets getInsets(Insets insets) {
            Insets s = super.getInsets(insets);
            if (this.fInList) {
                ++s.top;
                ++s.bottom;
            }
            return s;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                super.getListCellRendererComponent(list, value, index, false, cellHasFocus);
                this.setText((String)value);
                this.setPreferredSize(new Dimension(10, 14));
                return this;
            }
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setPreferredSize(null);
            if (value instanceof File) {
                this.setText(value + " " + index);
                return this;
            }
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)value;
            if (node == null) {
                return this.separator;
            }
            this.setText(node.getUserName());
            this.ii.icon = node.getIcon();
            this.ii.depth = 0;
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class ViewModeChangeListener
    implements ChangeListener {
        protected ViewModeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AquaFileChooserUI.this.setViewMode(AquaFileChooserUI.this.viewModeControl.getSelectedViewMode());
        }
    }

    protected class ViewSelectListener
    implements FileChooserView.SelectListener {
        protected ViewSelectListener() {
        }

        @Override
        public void select(TreePath path) {
            FileInfo info = (FileInfo)path.getLastPathComponent();
            File f = info.getFile();
            if (info.isTraversable()) {
                if (AquaFileChooserUI.this.viewMode == 1) {
                    AquaFileChooserUI.this.selectDirectory(f, 3, null);
                }
            } else if (info.isAcceptable()) {
                if (!AquaFileChooserUI.this.isSelected(f)) {
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(f);
                    AquaFileChooserUI.this.installSelectedFiles(files);
                }
                AquaFileChooserUI.this.maybeApproveSelection();
            } else if (AquaFileChooserUI.this.fc.getDialogType() == 1) {
                AquaFileChooserUI.this.setFileName(f.getName());
            }
        }
    }

    protected class ViewSelectionChangeListener
    implements ChangeListener {
        protected ViewSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (AquaFileChooserUI.this.isAdjusting == 0) {
                AquaFileChooserUI.this.respondToUISelectionChange();
            }
        }
    }

    private class SidebarTree
    extends JTree {
        private SidebarTree() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 10;
            return d;
        }

        @Override
        public String toString() {
            return "SidebarTree";
        }
    }

    private class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        }
    }

    private class NavigationPanel
    extends JToolBar {
        public NavigationPanel() {
            this.setFloatable(false);
            this.setLayout(new BoxLayout(this, 0));
            this.setMargin(new Insets(7, 10, 7, 10));
            this.setBorderPainted(false);
        }
    }

    protected class RequestFileSelectionPathPane
    extends JPanel
    implements DocumentListener {
        private JLabel messageLabel;
        private JTextField inputField;
        private JLabel errorLabel;
        private JButton cancelButton;
        private JButton acceptButton;
        private File selection;

        public RequestFileSelectionPathPane(final JDialog parent, String initialText, String message, String cancelLabel, String acceptLabel, final String errorText) {
            this.messageLabel = new JLabel(message);
            this.errorLabel = new JLabel();
            this.inputField = AquaFileChooserUI.this.createTextField("Request File Input Field");
            this.cancelButton = AquaFileChooserUI.this.createButton(cancelLabel);
            this.acceptButton = AquaFileChooserUI.this.createButton(acceptLabel);
            this.inputField.putClientProperty("Quaqua.TextComponent.autoSelect", false);
            this.messageLabel.setAlignmentX(0.0f);
            this.inputField.setAlignmentX(0.0f);
            this.inputField.setColumns(32);
            this.errorLabel.setMaximumSize(new Dimension(100000, 100000));
            Font f = UIManager.getFont("FileChooser.sheetErrorFont");
            if (f == null) {
                f = UIManager.getFont("SmallSystemFont");
            }
            this.errorLabel.setFont(f);
            if (parent != null) {
                parent.getRootPane().setDefaultButton(this.acceptButton);
            }
            if (initialText != null) {
                this.inputField.setText(initialText);
            } else {
                this.inputField.setText(goToFolderText);
                if (!AquaFileChooserUI.this.goToFolderErrorText.isEmpty()) {
                    this.inputField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            RequestFileSelectionPathPane.this.inputField.selectAll();
                        }
                    });
                }
            }
            JPanel buttonPane = new JPanel();
            buttonPane.setAlignmentX(0.0f);
            buttonPane.setBorder(new EmptyBorder(12, 0, 6, 0));
            buttonPane.setLayout(new BoxLayout(buttonPane, 0));
            buttonPane.add(this.errorLabel);
            buttonPane.add(this.cancelButton);
            buttonPane.add(Box.createHorizontalStrut(6));
            buttonPane.add(this.acceptButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.messageLabel);
            this.add(this.inputField);
            this.add(buttonPane);
            this.inputField.getDocument().addDocumentListener(this);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (parent != null) {
                        parent.setVisible(false);
                    }
                    RequestFileSelectionPathPane.this.canceled();
                }
            });
            this.acceptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File currentDirectory;
                    String path = RequestFileSelectionPathPane.this.inputField.getText();
                    File f = OSXFile.resolvePath(path, currentDirectory = AquaFileChooserUI.this.fc.getCurrentDirectory());
                    if (!f.isDirectory()) {
                        RequestFileSelectionPathPane.this.errorLabel.setText(errorText);
                        RequestFileSelectionPathPane.this.inputField.selectAll();
                    } else {
                        RequestFileSelectionPathPane.this.selection = f;
                        goToFolderText = path;
                        if (parent != null) {
                            parent.setVisible(false);
                        }
                        RequestFileSelectionPathPane.this.accepted();
                    }
                }
            });
            this.pathChanged();
        }

        public File getSelection() {
            return this.selection;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.pathChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.pathChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.pathChanged();
        }

        protected void pathChanged() {
            this.errorLabel.setText("");
            this.acceptButton.setEnabled(!this.inputField.getText().isEmpty());
        }

        protected void canceled() {
        }

        protected void accepted() {
        }
    }

    private class TextKeyListener
    extends KeyAdapter {
        private TextKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char ch = e.getKeyChar();
            if (ch == '/' || ch == '~') {
                String text = "" + ch;
                AquaFileChooserUI.this.requestFileSelectionPath(text);
                e.consume();
            }
        }
    }

    private class KeyListenerAction
    extends AbstractAction {
        private KeyListenerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            File file = null;
            switch (ae.getActionCommand().charAt(0)) {
                case 'd': {
                    file = new File(System.getProperty("user.home") + "/Desktop");
                    break;
                }
                case 'c': {
                    FileSystemTreeModel.Node info = AquaFileChooserUI.this.fileSystemModel.getRoot();
                    file = info.getResolvedFile();
                    break;
                }
                case 'h': {
                    file = new File(System.getProperty("user.home"));
                    break;
                }
                case 'k': {
                    file = new File("/Network");
                    break;
                }
                case 'i': {
                    file = null;
                    return;
                }
                case 'a': {
                    file = new File("/Applications");
                    break;
                }
                case 'u': {
                    file = new File("/Applications/Utilities");
                    break;
                }
                case 'g': {
                    AquaFileChooserUI.this.requestFileSelectionPath(null);
                    return;
                }
                case 'o': {
                    file = new File(System.getProperty("user.home") + "/Documents");
                    break;
                }
                case '.': {
                    boolean isHiding = AquaFileChooserUI.this.fc.isFileHidingEnabled();
                    AquaFileChooserUI.this.fc.setFileHidingEnabled(!isHiding);
                    return;
                }
            }
            if (file != null) {
                if (file.isDirectory()) {
                    AquaFileChooserUI.this.selectDirectory(file, 4, null);
                } else if (AquaFileChooserUI.this.isAcceptable(file)) {
                    AquaFileChooserUI.this.fc.setSelectedFile(file);
                }
            }
        }
    }
}

