/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.DelegatedFileSystemViewBase;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.OSXFileSystemView;

public abstract class AquaFileSystemView
extends DelegatedFileSystemViewBase {
    private static AquaFileSystemView fileSystemView;

    public File canonicalize(File f) {
        return f;
    }

    public abstract File getComputer();

    public abstract File getSystemVolume();

    public FileView createFileView(JFileChooser chooser) {
        return new AquaFileView(this);
    }

    public static AquaFileSystemView getAquaFileSystemView() {
        if (fileSystemView == null) {
            fileSystemView = new OSXFileSystemView();
        }
        return fileSystemView;
    }

    @Override
    public Icon getSystemIcon(File f) {
        if (f.equals(this.getComputer())) {
            return UIManager.getIcon("FileView.computerIcon");
        }
        if (OSXFile.isAvailable()) {
            try {
                Image im = OSXFile.getIconImage(f, 16, false);
                return new ImageIcon(im);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return this.target.getSystemIcon(f);
    }

    @Override
    public String getSystemTypeDescription(File f) {
        if (OSXFile.isAvailable()) {
            return OSXFile.getKindString(f);
        }
        return this.target.getSystemTypeDescription(f);
    }

    @Override
    public Boolean isTraversable(File f) {
        if (OSXFile.isAvailable()) {
            return OSXFile.isTraversable(f);
        }
        return this.target.isTraversable(f);
    }

    public Boolean isTraversable(File f, boolean isPackageTraversable, boolean isApplicationTraversable) {
        if (OSXFile.isAvailable()) {
            return OSXFile.isTraversable(f, isPackageTraversable, isApplicationTraversable);
        }
        return this.target.isTraversable(f);
    }

    @Override
    public String getSystemDisplayName(File f) {
        if (f.equals(this.getComputer())) {
            String name = OSXFile.getComputerName();
            return name != null ? name : this.getSystemVolume().getName();
        }
        if (OSXFile.isAvailable()) {
            return OSXFile.getDisplayName(f);
        }
        return this.target.getSystemDisplayName(f);
    }
}

