/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.BrowserUI;
import org.violetlib.aqua.fc.CompositeTransferable;
import org.violetlib.aqua.fc.DefaultColumnCellRenderer;
import org.violetlib.aqua.fc.DefaultTransferable;
import org.violetlib.aqua.fc.JBrowser;

public class BasicBrowserUI
extends BrowserUI {
    protected JBrowser browser;
    public Icon sizeHandleIcon;
    private static final TransferHandler defaultTransferHandler = new BrowserTransferHandler();

    @Override
    public void installUI(JComponent c) {
        c.setBackground(UIManager.getColor("List.background"));
        c.setFont(UIManager.getFont("List.font"));
        this.sizeHandleIcon = UIManager.getIcon("Browser.sizeHandleIcon");
        this.browser = (JBrowser)c;
        this.installDefaults();
    }

    protected void installDefaults() {
        TransferHandler th;
        if (this.browser.getColumnCellRenderer() == null || this.browser.getColumnCellRenderer() instanceof UIResource) {
            this.browser.setColumnCellRenderer(this.createCellRenderer());
        }
        if ((th = this.browser.getTransferHandler()) == null || th instanceof UIResource) {
            this.browser.setTransferHandler(defaultTransferHandler);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
    }

    protected void uninstallDefaults() {
        if (this.browser.getTransferHandler() instanceof UIResource) {
            this.browser.setTransferHandler(null);
        }
    }

    @Override
    public Icon getSizeHandleIcon() {
        return this.sizeHandleIcon;
    }

    protected ListCellRenderer createCellRenderer() {
        return new DefaultColumnCellRenderer.UIResource(this.browser);
    }

    static class BrowserTransferHandler
    extends TransferHandler
    implements UIResource {
        private JBrowser browser;

        BrowserTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            while (c != null && !(c instanceof JBrowser)) {
                c = c.getParent() instanceof JComponent ? (JComponent)c.getParent() : null;
            }
            if (c != null) {
                this.browser = (JBrowser)c;
                TreePath[] paths = this.browser.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return null;
                }
                StringBuffer plainBuf = new StringBuffer();
                StringBuffer htmlBuf = new StringBuffer();
                htmlBuf.append("<html>\n<body>\n<ul>\n");
                TreeModel model = this.browser.getModel();
                Object lastPath = null;
                TreePath[] displayPaths = this.getDisplayOrderPaths(paths);
                for (int i = 0; i < displayPaths.length; ++i) {
                    TreePath path = displayPaths[i];
                    Object node = path.getLastPathComponent();
                    boolean leaf = model.isLeaf(node);
                    String label = this.getDisplayString(path, true, leaf);
                    plainBuf.append(label + "\n");
                    htmlBuf.append("  <li>" + label + "\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                htmlBuf.append("</ul>\n</body>\n</html>");
                this.browser = null;
                CompositeTransferable t = new CompositeTransferable();
                t.add(new DefaultTransferable(htmlBuf.toString(), "text/html", "HTML"));
                t.add(new DefaultTransferable(plainBuf.toString(), "text/plain", "Text"));
                return t;
            }
            return null;
        }

        String getDisplayString(TreePath path, boolean selected, boolean leaf) {
            String sValue;
            Object node = path.getLastPathComponent();
            if (node != null && (sValue = node.toString()) != null) {
                return sValue;
            }
            return "";
        }

        TreePath[] getDisplayOrderPaths(TreePath[] paths) {
            ArrayList<TreePath> selOrder = new ArrayList<TreePath>();
            for (int i = 0; i < paths.length; ++i) {
                selOrder.add(paths[i]);
            }
            int n = selOrder.size();
            TreePath[] displayPaths = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                displayPaths[i] = (TreePath)selOrder.get(i);
            }
            return displayPaths;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }
}

