/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.OSXFile;

public abstract class BasicOSXFileSystemView
extends AquaFileSystemView {
    protected final File volumesFolder = new File("/Volumes");
    protected final File networkFolder = new File("/Network");
    protected final File unixRoot = new File("/");
    private final File computer = this.volumesFolder;
    protected File systemVolume;
    protected static final Set<String> hiddenTopLevelNames = new HashSet<String>();
    protected static final Set<String> hiddenDirectoryNames = new HashSet<String>();
    protected static final Set<File> hiddenFiles = new HashSet<File>();

    protected BasicOSXFileSystemView() {
    }

    @Override
    public final File getSystemVolume() {
        if (this.systemVolume == null) {
            this.systemVolume = this.determineSystemVolume();
        }
        return this.systemVolume;
    }

    protected File determineSystemVolume() {
        File[] volumes = this.volumesFolder.listFiles();
        File sys = null;
        if (volumes != null) {
            for (File volume : volumes) {
                try {
                    if (!volume.getCanonicalFile().equals(this.unixRoot)) continue;
                    sys = volume;
                    break;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return sys == null ? this.unixRoot : sys;
    }

    @Override
    public File getComputer() {
        return this.computer;
    }

    @Override
    public File canonicalize(File f) {
        if (f.equals(this.unixRoot)) {
            return this.getSystemVolume();
        }
        return f;
    }

    @Override
    public File getParentDirectory(File dir) {
        File parent;
        File file = parent = this.isRoot(dir) ? null : super.getParentDirectory(dir);
        if (parent != null && parent.equals(this.unixRoot)) {
            parent = this.getSystemVolume();
        }
        return parent;
    }

    protected List<File> getRootList() {
        ArrayList<File> result = new ArrayList<File>();
        File[] fs = this.volumesFolder.listFiles();
        if (fs != null) {
            result.addAll(Arrays.asList(fs));
        }
        result.add(this.networkFolder);
        return result;
    }

    @Override
    public final File[] getRoots() {
        List<File> roots = this.getRootList();
        return roots.toArray(new File[roots.size()]);
    }

    @Override
    public boolean isHiddenFile(File f) {
        if (OSXFile.isInvisible(f)) {
            return true;
        }
        String name = f.getName();
        if (name.length() == 0) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '\r') {
            return true;
        }
        if (name.charAt(0) == '.') {
            return true;
        }
        if (hiddenTopLevelNames.contains(name) && (f.getParent() == null || this.isRoot(f.getParentFile()))) {
            return true;
        }
        if (hiddenDirectoryNames.contains(name)) {
            return true;
        }
        return hiddenFiles.contains(f);
    }

    @Override
    public boolean isRoot(File aFile) {
        return aFile.equals(this.unixRoot) || aFile.equals(this.networkFolder) || aFile.getParentFile() != null && aFile.getParentFile().equals(this.volumesFolder);
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        File parentFile = dir.getParentFile();
        return parentFile == null || parentFile.equals(this.volumesFolder);
    }

    @Override
    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    @Override
    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    @Override
    public Icon getSystemIcon(File f) {
        Icon icon;
        if (f.equals(this.networkFolder) && (icon = UIManager.getIcon("FileView.networkIcon")) != null) {
            return icon;
        }
        return super.getSystemIcon(f);
    }
}

