/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.AquaFileChooserBrowser;
import org.violetlib.aqua.fc.BrowserPreviewRenderer;
import org.violetlib.aqua.fc.ColumnView;
import org.violetlib.aqua.fc.FilePreview;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.JBrowser;
import org.violetlib.aqua.fc.SubtreeTreeModel;

public class ColumnViewImpl
extends ColumnView {
    public static final String PREVIEW_COMPONENT_CLIENT_PROPERTY_KEY = "JFileChooser.previewComponent";
    protected final JFileChooser fc;
    protected final AquaFileChooserBrowser browser;
    protected final JScrollPane browserScrollPane;
    private final MouseListener mouseListener;
    private final TreeSelectionListener treeSelectionListener;
    private boolean isActive;

    public ColumnViewImpl(JFileChooser fc) {
        this.fc = fc;
        this.mouseListener = this.createDoubleClickListener();
        this.treeSelectionListener = new MyTreeSelectionListener();
        this.setFocusable(false);
        this.browser = new ColumnViewBrowser(fc);
        this.browser.setFixedCellWidth(170);
        this.browser.setShowCellTipOrigin((Point)UIManager.get("FileChooser.cellTipOrigin"));
        this.browser.setShowCellTips(true);
        this.browser.setPreviewColumnFilled(true);
        this.browserScrollPane = new JScrollPane();
        this.browserScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserScrollPane.setViewportView(this.browser);
        this.browserScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.browserScrollPane.setFocusable(false);
        this.browserScrollPane.getVerticalScrollBar().setFocusable(false);
        this.browserScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.setLayout(new BorderLayout());
        this.add(this.browserScrollPane);
    }

    @Override
    public void setActive(boolean b) {
        this.isActive = b;
        if (b) {
            this.browser.addMouseListener(this.mouseListener);
            this.browser.addTreeSelectionListener(this.treeSelectionListener);
        } else {
            this.browser.removeMouseListener(this.mouseListener);
            this.browser.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    @Override
    public void setModel(SubtreeTreeModel m) {
        this.browser.setModel(m);
        FileSystemTreeModel fullModel = (FileSystemTreeModel)m.getTargetModel();
        this.browser.setPrototypeCellValue(fullModel.getPrototypeValue());
    }

    @Override
    public void setFileRenderer(GenericCellRenderer r) {
        this.browser.setColumnCellRenderer((ListCellRenderer)((Object)r));
    }

    @Override
    public void setMultipleSelection(boolean b) {
        if (b) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
        }
    }

    @Override
    public List<TreePath> getSelection() {
        TreePath[] ps = this.browser.getSelectionPaths();
        return ps != null ? new ArrayList<TreePath>(Arrays.asList(ps)) : new ArrayList();
    }

    @Override
    public void setSelection(TreePath path) {
        this.browser.setSelectionPath(path);
    }

    @Override
    public void setSelection(List<TreePath> paths) {
        TreePath[] ps = paths.toArray(new TreePath[paths.size()]);
        this.browser.setSelectionPaths(ps);
    }

    @Override
    public void ensurePathIsVisible(TreePath path) {
        this.browser.ensurePathIsVisible(path);
    }

    private void installPreviewComponent() {
        final Component pv = (Component)this.fc.getClientProperty(PREVIEW_COMPONENT_CLIENT_PROPERTY_KEY);
        if (pv != null) {
            this.browser.setPreviewRenderer(new BrowserPreviewRenderer(){

                @Override
                public Component getPreviewRendererComponent(JBrowser browser, TreePath[] paths) {
                    return pv;
                }
            });
            this.browser.setPreviewColumnWidth(Math.max(this.browser.getFixedCellWidth(), pv.getPreferredSize().width));
        } else {
            boolean isSave = this.isFileNameFieldVisible();
            this.browser.setPreviewRenderer(isSave ? null : this.createFilePreview(this.fc));
            this.browser.setPreviewColumnWidth(this.browser.getFixedCellWidth());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.browser.requestFocusInWindow();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.browser.addKeyListener(l);
    }

    @Override
    public void reconfigure() {
        this.setMultipleSelection(this.fc.isMultiSelectionEnabled());
        this.browser.repaint();
        this.installPreviewComponent();
        this.browser.updatePreviewColumn();
    }

    @Override
    public synchronized void setDropTarget(DropTarget dt) {
        super.setDropTarget(dt);
        this.browser.setDropTarget(dt);
    }

    protected MouseListener createDoubleClickListener() {
        return new DoubleClickListener();
    }

    protected boolean isFileNameFieldVisible() {
        return this.fc.getDialogType() == 1 || this.fc.getDialogType() == 2;
    }

    protected BrowserPreviewRenderer createFilePreview(JFileChooser fc) {
        return new FilePreview(fc);
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && ColumnViewImpl.this.fc.getDialogType() != 1 && (path = ColumnViewImpl.this.browser.getPathForLocation(e.getX(), e.getY())) != null) {
                for (TreePath tp : ColumnViewImpl.this.browser.getSelectionPaths()) {
                    FileSystemTreeModel.Node n = (FileSystemTreeModel.Node)tp.getLastPathComponent();
                    if (ColumnViewImpl.this.fc.accept(n.getFile())) continue;
                    return;
                }
                ColumnViewImpl.this.select(path);
            }
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ColumnViewImpl.this.selectionChanged();
        }
    }

    protected class ColumnViewBrowser
    extends AquaFileChooserBrowser {
        public ColumnViewBrowser(JFileChooser fc) {
            super(fc);
        }

        @Override
        protected void fileSelectedInSavePanel(File f) {
            if (ColumnViewImpl.this.isActive) {
                SubtreeTreeModel model = (SubtreeTreeModel)this.getModel();
                FileSystemTreeModel fullModel = (FileSystemTreeModel)model.getTargetModel();
                TreePath path = fullModel.toPath(f, null);
                ColumnViewImpl.this.select(path);
            }
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (ColumnViewImpl.this.browser.isPreviewColumnFilled()) {
                JViewport vp = (JViewport)this.getParent();
                int viewPreferredWidth = vp.getPreferredSize().width;
                Dimension extentSize = vp.getExtentSize();
                if (extentSize.width > viewPreferredWidth) {
                    return true;
                }
            }
            return false;
        }
    }
}

