/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.violetlib.aqua.fc.AquaFileChooserUI;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;

public class FileInfoUpdateWorker
implements Runnable {
    protected final FileSystemTreeModel.UpdatableFileNode node;
    protected final File f;
    protected final JFileChooser fc;

    public FileInfoUpdateWorker(FileSystemTreeModel.UpdatableFileNode node) {
        this.node = node;
        this.f = node.getFile();
        this.fc = node.getFileChooser();
    }

    @Override
    public void run() {
        int label = OSXFile.getLabel(this.f);
        this.updateFileLabel(label);
        this.updateIcon();
        this.updateCompleted();
    }

    protected void updateIcon() {
        if (!this.canGetFileIconDirectly()) {
            Icon icon = this.fc.getIcon(this.f);
            this.updateFileIcon(icon);
            return;
        }
        try {
            Image basicImage = OSXFile.getIconImage(this.f, 16, false);
            this.updateFileIcon(new ImageIcon(basicImage));
        }
        catch (UnsupportedOperationException basicImage) {
            // empty catch block
        }
        try {
            Image quickLookImage = OSXFile.getIconImage(this.f, 16, true);
            this.updateFileIcon(new ImageIcon(quickLookImage));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected boolean canGetFileIconDirectly() {
        if (this.fc.getClass() != JFileChooser.class) {
            return false;
        }
        FileView fv = this.fc.getFileView();
        if (fv instanceof AquaFileView) {
            return true;
        }
        if (fv == null) {
            FileChooserUI ui = this.fc.getUI();
            return ui instanceof AquaFileChooserUI;
        }
        return false;
    }

    protected void updateFileLabel(final int label) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileInfoUpdateWorker.this.node.updateFileLabel(label);
            }
        });
    }

    protected void updateFileIcon(final Icon icon) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileInfoUpdateWorker.this.node.updateFileIcon(icon);
            }
        });
    }

    protected void updateCompleted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileInfoUpdateWorker.this.node.updateCompleted();
            }
        });
    }
}

