/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.BrowserPreviewRenderer;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.JBrowser;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.OverlayContainer;

public class FilePreview
extends JPanel
implements BrowserPreviewRenderer {
    private JFileChooser fileChooser;
    private JPanel emptyPreview;
    private FileInfo info;
    private JLabel nameView;
    private JTable attributeView;
    private Font labelFont;
    private Font valueFont;
    private Font typeSizeFont;
    private String labelDelimiter;
    private ScaledImageView previewImageView;
    private JProgressBar imageLoadingIndicator;
    private boolean imageIsLoading;
    private Timer imageLoadingTimer;
    private static final Object LABEL_COLUMN_ID = new Object();

    public FilePreview(JFileChooser fileChooser) {
        Box p;
        this.fileChooser = fileChooser;
        this.previewImageView = new ScaledImageView();
        this.previewImageView.setMinimumSize(new Dimension(128, 128));
        this.previewImageView.setPreferredSize(new Dimension(128, 128));
        this.imageLoadingIndicator = this.createImageLoadingIndicator();
        this.imageLoadingTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilePreview.this.imageIsLoading) {
                    FilePreview.this.imageLoadingIndicator.setVisible(true);
                }
            }
        });
        this.imageLoadingTimer.setRepeats(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
        this.setLayout(new BorderLayout());
        Color bg = UIManager.getColor("List.background");
        Color fgl = UIManager.getColor("FileChooser.previewLabelForeground");
        Color fgv = UIManager.getColor("FileChooser.previewValueForeground");
        this.labelFont = UIManager.getFont("FileChooser.previewLabelFont");
        this.valueFont = UIManager.getFont("FileChooser.previewValueFont");
        this.typeSizeFont = UIManager.getFont("FileChooser.previewTypeSizeFont");
        this.emptyPreview = new JPanel();
        this.emptyPreview.setBackground(bg);
        this.emptyPreview.setOpaque(true);
        Insets labelInsets = UIManager.getInsets("FileChooser.previewLabelInsets");
        this.labelDelimiter = UIManager.getString("FileChooser.previewLabelDelimiter");
        if (this.labelDelimiter == null) {
            this.labelDelimiter = "";
        }
        int columnSeparation = 5;
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        TableColumn names = new TableColumn();
        names.setIdentifier(LABEL_COLUMN_ID);
        SimpleTableCellRenderer r = new SimpleTableCellRenderer(this.labelFont, fgl);
        r.setHorizontalAlignment(4);
        Insets borderMargin = new Insets(0, 0, 0, 0);
        r.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        names.setCellRenderer(r);
        names.setModelIndex(0);
        cm.addColumn(names);
        TableColumn values = new TableColumn();
        r = new SimpleTableCellRenderer(this.valueFont, fgv);
        r.setHorizontalAlignment(2);
        values.setCellRenderer(r);
        values.setModelIndex(1);
        cm.addColumn(values);
        if (OSXSystemProperties.OSVersion >= 1010) {
            r.setRowZeroFont(this.typeSizeFont);
            r.setRowZeroColor(fgl);
        }
        this.attributeView = new JTable(null, cm);
        this.attributeView.setIntercellSpacing(new Dimension(columnSeparation, 0));
        this.attributeView.setAutoResizeMode(0);
        this.attributeView.setFocusable(false);
        this.setBackground(bg);
        this.attributeView.setBackground(bg);
        this.setOpaque(true);
        OverlayContainer imageHolder = new OverlayContainer();
        imageHolder.add(this.imageLoadingIndicator);
        imageHolder.add(this.previewImageView);
        imageHolder.setMinimumSize(new Dimension(128, 128));
        imageHolder.setPreferredSize(new Dimension(128, 128));
        this.add(imageHolder);
        Box vb = new Box(1);
        this.add((Component)vb, "South");
        if (OSXSystemProperties.OSVersion < 1010) {
            GrayLine b = new GrayLine();
            b.setBorder(new EmptyBorder(5, 25, 5, 25));
            vb.add(b);
        } else {
            this.nameView = new JLabel();
            this.nameView.setFont(UIManager.getFont("FileChooser.previewNameFont"));
            p = new Box(0);
            p.add(Box.createHorizontalGlue());
            p.add(this.nameView);
            p.add(Box.createHorizontalGlue());
            p.setBorder(new EmptyBorder(0, 0, 20, 0));
            vb.add(p);
        }
        p = new Box(0);
        p.add(Box.createHorizontalGlue());
        p.add(this.attributeView);
        p.add(Box.createHorizontalGlue());
        p.setBorder(new EmptyBorder(0, 0, 40, 0));
        vb.add(p);
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    FilePreview.this.fileChooser.approveSelection();
                }
            }
        };
        this.addMouseListener(mouseHandler);
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].addMouseListener(mouseHandler);
        }
    }

    protected JProgressBar createImageLoadingIndicator() {
        JProgressBar b = new JProgressBar();
        b.setIndeterminate(true);
        b.putClientProperty("JProgressBar.style", "circular");
        return b;
    }

    private String toOSXPath(File file) {
        StringBuffer buf = new StringBuffer();
        AquaFileSystemView fsv = AquaFileSystemView.getAquaFileSystemView();
        if (file != null && file.isDirectory()) {
            buf.append(':');
        }
        while (file != null) {
            buf.insert(0, this.fileChooser.getName(file));
            if ((file = ((FileSystemView)fsv).getParentDirectory(file)) == null) continue;
            buf.insert(0, ':');
        }
        return buf.toString();
    }

    @Override
    public Component getPreviewRendererComponent(JBrowser browser, TreePath[] paths) {
        File resolvedFile;
        if (paths.length > 1) {
            return this.emptyPreview;
        }
        Locale locale = Locale.getDefault();
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(1);
        this.info = (FileInfo)paths[0].getLastPathComponent();
        if (!this.info.isAcceptable()) {
            return this.emptyPreview;
        }
        File file = this.info.getFile();
        String name = this.info.getUserName();
        String kind = OSXFile.getKindString(file);
        String size = this.getLengthString(this.info.getFileLength());
        Date lastUsedDate = OSXFile.getLastUsedDate(file);
        String modified = this.getModifiedString(file);
        if (this.nameView != null) {
            this.nameView.setText(name);
        }
        AttributeTableModel m = new AttributeTableModel();
        if (OSXSystemProperties.OSVersion < 1010) {
            m.add("name", name);
            m.add("kind", kind);
            if (size != null) {
                m.add("size", size);
            }
            m.add("modified", modified);
            if (lastUsedDate != null) {
                m.add("lastUsed", this.getLastUsedString(lastUsedDate));
            }
        } else {
            String s = kind;
            if (size != null) {
                s = s + " - " + size;
            }
            m.add("", s);
            m.add("modified", modified);
            if (lastUsedDate != null) {
                m.add("lastUsed", this.getLastUsedString(lastUsedDate));
            }
        }
        if (this.info.isAlias() && (resolvedFile = this.info.lazyGetResolvedFile()) != null) {
            m.add("original", this.toOSXPath(resolvedFile));
        }
        this.attributeView.setModel(m);
        m.updatePreferredWidths();
        this.attributeView.revalidate();
        this.attributeView.repaint();
        this.updatePreviewImage();
        return this;
    }

    protected String getLengthString(long fileLength) {
        float scaledLength;
        String label;
        if (fileLength < 0L) {
            return null;
        }
        if (fileLength >= 1000000000L) {
            label = "FileChooser.sizeGBytesOnly";
            scaledLength = (float)fileLength / 1.0E9f;
        } else if (fileLength >= 1000000L) {
            label = "FileChooser.sizeMBytesOnly";
            scaledLength = (float)fileLength / 1000000.0f;
        } else if (fileLength >= 1024L) {
            label = "FileChooser.sizeKBytesOnly";
            scaledLength = (float)fileLength / 1000.0f;
        } else {
            label = "FileChooser.sizeBytesOnly";
            scaledLength = fileLength;
        }
        String format = UIManager.getString(label);
        if (format != null) {
            return MessageFormat.format(format, Float.valueOf(scaledLength), fileLength);
        }
        return "" + fileLength;
    }

    protected String getModifiedString(File f) {
        if (f != null) {
            return DateFormat.getInstance().format(new Date(f.lastModified()));
        }
        return null;
    }

    protected String getLastUsedString(Date d) {
        return DateFormat.getInstance().format(d);
    }

    private void updatePreviewImage() {
        File file;
        this.imageLoadingIndicator.setVisible(false);
        this.previewImageView.setVisible(false);
        this.previewImageView.setImage(null);
        this.imageIsLoading = false;
        if (this.info != null && (file = this.info.lazyGetResolvedFile()) != null) {
            this.imageIsLoading = true;
            boolean useQuickLook = UIManager.getBoolean("FileChooser.quickLookEnabled");
            PreviewWorker w = new PreviewWorker(file, useQuickLook);
            w.execute();
            this.imageLoadingTimer.start();
        }
    }

    protected void installPreviewImage(Image im) {
        this.imageLoadingTimer.stop();
        this.imageIsLoading = false;
        this.imageLoadingIndicator.setVisible(false);
        this.previewImageView.setImage(im);
        if (im != null) {
            this.previewImageView.setVisible(true);
        }
    }

    public static int getTextWidth(String s, Font f, JComponent c) {
        Dimension size = FilePreview.getTextSize(s, f, c);
        return size != null ? size.width : 0;
    }

    public static Dimension getTextSize(String s, Font f, JComponent c) {
        if (f == null && (f = c.getFont()) == null) {
            return null;
        }
        FontMetrics fm = null;
        try {
            fm = c.getFontMetrics(f);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (fm == null) {
            return null;
        }
        int w = fm.stringWidth(s);
        int h = fm.getHeight();
        return new Dimension(w, h);
    }

    private static class ScaledImageView
    extends JComponent {
        private Image im;

        private ScaledImageView() {
        }

        public void setImage(Image im) {
            this.im = im;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.im != null) {
                Insets s = this.getInsets();
                int left = s.left;
                int top = s.top;
                int cwidth = this.getWidth() - s.left - s.right;
                int cheight = this.getHeight() - s.top - s.bottom;
                float imwidth = this.im.getWidth(null);
                float imheight = this.im.getHeight(null);
                if (imwidth > 0.0f && imheight > 0.0f) {
                    int size = Math.min(cwidth, cheight);
                    float scale = Math.min((float)cwidth / imwidth, (float)cheight / imheight);
                    int extraLeft = (int)Math.max(0.0f, ((float)cwidth - imwidth * scale) / 2.0f);
                    int extraTop = (int)Math.max(0.0f, ((float)cheight - imheight * scale) / 2.0f);
                    g.drawImage(this.im, left + extraLeft, top + extraTop, size, size, null);
                }
            }
        }
    }

    private static class GrayLine
    extends JComponent {
        private GrayLine() {
        }

        @Override
        public Dimension getMinimumSize() {
            Insets s = this.getInsets();
            return new Dimension(0, s.top + s.bottom + 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            Insets s = this.getInsets();
            return new Dimension(100000, s.top + s.bottom + 1);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets s = this.getInsets();
            g.setColor(new Color(0xD9D9D9));
            g.fillRect(s.left, s.top, this.getWidth() - s.left - s.right, 1);
        }
    }

    private static class SimpleTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private Font f;
        private Color fg;
        private Font rowZeroFont;
        private Color rowZeroColor;

        public SimpleTableCellRenderer(Font f, Color fg) {
            this.f = f;
            this.fg = fg;
            this.setOpaque(false);
        }

        public void setRowZeroFont(Font f) {
            this.rowZeroFont = f;
        }

        public void setRowZeroColor(Color c) {
            this.rowZeroColor = c;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setFont(row == 0 && this.rowZeroFont != null ? this.rowZeroFont : this.f);
            this.setForeground(row == 0 && this.rowZeroColor != null ? this.rowZeroColor : this.fg);
            return this;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || propertyName == "labelFor" || propertyName == "displayedMnemonic" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    protected class PreviewWorker
    extends SwingWorker<Image, Image> {
        private final File file;
        private final boolean useQuickLook;

        public PreviewWorker(File file, boolean useQuickLook) {
            this.file = file;
            this.useQuickLook = useQuickLook;
        }

        @Override
        protected Image doInBackground() throws Exception {
            if (this.useQuickLook) {
                QuickLookPreviewWorker w = new QuickLookPreviewWorker(this.file);
                w.execute();
                Image im = (Image)w.get(10L, TimeUnit.SECONDS);
                w.cancel(true);
                if (im != null) {
                    this.publish(im);
                    return im;
                }
            }
            Image im = OSXFile.getIconImage(this.file, 512, false);
            this.publish(im);
            return im;
        }

        @Override
        protected void process(List<Image> chunks) {
            FilePreview.this.installPreviewImage(chunks.get(0));
        }
    }

    protected class QuickLookPreviewWorker
    extends SwingWorker<Image, Image> {
        private final File file;

        public QuickLookPreviewWorker(File file) {
            this.file = file;
        }

        @Override
        protected Image doInBackground() throws Exception {
            try {
                return OSXFile.getIconImage(this.file, 1600, true);
            }
            catch (UnsupportedOperationException ex) {
                return null;
            }
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();
        private int nameWidth;
        private int valueWidth;

        private AttributeTableModel() {
        }

        public void add(String name, String value) {
            if (value != null && !value.isEmpty()) {
                String s = UIManager.getString("FileChooser." + name);
                String actualName = (s != null ? s : name) + FilePreview.this.labelDelimiter;
                this.names.add(actualName);
                this.values.add(value);
                this.nameWidth = Math.max(this.nameWidth, FilePreview.getTextWidth(actualName, FilePreview.this.labelFont, FilePreview.this.attributeView));
                this.valueWidth = Math.max(this.valueWidth, FilePreview.getTextWidth(value, FilePreview.this.valueFont, FilePreview.this.attributeView));
            }
        }

        public void updatePreferredWidths() {
            int fudge = 15;
            FilePreview.this.attributeView.getColumnModel().getColumn(0).setPreferredWidth(this.nameWidth + fudge);
            FilePreview.this.attributeView.getColumnModel().getColumn(1).setPreferredWidth(this.valueWidth + fudge);
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            if (columnIndex == 1) {
                return "Value";
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.names.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.values.get(rowIndex);
            }
            return null;
        }
    }
}

