/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import org.violetlib.aqua.fc.SubtreeFileChooserUI;

public class FileTransferHandler
implements DropTargetListener {
    private JFileChooser fileChooser;

    public FileTransferHandler(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public void setFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        this.handleDrag(evt);
    }

    private void handleDrag(DropTargetDragEvent evt) {
        if (!evt.getCurrentDataFlavorsAsList().contains(DataFlavor.javaFileListFlavor)) {
            evt.rejectDrag();
        }
        if (evt.getDropAction() != 1) {
            if ((evt.getSourceActions() & 1) != 0) {
                evt.acceptDrag(1);
            } else {
                evt.rejectDrag();
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        this.handleDrag(evt);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
        this.handleDrag(evt);
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        evt.acceptDrop(1);
        boolean success = false;
        try {
            List files;
            File[] fileArray;
            if (this.fileChooser != null && (fileArray = (files = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[files.size()])).length > 0) {
                if (this.fileChooser.getUI() instanceof SubtreeFileChooserUI) {
                    File dir = fileArray[0];
                    if (dir.isDirectory() && fileArray.length == 1 && this.fileChooser.getFileSelectionMode() == 0) {
                        ((SubtreeFileChooserUI)((Object)this.fileChooser.getUI())).selectDirectory(dir);
                    } else {
                        if ((dir = dir.getParentFile()) != null) {
                            ((SubtreeFileChooserUI)((Object)this.fileChooser.getUI())).selectDirectory(dir);
                        }
                        this.fileChooser.setSelectedFiles(fileArray);
                    }
                } else {
                    this.fileChooser.setSelectedFiles(fileArray);
                }
            }
            success = true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        evt.dropComplete(success);
    }
}

