/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.FileChooserView;
import org.violetlib.aqua.fc.ListViewImpl;
import org.violetlib.aqua.fc.SubtreeTreeModel;

public abstract class ListView
extends JPanel
implements FileChooserView {
    protected SubtreeTreeModel model;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private FileChooserView.SelectListener selectListener;

    public static ListView create(JFileChooser fc) {
        return new ListViewImpl(fc);
    }

    @Override
    public void setModel(SubtreeTreeModel m) {
        if (m != this.model) {
            this.model = m;
            this.updateForNewModel();
        }
    }

    @Override
    public void addSelectionChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    @Override
    public void addSelectListener(FileChooserView.SelectListener l) {
        this.selectListener = l;
    }

    protected void selectionChanged() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    protected abstract void updateForNewModel();

    protected final void select(TreePath path) {
        if (this.selectListener != null) {
            this.selectListener.select(path);
        }
    }

    @Override
    public void ensureSelectionIsVisible() {
        List<TreePath> paths = this.getSelection();
        if (!paths.isEmpty()) {
            this.ensurePathIsVisible(paths.get(0));
        }
    }
}

