/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.violetlib.aqua.AquaTableHeaderCellRenderer;
import org.violetlib.aqua.fc.AquaFileChooserTreeTableUI;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.ListView;
import org.violetlib.treetable.AbstractTreeColumnModel;
import org.violetlib.treetable.DefaultTreeTableCellRenderer;
import org.violetlib.treetable.DefaultTreeTableSorter;
import org.violetlib.treetable.TreeColumnModel;
import org.violetlib.treetable.TreeTable;

public class ListViewImpl
extends ListView {
    protected final TreeTable tree;
    protected final JScrollPane listViewScrollPane;
    protected final MyTableColumnModel tableColumnModel;
    private Color labelColor;
    private Font labelFont;
    private int COLUMN_MARGIN = 10;
    private GenericCellRenderer fileRenderer;
    protected final JFileChooser fc;
    private final TreeSelectionListener treeSelectionListener;
    protected Border tableHeaderBorder;

    public ListViewImpl(JFileChooser fc) {
        this.fc = fc;
        this.labelColor = UIManager.getColor("FileChooser.listView.extraColumnTextColor");
        Color headerColor = UIManager.getColor("FileChooser.listView.headerColor");
        Color headerBackground = UIManager.getColor("FileChooser.listView.headerBackground");
        this.labelFont = UIManager.getFont("FileChooser.listView.font");
        this.treeSelectionListener = new MyTreeSelectionListener();
        this.setFocusable(false);
        FileSystemTreeModel fakeTreeModel = new FileSystemTreeModel(fc);
        this.tableColumnModel = this.createColumnModel();
        this.tree = new MyTreeTable(fakeTreeModel, new MyTreeColumnModel(), this.tableColumnModel);
        this.tree.setUI(new MyTreeTableUI(fc, this.tree));
        this.tree.putClientProperty("JTree.style", "striped");
        this.tree.setRootVisible(false);
        this.tree.setAlternateRowColor(this.tree.getBackground());
        this.tree.setBackground(UIManager.getColor("List.alternateBackground.0"));
        this.tree.setNodeSortingEnabled(true);
        this.tree.setRowMargin(0);
        this.tree.setRowHeight(18);
        this.tree.setOpaque(false);
        this.listViewScrollPane = new JScrollPane();
        this.listViewScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.listViewScrollPane.setViewportView(this.tree);
        this.listViewScrollPane.setColumnHeaderView(this.tree.getTableHeader());
        this.setLayout(new BorderLayout());
        this.add(this.listViewScrollPane);
        this.tableHeaderBorder = new EmptyBorder(3, 3, 3, 0);
        JTableHeader header = this.tree.getTableHeader();
        header.setBackground(headerBackground);
        header.setForeground(headerColor);
        TableCellRenderer defaultHeaderRenderer = header.getDefaultRenderer();
        TableCellRenderer leftHeaderRenderer = this.createHeaderCellRenderer(defaultHeaderRenderer, 2);
        TableCellRenderer rightHeaderRenderer = this.createHeaderCellRenderer(defaultHeaderRenderer, 4);
        this.tableColumnModel.nameColumn.setHeaderRenderer(leftHeaderRenderer);
        this.tableColumnModel.dateModifiedColumn.setHeaderRenderer(leftHeaderRenderer);
        this.tableColumnModel.sizeColumn.setHeaderRenderer(rightHeaderRenderer);
        this.tableColumnModel.kindColumn.setHeaderRenderer(leftHeaderRenderer);
    }

    @Override
    public void setActive(boolean b) {
        TreeSelectionModel sm = this.tree.getSelectionModel();
        if (b) {
            sm.addTreeSelectionListener(this.treeSelectionListener);
        } else {
            sm.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.tree.addKeyListener(l);
    }

    @Override
    protected void updateForNewModel() {
        this.tree.setTreeModel(this.model);
        this.tree.setRowSorter(new MyTreeRowSorter(this.tree));
        this.tree.revalidate();
        this.tree.repaint();
    }

    @Override
    public void reconfigure() {
        this.setMultipleSelection(this.fc.isMultiSelectionEnabled());
        this.tree.repaint();
    }

    @Override
    public void setFileRenderer(GenericCellRenderer r) {
        this.fileRenderer = r;
        this.tree.repaint();
    }

    @Override
    public void setMultipleSelection(boolean b) {
        this.tree.getSelectionModel().setSelectionMode(b ? 4 : 1);
    }

    @Override
    public void setSelection(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    @Override
    public void setSelection(List<TreePath> paths) {
        TreePath[] ps = paths.toArray(new TreePath[paths.size()]);
        this.tree.setSelectionPaths(ps);
    }

    @Override
    public List<TreePath> getSelection() {
        TreePath[] ps = this.tree.getSelectionPaths();
        return ps != null ? new ArrayList<TreePath>(Arrays.asList(ps)) : new ArrayList();
    }

    @Override
    public void ensurePathIsVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    protected MyTableColumnModel createColumnModel() {
        return new MyTableColumnModel();
    }

    protected TableCellRenderer createHeaderCellRenderer(TableCellRenderer defaultRenderer, int align) {
        return new MyHeaderRenderer(align);
    }

    protected String getLengthString(long fileLength) {
        float scaledLength;
        String label;
        if (fileLength < 0L) {
            return "--";
        }
        if (fileLength >= 1000000000L) {
            label = "FileChooser.sizeGBytesOnly";
            scaledLength = (float)fileLength / 1.0E9f;
        } else if (fileLength >= 1000000L) {
            label = "FileChooser.sizeMBytesOnly";
            scaledLength = (float)fileLength / 1000000.0f;
        } else if (fileLength >= 1024L) {
            label = "FileChooser.sizeKBytesOnly";
            scaledLength = (float)fileLength / 1000.0f;
        } else {
            label = "FileChooser.sizeBytesOnly";
            scaledLength = fileLength;
        }
        String format = UIManager.getString(label);
        if (format != null) {
            return MessageFormat.format(format, Float.valueOf(scaledLength), fileLength);
        }
        return "" + fileLength;
    }

    protected String getModifiedString(File f, int width) {
        if (f != null) {
            Date d = new Date(f.lastModified());
            if (width < 150) {
                DateFormat df = DateFormat.getDateInstance(3);
                return df.format(d);
            }
            DateFormat df = DateFormat.getDateInstance();
            return df.format(d);
        }
        return "";
    }

    protected class MyTreeColumnModel
    extends AbstractTreeColumnModel {
        private List<String> columnNames = new ArrayList<String>();

        public MyTreeColumnModel() {
            this.columnNames.add("Name");
            this.columnNames.add("Date Modified");
            this.columnNames.add("Size");
            this.columnNames.add("Kind");
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames.get(column);
        }

        @Override
        public Object getValueAt(Object node, int column) {
            return (FileSystemTreeModel.Node)node;
        }
    }

    protected class MyHeaderRenderer
    extends AquaTableHeaderCellRenderer {
        public MyHeaderRenderer(int alignment) {
            this.setHorizontalAlignment(alignment);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Border border = c.getBorder();
            Border b = border != null ? new CompoundBorder(border, ListViewImpl.this.tableHeaderBorder) : ListViewImpl.this.tableHeaderBorder;
            c.setBorder(b);
            if (AquaTableHeaderCellRenderer.getColumnSortOrder(table, column) != null) {
                Font f = c.getFont();
                c.setFont(f.deriveFont(1));
            }
            return c;
        }
    }

    private class MyKindCellRenderer
    extends MyCellRenderer {
        private MyKindCellRenderer() {
            super(ListViewImpl.this.labelColor, 2);
        }

        @Override
        protected Object getCellValue(Object o) {
            FileSystemTreeModel.Node pn = (FileSystemTreeModel.Node)o;
            return pn.getFileKind();
        }
    }

    private class MySizeCellRenderer
    extends MyCellRenderer {
        private MySizeCellRenderer() {
            super(ListViewImpl.this.labelColor, 4);
        }

        @Override
        protected Object getCellValue(Object o) {
            FileSystemTreeModel.Node pn = (FileSystemTreeModel.Node)o;
            return ListViewImpl.this.getLengthString(pn.getFileLength());
        }
    }

    private class MyDateCellRenderer
    extends MyCellRenderer {
        private MyDateCellRenderer() {
            super(ListViewImpl.this.labelColor, 2);
        }

        @Override
        protected Object getCellValue(Object o) {
            FileSystemTreeModel.Node pn = (FileSystemTreeModel.Node)o;
            File f = pn.lazyGetResolvedFile();
            return ListViewImpl.this.getModifiedString(f, ListViewImpl.this.tableColumnModel.dateModifiedColumn.getWidth());
        }
    }

    private class MyNameCellRenderer
    extends MyCellRenderer {
        private MyNameCellRenderer() {
            super(null, 2);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column, boolean expanded, boolean leaf) {
            Component c = ListViewImpl.this.fileRenderer.getCellRendererComponent(treeTable, value, selected, hasFocus);
            if (c == null) {
                c = super.getTreeTableCellRendererComponent(treeTable, value, selected, hasFocus, row, column, expanded, leaf);
            }
            return c;
        }
    }

    protected class MyCellRenderer
    extends DefaultTreeTableCellRenderer {
        protected Color fg;

        public MyCellRenderer(Color fg, int alignment) {
            this.fg = fg;
            this.setHorizontalAlignment(alignment);
            this.setFont(ListViewImpl.this.labelFont);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column) {
            hasFocus = false;
            value = this.getCellValue(value);
            Component c = super.getTreeTableCellRendererComponent(treeTable, value, selected, hasFocus, row, column);
            return this.fix(c, selected);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object value, boolean selected, boolean hasFocus, int row, int column, boolean expanded, boolean leaf) {
            value = this.getCellValue(value);
            Component c = super.getTreeTableCellRendererComponent(treeTable, value, selected, hasFocus, row, column, expanded, leaf);
            return this.fix(c, selected);
        }

        protected Object getCellValue(Object o) {
            return o;
        }

        protected Component fix(Component c, boolean selected) {
            if (this.fg != null && !selected) {
                c.setForeground(this.fg);
            }
            return c;
        }
    }

    protected class MyTableColumn
    extends TableColumn {
        public MyTableColumn(int modelIndex, int width, boolean canWiden, String name) {
            super(modelIndex, width + ListViewImpl.this.COLUMN_MARGIN);
            if (!canWiden) {
                this.setMaxWidth(this.getWidth());
            }
            this.setHeaderValue(name);
        }
    }

    protected class MyTableColumnModel
    extends DefaultTableColumnModel {
        public TableColumn nameColumn;
        public TableColumn dateModifiedColumn;
        public TableColumn sizeColumn;
        public TableColumn kindColumn;

        public MyTableColumnModel() {
            this.nameColumn = new MyTableColumn(0, 200, true, "Name");
            this.dateModifiedColumn = new MyTableColumn(1, 90, false, "Date Modified");
            this.sizeColumn = new MyTableColumn(2, 80, false, "Size");
            this.kindColumn = new MyTableColumn(3, 150, false, "Kind");
            this.nameColumn.setCellRenderer(new MyNameCellRenderer());
            this.dateModifiedColumn.setCellRenderer(new MyDateCellRenderer());
            this.sizeColumn.setCellRenderer(new MySizeCellRenderer());
            this.kindColumn.setCellRenderer(new MyKindCellRenderer());
            this.addColumn(this.nameColumn);
            this.addColumn(this.dateModifiedColumn);
            this.addColumn(this.sizeColumn);
            this.addColumn(this.kindColumn);
            this.setColumnMargin(ListViewImpl.this.COLUMN_MARGIN);
        }
    }

    protected class MyTreeTableUI
    extends AquaFileChooserTreeTableUI {
        public MyTreeTableUI(JFileChooser fc, TreeTable tt) {
            super(fc, tt);
        }

        @Override
        protected void select(TreePath path) {
            ListViewImpl.this.select(path);
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ListViewImpl.this.selectionChanged();
        }
    }

    protected class MyTreeRowSorter
    extends DefaultTreeTableSorter<TreeModel, TreeColumnModel, Object> {
        public MyTreeRowSorter(TreeTable tree) {
            super(tree.getTreeModel(), tree.getTreeColumnModel());
            this.setComparator(0, new FileSystemTreeModel.ByNameComparator());
            this.setComparator(1, new FileSystemTreeModel.ByDateComparator());
            this.setComparator(2, new FileSystemTreeModel.BySizeComparator());
            this.setComparator(3, new FileSystemTreeModel.ByKindComparator());
        }
    }

    protected class MyTreeTable
    extends TreeTable {
        public MyTreeTable(TreeModel tm, TreeColumnModel tcm, TableColumnModel cm) {
            super(tm, tcm, cm);
        }

        @Override
        public Icon getIcon(Object node, boolean expanded, boolean leaf) {
            if (node instanceof FileInfo) {
                FileInfo info = (FileInfo)node;
                return info.getIcon();
            }
            return super.getIcon(node, expanded, leaf);
        }
    }
}

