/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Images;
import org.violetlib.aqua.fc.ListStateIcon;

public class OSXFile {
    public static final int FILE_TYPE_ALIAS = 2;
    public static final int FILE_TYPE_DIRECTORY = 1;
    public static final int FILE_TYPE_FILE = 0;
    public static final int FILE_TYPE_UNKNOWN = -1;
    private static volatile Color[][] labelColors;
    private static String computerModel;
    private static boolean computerModelInitialized;
    private static Icon computerSidebarIcon;
    private static final int kLSItemInfoIsPlainFile = 1;
    private static final int kLSItemInfoIsPackage = 2;
    private static final int kLSItemInfoIsApplication = 4;
    private static final int kLSItemInfoIsContainer = 8;
    private static final int kLSItemInfoIsAliasFile = 16;
    private static final int kLSItemInfoIsSymlink = 32;
    private static final int kLSItemInfoIsInvisible = 64;
    private static final int kLSItemInfoIsNativeApp = 128;
    private static final int kLSItemInfoIsClassicApp = 256;
    private static final int kLSItemInfoAppPrefersNative = 512;
    private static final int kLSItemInfoAppPrefersClassic = 1024;
    private static final int kLSItemInfoAppIsScriptable = 2048;
    private static final int kLSItemInfoIsVolume = 4096;
    private static final int kLSItemInfoExtensionIsHidden = 0x100000;
    private static final RecyclableFileIcon aliasBadgeIcon;
    private static final RecyclableFileIcon genericComputerIcon;
    private static final RecyclableFileIcon directoryIcon;
    private static final RecyclableFileIcon fileIcon;
    private static final RecyclableFileIcon networkIcon;
    private static final RecyclableSidebarIcon airDropSidebarIcon;
    private static final RecyclableSidebarIcon allMyFilesSidebarIcon;
    private static final RecyclableSidebarIcon applicationsSidebarIcon;
    private static final RecyclableSidebarIcon desktopSidebarIcon;
    private static final RecyclableSidebarIcon documentsSidebarIcon;
    private static final RecyclableSidebarIcon downloadsSidebarIcon;
    private static final RecyclableSidebarIcon dropboxSidebarIcon;
    private static final RecyclableSidebarIcon genericFileSidebarIcon;
    private static final RecyclableSidebarIcon genericFolderSidebarIcon;
    private static final RecyclableSidebarIcon homeSidebarIcon;
    private static final RecyclableSidebarIcon moviesSidebarIcon;
    private static final RecyclableSidebarIcon musicSidebarIcon;
    private static final RecyclableSidebarIcon networkSidebarIcon;
    private static final RecyclableSidebarIcon picturesSidebarIcon;
    private static final RecyclableSidebarIcon smartFolderSidebarIcon;
    private static final RecyclableSidebarIcon timeMachineSidebarIcon;
    private static final RecyclableSidebarIcon utilitiesSidebarIcon;
    private static final RecyclableSidebarIcon genericVolumeSidebarIcon;
    private static final RecyclableSidebarIcon iMacSidebarIcon;
    private static final RecyclableSidebarIcon macMiniSidebarIcon;
    private static final RecyclableSidebarIcon macProSidebarIcon;
    private static final RecyclableSidebarIcon macProCylinderSidebarIcon;
    private static final RecyclableSidebarIcon pcSidebarIcon;
    private static final RecyclableSidebarIcon laptopSidebarIcon;
    private static String[] nonTraversableDirectories;
    private static String computerName;
    private static boolean haveFetchedComputerName;
    public static final int SIDEBAR_FAVORITES = 0;
    public static final int SIDEBAR_VOLUMES = 1;
    private static final SharedFileList[] sharedFileLists;

    private static Icon createSidebarIcon(Image im) {
        Color basicColor = UIManager.getColor("Tree.sideBar.foreground");
        Color selectedColor = UIManager.getColor("Tree.sideBar.selectionForeground");
        Image basic = OSXFile.createSidebarImage(im, basicColor);
        Image selected = OSXFile.createSidebarImage(im, selectedColor);
        return new ListStateIcon(new ImageIcon(basic), new ImageIcon(selected));
    }

    protected static Image createSidebarImage(Image source, Color color) {
        if (source instanceof AquaMultiResolutionImage) {
            AquaMultiResolutionImage im = (AquaMultiResolutionImage)source;
            SidebarImageMapper mapper = new SidebarImageMapper(color);
            return im.map(mapper);
        }
        BufferedImage img = Images.toBufferedImage(source);
        return OSXFile.basicCreateSidebarImage(img, color);
    }

    protected static BufferedImage basicCreateSidebarImage(BufferedImage img, Color color) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage iconImg = new BufferedImage(width, height, 3);
        Graphics2D g = iconImg.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)img, 0, 0, null);
        g.setComposite(AlphaComposite.SrcIn);
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return iconImg;
    }

    private static RecyclableFileIcon createIcon(String name) {
        String prefix = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/";
        return new RecyclableFileIcon(prefix + name + ".icns");
    }

    private static RecyclableSidebarIcon createSidebarIcon(String name) {
        String prefix = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/Sidebar";
        RecyclableSidebarIcon icon = new RecyclableSidebarIcon(prefix + name + ".icns");
        return icon;
    }

    public static Icon getAliasBadgeIcon() {
        return aliasBadgeIcon.getInstance();
    }

    public static Icon getDirectoryIcon() {
        return directoryIcon.getInstance();
    }

    public static Image getDirectoryIconImage(int size) {
        return directoryIcon.asImage(size);
    }

    public static Icon getFileIcon() {
        return fileIcon.getInstance();
    }

    public static Image getFileIconImage(int size) {
        return fileIcon.asImage(size);
    }

    public static Icon getGenericComputerIcon() {
        return genericComputerIcon.getInstance();
    }

    public static Icon getNetworkIcon() {
        return networkIcon.getInstance();
    }

    public static Icon getAirDropSidebarIcon() {
        return airDropSidebarIcon.getInstance();
    }

    public static Icon getAllMyFilesSidebarIcon() {
        return allMyFilesSidebarIcon.getInstance();
    }

    public static Icon getApplicationsSidebarIcon() {
        return applicationsSidebarIcon.getInstance();
    }

    public static Icon getDesktopSidebarIcon() {
        return desktopSidebarIcon.getInstance();
    }

    public static Icon getDocumentsSidebarIcon() {
        return documentsSidebarIcon.getInstance();
    }

    public static Icon getDownloadsSidebarIcon() {
        return downloadsSidebarIcon.getInstance();
    }

    public static Icon getDropboxSidebarIcon() {
        return dropboxSidebarIcon.getInstance();
    }

    public static Icon getGenericFileSidebarIcon() {
        return genericFileSidebarIcon.getInstance();
    }

    public static Icon getGenericFolderSidebarIcon() {
        return genericFolderSidebarIcon.getInstance();
    }

    public static Icon getGenericVolumeSidebarIcon() {
        return genericVolumeSidebarIcon.getInstance();
    }

    public static Icon getHomeSidebarIcon() {
        return homeSidebarIcon.getInstance();
    }

    public static Icon getMoviesSidebarIcon() {
        return moviesSidebarIcon.getInstance();
    }

    public static Icon getMusicSidebarIcon() {
        return musicSidebarIcon.getInstance();
    }

    public static Icon getNetworkSidebarIcon() {
        return networkSidebarIcon.getInstance();
    }

    public static Icon getPicturesSidebarIcon() {
        return picturesSidebarIcon.getInstance();
    }

    public static Icon getSmartFolderSidebarIcon() {
        return smartFolderSidebarIcon.getInstance();
    }

    public static Icon getTimeMachineSidebarIcon() {
        return timeMachineSidebarIcon.getInstance();
    }

    public static Icon getUtilitiesSidebarIcon() {
        return utilitiesSidebarIcon.getInstance();
    }

    public static Icon getiMacSidebarIcon() {
        return iMacSidebarIcon.getInstance();
    }

    public static Icon getMacMiniSidebarIcon() {
        return macMiniSidebarIcon.getInstance();
    }

    public static Icon getMacProSidebarIcon() {
        return macProSidebarIcon.getInstance();
    }

    public static Icon getMacProCylinderSidebarIcon() {
        return macProCylinderSidebarIcon.getInstance();
    }

    public static Icon getLaptopSidebarIcon() {
        return laptopSidebarIcon.getInstance();
    }

    public static Icon getPCSidebarIcon() {
        return pcSidebarIcon.getInstance();
    }

    private static boolean isNativeCodeAvailable() {
        return AquaNativeSupport.load();
    }

    private OSXFile() {
    }

    public static File getAbsoluteFile(File f) {
        if (!f.isAbsolute()) {
            f = new File(AquaUtils.getProperty("user.home") + File.separatorChar + f.getPath());
        }
        if (File.separatorChar == '\\') {
            return f;
        }
        StringBuffer buf = new StringBuffer(f.getPath().length());
        int skip = 0;
        for (File i = f; i != null; i = i.getParentFile()) {
            String name = i.getName();
            if (name.equals(".")) {
                if (skip <= 0) continue;
                --skip;
                continue;
            }
            if (name.equals("..")) {
                ++skip;
                continue;
            }
            if (skip > 0) {
                --skip;
                continue;
            }
            buf.insert(0, name);
            buf.insert(0, File.separatorChar);
        }
        return f.getPath().equals(buf.toString()) ? f : new File(buf.toString());
    }

    public static boolean isAvailable() {
        return OSXFile.isNativeCodeAvailable();
    }

    public static int getFileType(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(f.getAbsolutePath());
            if ((flags & 0x10) != 0) {
                if (f.getParent().equals("/Volumes")) {
                    return 1;
                }
                return 2;
            }
            if ((flags & 8) != 0) {
                return 1;
            }
            if ((flags & 1) != 0) {
                return 0;
            }
            return -1;
        }
        return f.isDirectory() ? 1 : (f.isFile() ? 0 : -1);
    }

    public static File resolvePath(String path, File currentDirectory) {
        if (path.startsWith("/")) {
            return new File(path);
        }
        if (path.startsWith("~")) {
            if ((path = path.substring(1)).startsWith("/")) {
                String home = System.getProperty("user.home");
                return new File(home + path);
            }
            if (path.isEmpty()) {
                String home = System.getProperty("user.home");
                return new File(home);
            }
            return new File("/Users/" + path);
        }
        if (currentDirectory == null) {
            String home = System.getProperty("user.home");
            currentDirectory = new File(home);
        }
        return new File(currentDirectory, path);
    }

    public static File resolve(File f) {
        return OSXFile.resolveAlias(f, true);
    }

    public static File resolveAlias(File f, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            String path = OSXFile.nativeResolveAlias(f.getAbsolutePath(), noUI);
            if (path == null) {
                return null;
            }
            f = new File(path);
            if (OSXFile.getFileType(f) != 2) {
                return f;
            }
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f;
        }
    }

    public static File resolveAlias(byte[] serializedAlias, boolean noUI) {
        if (OSXFile.isNativeCodeAvailable()) {
            String path = OSXFile.nativeResolveAlias(serializedAlias, noUI);
            return path == null ? null : new File(path);
        }
        return null;
    }

    public static int getLabel(File f) {
        if (OSXFile.isNativeCodeAvailable() && f != null) {
            return OSXFile.nativeGetLabel(f.getAbsolutePath());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Color getLabelColor(int label, int type) {
        if (labelColors == null) {
            Class<OSXFile> clazz = OSXFile.class;
            // MONITORENTER : org.violetlib.aqua.fc.OSXFile.class
            if (labelColors == null) {
                labelColors = new Color[][]{{null, null, null, null}, {new Color(0xB7B7B7), new Color(0xD8D8D8), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12704094), new Color(14609324), new Color(15529422), new Color(16120550)}, {new Color(13345759), new Color(15191534), new Color(15786742), new Color(16249082)}, {new Color(7190013), new Color(12114942), new Color(13756671), new Color(15332607)}, {new Color(15916384), new Color(16511660), new Color(16578254), new Color(16710886)}, {new Color(16480880), new Color(16561325), new Color(16766675), new Color(16771302)}, {new Color(16234075), new Color(16504484), new Color(16705996), new Color(0xFFF3E3)}};
            }
            // MONITOREXIT : clazz
        }
        if (label == -1) {
            return null;
        }
        Color color = labelColors[label][type];
        return color;
    }

    public static Image getIconImage(File file, int size, boolean useQuickLook) throws UnsupportedOperationException {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            FileIconCreator c = new FileIconCreator(file, size, useQuickLook, true);
            return c.getImage();
        }
        throw new UnsupportedOperationException();
    }

    public static Image getThumbnailImage(File file, int size) throws UnsupportedOperationException {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            FileIconCreator c = new FileIconCreator(file, size, true, false);
            return c.getImage();
        }
        throw new UnsupportedOperationException();
    }

    public static String getKindString(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            return OSXFile.nativeGetKindString(file.getAbsolutePath());
        }
        return null;
    }

    public static boolean isVirtualFile(File file) {
        if (OSXFile.isNativeCodeAvailable() && file != null) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            return (flags & 2) != 0;
        }
        return false;
    }

    public static boolean isInvisible(File file) {
        if (file != null) {
            if (OSXFile.isNativeCodeAvailable()) {
                int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
                return (flags & 0x40) != 0;
            }
            return file.isHidden();
        }
        return false;
    }

    public static boolean isTraversable(File file) {
        return OSXFile.isTraversable(file, false, false);
    }

    public static boolean isTraversable(File file, boolean isPackageTraversable, boolean isApplicationTraversable) {
        if (file == null) {
            return false;
        }
        if (OSXFile.isNativeCodeAvailable()) {
            int flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            if ((flags & 0x10) != 0) {
                file = OSXFile.resolve(file);
                flags = OSXFile.nativeGetBasicItemInfoFlags(file.getAbsolutePath());
            }
            if ((flags & 9) == 8) {
                boolean isApplication;
                boolean isPackage = (flags & 2) != 0;
                boolean bl = isApplication = (flags & 4) != 0;
                if (isApplication) {
                    return isApplicationTraversable;
                }
                if (isPackage) {
                    return isPackageTraversable;
                }
                return OSXFile.basicIsTraversable(file);
            }
            if ((flags & 1) != 0) {
                return OSXFile.basicIsTraversable(file);
            }
            return OSXFile.isVolumes(file.getParent());
        }
        return OSXFile.basicIsTraversable(file);
    }

    private static boolean isVolumes(String s) {
        return s != null && s.equals("/Volumes");
    }

    private static boolean basicIsTraversable(File f) {
        String name = f.getName();
        if (f.isDirectory()) {
            for (String s : nonTraversableDirectories) {
                if (!s.equals(name)) continue;
                return false;
            }
            return true;
        }
        return OSXFile.isSavedSearch(f);
    }

    public static boolean isSavedSearch(File f) {
        return f.getName().endsWith(".savedSearch");
    }

    public static Icon getSidebarComputerIcon() {
        if (computerSidebarIcon == null) {
            String model = OSXFile.getComputerModel();
            if (model != null) {
                if (model.startsWith("MacBook")) {
                    computerSidebarIcon = OSXFile.getLaptopSidebarIcon();
                } else if (model.startsWith("MacPro")) {
                    computerSidebarIcon = OSXFile.getMacProSidebarIcon();
                } else if (model.startsWith("Macmini")) {
                    computerSidebarIcon = OSXFile.getMacMiniSidebarIcon();
                }
            }
            if (computerSidebarIcon == null) {
                computerSidebarIcon = OSXFile.getiMacSidebarIcon();
            }
        }
        return computerSidebarIcon;
    }

    private static String getComputerModel() {
        if (!computerModelInitialized) {
            computerModelInitialized = true;
            String[] cmd = new String[]{"/usr/sbin/sysctl", "hw.model"};
            Charset cs = Charset.forName("UTF-8");
            String result = OSXFile.exec(cmd, cs);
            if (result != null) {
                int pos = result.indexOf(":");
                computerModel = result.substring(pos + 1).trim();
            }
        }
        return computerModel;
    }

    private static native int nativeGetFileType(String var0);

    private static native String nativeResolveAlias(String var0, boolean var1);

    private static native String nativeResolveAlias(byte[] var0, boolean var1);

    private static native int nativeGetLabel(String var0);

    private static native String nativeGetKindString(String var0);

    private static native int nativeGetBasicItemInfoFlags(String var0);

    public static String getComputerName() {
        if (!haveFetchedComputerName) {
            haveFetchedComputerName = true;
            String[] cmd = new String[]{"/usr/sbin/scutil", "--get", "ComputerName"};
            Charset cs = Charset.forName("UTF-8");
            String s = OSXFile.exec(cmd, cs);
            computerName = s != null ? s.trim() : null;
        }
        return computerName;
    }

    public static String getDisplayName(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            return OSXFile.nativeGetDisplayName(f.getAbsolutePath());
        }
        return f.getName();
    }

    public static Date getLastUsedDate(File f) {
        if (OSXFile.isNativeCodeAvailable()) {
            long t = OSXFile.nativeGetLastUsedDate(f.getAbsolutePath());
            return t > 0L ? new Date(t) : null;
        }
        return null;
    }

    public static File[] executedSavedSearch(File savedSearchFile) {
        String savedSearchPath = savedSearchFile.getAbsolutePath();
        String[] paths = OSXFile.nativeExecuteSavedSearch(savedSearchPath);
        if (paths != null) {
            int count = paths.length;
            File[] files = new File[count];
            for (int i = 0; i < count; ++i) {
                files[i] = new File(paths[i]);
            }
            return files;
        }
        return null;
    }

    public static List<SystemItemInfo> getSidebarFiles(int which) {
        return sharedFileLists[which].getResults();
    }

    public static String exec(String[] cmd, Charset cs) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            InputStream stdout = p.getInputStream();
            InputStreamReader standardOutputReader = new InputStreamReader(stdout, cs);
            StreamCollector standardOutputCollector = new StreamCollector(standardOutputReader);
            standardOutputCollector.start();
            int rc = p.waitFor();
            standardOutputCollector.join();
            return standardOutputCollector.getContents();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static native String nativeGetDisplayName(String var0);

    private static native long nativeGetLastUsedDate(String var0);

    private static native String[] nativeExecuteSavedSearch(String var0);

    private static native Object[] nativeGetSidebarFiles(int var0, int var1, int var2);

    private static native boolean nativeRenderFileImage(String var0, boolean var1, boolean var2, int[][] var3, int var4, int var5);

    static {
        aliasBadgeIcon = OSXFile.createIcon("AliasBadgeIcon");
        genericComputerIcon = OSXFile.createIcon("public.generic-pc");
        directoryIcon = OSXFile.createIcon("GenericFolderIcon");
        fileIcon = OSXFile.createIcon("GenericDocumentIcon");
        networkIcon = OSXFile.createIcon("GenericNetworkIcon");
        applicationsSidebarIcon = OSXFile.createSidebarIcon("ApplicationsFolder");
        desktopSidebarIcon = OSXFile.createSidebarIcon("DesktopFolder");
        documentsSidebarIcon = OSXFile.createSidebarIcon("DocumentsFolder");
        downloadsSidebarIcon = OSXFile.createSidebarIcon("DownloadsFolder");
        dropboxSidebarIcon = OSXFile.createSidebarIcon("DropBoxFolder");
        genericFileSidebarIcon = OSXFile.createSidebarIcon("GenericFile");
        genericFolderSidebarIcon = OSXFile.createSidebarIcon("GenericFolder");
        genericVolumeSidebarIcon = OSXFile.createSidebarIcon("InternalDisk");
        homeSidebarIcon = OSXFile.createSidebarIcon("HomeFolder");
        moviesSidebarIcon = OSXFile.createSidebarIcon("MoviesFolder");
        musicSidebarIcon = OSXFile.createSidebarIcon("MusicFolder");
        networkSidebarIcon = OSXFile.createSidebarIcon("Network");
        picturesSidebarIcon = OSXFile.createSidebarIcon("PicturesFolder");
        smartFolderSidebarIcon = OSXFile.createSidebarIcon("SmartFolder");
        timeMachineSidebarIcon = OSXFile.createSidebarIcon("TimeMachine");
        utilitiesSidebarIcon = OSXFile.createSidebarIcon("UtilitiesFolder");
        iMacSidebarIcon = OSXFile.createSidebarIcon("iMac");
        macMiniSidebarIcon = OSXFile.createSidebarIcon("MacMini");
        macProSidebarIcon = OSXFile.createSidebarIcon("MacPro");
        macProCylinderSidebarIcon = OSXFile.createSidebarIcon("MacProCylinder");
        pcSidebarIcon = OSXFile.createSidebarIcon("PC");
        laptopSidebarIcon = OSXFile.createSidebarIcon("Laptop");
        airDropSidebarIcon = OSXFile.createSidebarIcon("AirDrop");
        allMyFilesSidebarIcon = OSXFile.createSidebarIcon("AllMyFiles");
        nonTraversableDirectories = new String[]{".Spotlight-V100", ".DocumentRevisions", ".Trashes"};
        sharedFileLists = new SharedFileList[]{new SharedFileList(0, "Sidebar Favorites"), new SharedFileList(1, "Sidebar Volumes")};
    }

    private static class StreamCollector
    extends Thread {
        private BufferedReader br;
        private String result;

        public StreamCollector(Reader r) {
            this.br = new BufferedReader(r);
        }

        public synchronized String getContents() {
            return this.result;
        }

        private synchronized void setContents(String s) {
            this.result = s;
            this.notifyAll();
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[1000];
            block4: while (true) {
                try {
                    int count;
                    while ((count = this.br.read(buffer, 0, buffer.length)) >= 0) {
                        if (count > 0) {
                            sb.append(buffer, 0, count);
                            continue;
                        }
                        try {
                            Thread.sleep(200L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException count) {
                    // empty catch block
                    break;
                }
            }
            String s = sb.toString();
            this.setContents(s);
        }
    }

    private static class SharedFileList {
        private String name;
        private int which;
        private int lastSeed = -1;
        private List<SystemItemInfo> lastResults;

        public SharedFileList(int which, String name) {
            this.which = which;
            this.name = name;
        }

        public List<SystemItemInfo> getResults() {
            int imageSize = 18;
            Object[] data = OSXFile.nativeGetSidebarFiles(this.which, 18, this.lastSeed);
            if (data == null) {
                return this.lastResults;
            }
            this.lastSeed = (Integer)data[0];
            int sequence = 0;
            ArrayList<SystemItemInfo> result = new ArrayList<SystemItemInfo>();
            for (int i = 1; i < data.length; i += 6) {
                String name = (String)data[i];
                if (name == null) continue;
                Integer id = (Integer)data[i + 1];
                Integer flags = (Integer)data[i + 2];
                String path = (String)data[i + 3];
                int[] iconData1x = (int[])data[i + 4];
                int[] iconData2x = (int[])data[i + 5];
                SystemItemInfo info = new SystemItemInfo();
                info.name = name;
                info.path = path;
                info.sequenceNumber = sequence++;
                info.isVisible = flags == 0;
                info.id = id;
                if (iconData1x != null) {
                    info.icon = OSXFile.createSidebarIcon(AquaMultiResolutionImage.createImage(imageSize, imageSize, iconData1x, iconData2x));
                }
                result.add(info);
            }
            this.lastResults = result;
            return result;
        }
    }

    public static class SystemItemInfo {
        public String name;
        public String path;
        int sequenceNumber;
        boolean isVisible;
        int id;
        Icon icon;

        public String toString() {
            String s = this.sequenceNumber + ": " + this.name;
            s = this.path != null ? s + " " + this.path : s + " (unresolved)";
            s = s + " " + this.id;
            if (!this.isVisible) {
                s = s + " (hidden)";
            }
            return s;
        }
    }

    private static class FileIconCreator {
        private final File file;
        private final int size;
        private final boolean useQuickLook;
        private final boolean useIconMode;
        private Image result;

        public FileIconCreator(File file, int size, boolean useQuickLook, boolean useIconMode) {
            this.file = file;
            this.size = size;
            this.useQuickLook = useQuickLook;
            this.useIconMode = useIconMode;
        }

        public Image getImage() {
            if (this.result == null) {
                int[][] buffers;
                String path = this.file.getAbsolutePath();
                if (!OSXFile.nativeRenderFileImage(path, this.useQuickLook, this.useIconMode, buffers = new int[2][], this.size, this.size)) {
                    if (AquaImageFactory.debugNativeRendering) {
                        System.err.println("Failed to render image for " + path);
                    }
                    throw new UnsupportedOperationException();
                }
                if (AquaImageFactory.debugNativeRendering) {
                    System.err.println("Rendered image for " + path);
                }
                this.result = AquaMultiResolutionImage.createImage(this.size, this.size, buffers[0], buffers[1]);
            }
            return this.result;
        }
    }

    private static class SidebarImageMapper
    implements AquaMultiResolutionImage.Mapper {
        private final Color color;

        public SidebarImageMapper(Color color) {
            this.color = color;
        }

        @Override
        public BufferedImage map(Image source, int scaleFactor) {
            BufferedImage img = Images.toBufferedImage(source);
            return OSXFile.basicCreateSidebarImage(img, this.color);
        }
    }

    private static class RecyclableSidebarIcon
    extends AquaUtils.RecyclableSingleton<Icon> {
        final File file;

        public RecyclableSidebarIcon(File file) {
            this.file = file;
        }

        public RecyclableSidebarIcon(String path) {
            this.file = new File(path);
        }

        @Override
        protected Icon getInstance() {
            Image im = AquaImageFactory.getImage(this.file, 18);
            return OSXFile.createSidebarIcon(im);
        }
    }

    private static class RecyclableFileIcon
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final File file;

        public RecyclableFileIcon(File file) {
            this.file = file;
        }

        public RecyclableFileIcon(String path) {
            this.file = new File(path);
        }

        @Override
        protected IconUIResource getInstance() {
            Image im = AquaImageFactory.getImage(this.file, 16);
            return new IconUIResource(new ImageIcon(im));
        }

        public Image asImage(int size) {
            return AquaImageFactory.getImage(this.file, size);
        }
    }
}

