/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;

public class SavedSearchFileSystemTreeModel
extends FileSystemTreeModel {
    private File savedSearchFile;

    public SavedSearchFileSystemTreeModel(JFileChooser fc, File savedSearchFile) {
        super(fc);
        this.savedSearchFile = savedSearchFile;
        this.root = new SavedSearchNode(savedSearchFile, false);
    }

    @Override
    public TreePath toPath(File file, TreePath templatePath) {
        if (this.savedSearchFile.equals(file)) {
            return new TreePath(this.getRoot());
        }
        return this.searchForFile(this.root, file);
    }

    private TreePath searchForFile(FileSystemTreeModel.Node node, File f) {
        File nf = node.getResolvedFile();
        if (nf != null) {
            if (f.equals(nf)) {
                return new TreePath(node.getPath());
            }
            int count = node.getChildCount();
            for (int index = 0; index < count; ++index) {
                TreePath path;
                FileSystemTreeModel.Node child = (FileSystemTreeModel.Node)node.getChildAt(index);
                if (child == null || (path = this.searchForFile(child, f)) == null) continue;
                return path;
            }
        }
        return null;
    }

    public class SavedSearchNode
    extends FileSystemTreeModel.DirectoryNode {
        public SavedSearchNode(File savedSearchFile, boolean isHidden) {
            super(savedSearchFile, isHidden);
            this.setTraversable(true);
        }

        @Override
        public String getFileKind() {
            return "Saved Search";
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        protected File[] getFiles() {
            File savedSearchFile = this.getFile();
            File[] files = OSXFile.executedSavedSearch(savedSearchFile);
            return files;
        }
    }
}

