/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SequentialDispatcher;
import org.violetlib.aqua.fc.SidebarTreeFileNode;
import org.violetlib.aqua.fc.Worker;

public class SidebarTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    private TreePath volumesPath;
    private FileSystemTreeModel model;
    private DefaultMutableTreeNode devicesNode;
    private DefaultMutableTreeNode favoritesNode;
    private FileSystemTreeModel.Node computerNode;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private static final File[] defaultUserItems = new File[]{new File(AquaUtils.getProperty("user.home"), "Desktop"), new File(AquaUtils.getProperty("user.home"), "Documents"), new File(AquaUtils.getProperty("user.home"))};

    public SidebarTreeModel(JFileChooser fileChooser, TreePath volumesPath, FileSystemTreeModel model) {
        super(new DefaultMutableTreeNode(), true);
        this.fileChooser = fileChooser;
        this.volumesPath = volumesPath;
        this.model = model;
        this.computerNode = model.getRoot();
        this.devicesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.devices"));
        this.devicesNode.setAllowsChildren(true);
        this.favoritesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.favorites"));
        this.favoritesNode.setAllowsChildren(true);
        DefaultMutableTreeNode r = (DefaultMutableTreeNode)this.getRoot();
        r.add(this.favoritesNode);
        r.add(this.devicesNode);
        this.updateUserNode();
        this.updateDevicesNode();
        model.addTreeModelListener(this);
    }

    public void lazyValidate() {
    }

    public void invokeWhenValid(Runnable r) {
        r.run();
    }

    private void updateUserNode() {
        List<Node> favorites = this.getUserFavorites();
        this.replaceNodes(this.favoritesNode, favorites, false);
    }

    private void updateDevicesNode() {
        Map<String, OSXFile.SystemItemInfo> volumes = this.readVolumes();
        boolean[] someNodesUpdatedState = new boolean[1];
        ArrayList<SidebarViewToModelNode> devices = new ArrayList<SidebarViewToModelNode>();
        FileSystemTreeModel.Node computerNode = this.computerNode;
        OSXFile.SystemItemInfo computerInfo = volumes.get("Computer");
        if (computerInfo != null && computerInfo.isVisible) {
            devices.add(this.createOrFindDeviceNode(computerNode, -2, computerInfo.icon, someNodesUpdatedState));
        }
        for (OSXFile.SystemItemInfo info : volumes.values()) {
            File f;
            SidebarViewToModelNode node;
            String path;
            if (info == computerInfo || (path = info.path) == null || devices.contains(node = this.createOrFindDeviceNode(f = new File(path), info.sequenceNumber, info.icon, someNodesUpdatedState))) continue;
            devices.add(node);
        }
        Collections.sort(devices, new SideBarViewToModelNodeComparator());
        this.replaceNodes(this.devicesNode, devices, someNodesUpdatedState[0]);
    }

    private SidebarViewToModelNode createOrFindDeviceNode(File f, int sequenceNumber, Icon icon, boolean[] updatedState) {
        TreePath tp = this.model.toPath(f, null);
        FileSystemTreeModel.Node modelNode = (FileSystemTreeModel.Node)tp.getLastPathComponent();
        return this.createOrFindDeviceNode(modelNode, sequenceNumber, icon, updatedState);
    }

    private SidebarViewToModelNode createOrFindDeviceNode(FileSystemTreeModel.Node modelNode, int sequenceNumber, Icon icon, boolean[] updatedState) {
        int count = this.devicesNode.getChildCount();
        for (int index = 0; index < count; ++index) {
            SidebarViewToModelNode n;
            TreeNode node = this.devicesNode.getChildAt(index);
            if (!(node instanceof SidebarViewToModelNode) || (n = (SidebarViewToModelNode)node).getTarget() != modelNode) continue;
            if (!Objects.equals(n.icon, icon)) {
                updatedState[0] = true;
            }
            n.sequenceNumber = sequenceNumber;
            n.icon = icon;
            return n;
        }
        return new SidebarViewToModelNode(modelNode, sequenceNumber, icon);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceNodes(DefaultMutableTreeNode parent, List<? extends DefaultMutableTreeNode> nodes, boolean someNodesPossiblyUpdated) {
        ArrayList<DefaultMutableTreeNode> removedNodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> insertedNodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> changedNodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<Integer> removedIndexes = new ArrayList<Integer>();
        ArrayList<Integer> insertedIndexes = new ArrayList<Integer>();
        ArrayList<Integer> changedIndexes = new ArrayList<Integer>();
        int oldCount = parent.getChildCount();
        for (int index = 0; index < oldCount; ++index) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(index);
            if (!nodes.contains(node)) {
                removedNodes.add(node);
                removedIndexes.add(index);
                continue;
            }
            changedNodes.add(node);
            changedIndexes.add(nodes.indexOf(node));
        }
        int newCount = nodes.size();
        for (int index = 0; index < newCount; ++index) {
            DefaultMutableTreeNode defaultMutableTreeNode = nodes.get(index);
            if (defaultMutableTreeNode == null || changedNodes.contains(defaultMutableTreeNode)) continue;
            insertedNodes.add(defaultMutableTreeNode);
            insertedIndexes.add(index);
        }
        if (!removedNodes.isEmpty() || !insertedNodes.isEmpty()) {
            parent.removeAllChildren();
            for (DefaultMutableTreeNode defaultMutableTreeNode : nodes) {
                parent.add(defaultMutableTreeNode);
            }
        }
        if (!removedNodes.isEmpty()) {
            void var13_22;
            int[] indexes = new int[removedNodes.size()];
            boolean bl = false;
            while (var13_22 < indexes.length) {
                indexes[var13_22] = (Integer)removedIndexes.get((int)var13_22);
                ++var13_22;
            }
            Object[] objectArray = removedNodes.toArray();
            this.fireTreeNodesRemoved(this, parent.getPath(), indexes, objectArray);
        }
        if (!insertedNodes.isEmpty()) {
            void var13_26;
            int[] indexes = new int[insertedNodes.size()];
            boolean bl = false;
            while (var13_26 < indexes.length) {
                indexes[var13_26] = (Integer)insertedIndexes.get((int)var13_26);
                ++var13_26;
            }
            Object[] objectArray = insertedNodes.toArray();
            this.fireTreeNodesInserted(this, parent.getPath(), indexes, objectArray);
        }
        if (someNodesPossiblyUpdated && !changedNodes.isEmpty()) {
            void var13_30;
            int[] indexes = new int[changedNodes.size()];
            boolean bl = false;
            while (var13_30 < indexes.length) {
                indexes[var13_30] = (Integer)changedIndexes.get((int)var13_30);
                ++var13_30;
            }
            Object[] objectArray = changedNodes.toArray();
            this.fireTreeNodesChanged(this, parent.getPath(), indexes, objectArray);
        }
    }

    private List<Node> getUserFavorites() {
        ArrayList<Node> result = new ArrayList<Node>();
        List<OSXFile.SystemItemInfo> sidebarFavorites = OSXFile.getSidebarFiles(0);
        if (sidebarFavorites != null) {
            for (OSXFile.SystemItemInfo favorite : sidebarFavorites) {
                boolean isPath;
                String name = favorite.name;
                String path = favorite.path;
                boolean bl = isPath = path != null && !path.isEmpty();
                if (!isPath && (name.equals("AirDrop") || name.endsWith("-AirDrop")) || name.equals("iCloud") || name.equals("All My Files")) continue;
                if (favorite.path != null) {
                    File f = new File(path);
                    FileNode node = new FileNode(f);
                    Icon icon = favorite.icon;
                    if (icon != null) {
                        node.icon = icon;
                    }
                    result.add(node);
                    continue;
                }
                AliasNode node = new AliasNode(name);
                result.add(node);
            }
        }
        return result;
    }

    private Map<String, OSXFile.SystemItemInfo> readVolumes() {
        HashMap<String, OSXFile.SystemItemInfo> result = new HashMap<String, OSXFile.SystemItemInfo>();
        List<OSXFile.SystemItemInfo> sidebarVolumes = OSXFile.getSidebarFiles(1);
        if (sidebarVolumes != null) {
            for (OSXFile.SystemItemInfo volume : sidebarVolumes) {
                String name = volume.name;
                if (volume.id == 1) {
                    name = "Computer";
                }
                result.put(name, volume);
            }
        }
        return result;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    private class SideBarViewToModelNodeComparator
    implements Comparator<SidebarViewToModelNode> {
        private SideBarViewToModelNodeComparator() {
        }

        @Override
        public int compare(SidebarViewToModelNode n1, SidebarViewToModelNode n2) {
            return n1.getSequenceNumber() - n2.getSequenceNumber();
        }
    }

    private class SidebarViewToModelNode
    extends Node {
        private FileSystemTreeModel.Node target;
        private int sequenceNumber;
        private Icon icon;

        public SidebarViewToModelNode(FileSystemTreeModel.Node target, int sequenceNumber, Icon icon) {
            this.target = target;
            this.sequenceNumber = sequenceNumber;
            this.icon = icon;
        }

        @Override
        public File getResolvedFile() {
            return this.target.getResolvedFile();
        }

        @Override
        public String getUserName() {
            return this.target.getUserName();
        }

        @Override
        public Icon getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            return this.target.getIcon();
        }

        public FileSystemTreeModel.Node getTarget() {
            return this.target;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public String toString() {
            return this.target.toString();
        }
    }

    private class AliasNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private String aliasName;
        private boolean isTraversable;
        protected int fileLabel;

        public AliasNode(String aliasName) {
            this.fileLabel = -1;
            this.file = null;
            this.aliasName = aliasName;
            this.isTraversable = true;
        }

        @Override
        public File getResolvedFile() {
            if (this.file == null) {
                this.icon = null;
                this.file = OSXFile.resolveAlias(new File(this.aliasName), false);
            }
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (this.file != null && !UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(AliasNode.this.file);
                        }

                        @Override
                        public void done(Icon value) {
                            AliasNode.this.icon = value;
                            int[] changedIndices = new int[]{AliasNode.this.getParent().getIndex(AliasNode.this)};
                            Object[] changedChildren = new Object[]{AliasNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, ((DefaultMutableTreeNode)AliasNode.this.getParent()).getPath(), changedIndices, changedChildren);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null && this.file != null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName == null ? this.aliasName : this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }

    private abstract class Node
    extends DefaultMutableTreeNode
    implements SidebarTreeFileNode {
        private Node() {
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }
    }

    private class FileNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private boolean isTraversable;
        protected int fileLabel = -1;

        public FileNode(File file) {
            this.file = file;
            this.isTraversable = file.isDirectory();
        }

        @Override
        public File getResolvedFile() {
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (!UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(FileNode.this.file);
                        }

                        @Override
                        public void done(Icon value) {
                            FileNode.this.icon = value;
                            int[] changedIndices = new int[]{FileNode.this.getParent().getIndex(FileNode.this)};
                            Object[] changedChildren = new Object[]{FileNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, SidebarTreeModel.this.favoritesNode.getPath(), changedIndices, changedChildren);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }
}

