/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.geom.ExpandableOutline;

public final class ExpandableRectangleOutline
extends ExpandableOutline {
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public ExpandableRectangleOutline(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ExpandableRectangleOutline(@NotNull Rectangle2D source) {
        this.x = source.getX();
        this.y = source.getY();
        this.width = source.getWidth();
        this.height = source.getHeight();
    }

    @Override
    @NotNull
    public Shape getShape(float offset) {
        double nx = this.x - (double)offset;
        double ny = this.y - (double)offset;
        double nwidth = this.width + (double)(2.0f * offset);
        double nheight = this.height + (double)(2.0f * offset);
        return new Rectangle2D.Double(nx, ny, nwidth, nheight);
    }
}

