/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.HybridAquaUIPainter;
import org.violetlib.jnr.aqua.impl.NativeSupport;

public class AquaNativeRendering {
    private static boolean isInitialized;
    @Nullable
    private static AquaUIPainter preferredPainter;

    @NotNull
    public static AquaUIPainter createPainter() throws UnsupportedOperationException {
        if (!isInitialized) {
            AquaNativeRendering.findPainterClasses();
        }
        if (preferredPainter != null) {
            return preferredPainter.copy();
        }
        throw new UnsupportedOperationException("Unable to create a native painter");
    }

    private AquaNativeRendering() {
    }

    @NotNull
    public static String getReleaseName() {
        return AquaNativeRendering.getStringResource("RELEASE.txt");
    }

    @NotNull
    public static String getBuildID() {
        return AquaNativeRendering.getStringResource("BUILD.txt");
    }

    @NotNull
    public static String getVersionString() {
        return "VAquaRendering: release " + AquaNativeRendering.getReleaseName() + " (build " + AquaNativeRendering.getBuildID() + ")";
    }

    public static void showVersion() {
        System.err.println("VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    @NotNull
    private static String getStringResource(@NotNull String name) {
        InputStream s = AquaNativeRendering.class.getResourceAsStream(name);
        if (s != null) {
            try {
                int ch;
                BufferedReader r = new BufferedReader(new InputStreamReader(s));
                StringBuilder sb = new StringBuilder();
                while ((ch = r.read()) >= 0) {
                    sb.append((char)ch);
                }
                return sb.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    private static synchronized void findPainterClasses() {
        Class c3;
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        AquaNativePainter viewPainter = null;
        AquaUIPainter coreUIPainter = null;
        AquaUIPainter jrsPainter = null;
        try {
            Class c2 = AquaNativeRendering.getClass("org.violetlib.jnr.aqua.impl.AugmentedAquaNativePainter");
            if (AquaNativePainter.class.isAssignableFrom(c2)) {
                viewPainter = (AquaNativePainter)c2.newInstance();
            }
        }
        catch (Exception c2) {
            // empty catch block
        }
        int jrsVersion = NativeSupport.getJavaRuntimeSupportMajorVersion();
        boolean useJRS = jrsVersion >= 15;
        try {
            c3 = AquaNativeRendering.getClass("org.violetlib.jnr.aqua.coreui.AugmentedCoreUIPainter");
            if (AquaUIPainter.class.isAssignableFrom(c3)) {
                Constructor cons = c3.getConstructor(Boolean.TYPE);
                coreUIPainter = (AquaUIPainter)cons.newInstance(useJRS);
            }
        }
        catch (Exception c3) {
            // empty catch block
        }
        if (useJRS) {
            try {
                c3 = AquaNativeRendering.getClass("org.violetlib.jnr.aqua.jrs.AugmentedJRSPainter");
                if (AquaUIPainter.class.isAssignableFrom(c3)) {
                    jrsPainter = (AquaUIPainter)c3.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        preferredPainter = viewPainter != null && coreUIPainter != null ? new HybridAquaUIPainter(viewPainter, coreUIPainter, jrsPainter) : (coreUIPainter != null ? coreUIPainter : (viewPainter != null ? viewPainter : jrsPainter));
    }

    @NotNull
    protected static Class getClass(@NotNull String name) throws ClassNotFoundException {
        ClassLoader loader = AquaNativeRendering.class.getClassLoader();
        return Class.forName(name, true, loader);
    }
}

