/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;

public class ButtonConfiguration
extends ButtonLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isFocused;
    @NotNull
    private final AquaUIPainter.ButtonState buttonState;

    public ButtonConfiguration(@NotNull AquaUIPainter.ButtonWidget bw, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean isFocused, @NotNull AquaUIPainter.ButtonState buttonState, @NotNull AquaUIPainter.UILayoutDirection ld) {
        super(bw, size, ld);
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL && buttonState != AquaUIPainter.ButtonState.OFF && state == AquaUIPainter.State.ACTIVE) {
            state = AquaUIPainter.State.PRESSED;
        }
        this.state = state;
        this.isFocused = isFocused;
        this.buttonState = buttonState;
    }

    public ButtonConfiguration(@NotNull ButtonLayoutConfiguration g, @NotNull AquaUIPainter.State state, boolean isFocused, @NotNull AquaUIPainter.ButtonState buttonState) {
        this(g.getButtonWidget(), g.getSize(), state, isFocused, buttonState, g.getLayoutDirection());
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @NotNull
    public AquaUIPainter.ButtonState getButtonState() {
        return this.buttonState;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ButtonConfiguration that = (ButtonConfiguration)o;
        return this.isFocused == that.isFocused && this.state == that.state && this.buttonState == that.buttonState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isFocused, this.buttonState});
    }

    @Override
    @NotNull
    public String toString() {
        String fs = this.isFocused ? " focused" : "";
        return super.toString() + " " + (Object)((Object)this.state) + " " + (Object)((Object)this.buttonState) + fs;
    }
}

