/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;

public class SegmentedButtonConfiguration
extends SegmentedButtonLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isSelected;
    private final boolean isFocused;
    @NotNull
    private final AquaUIPainter.Direction d;
    @NotNull
    private final DividerState leftDividerState;
    @NotNull
    private final DividerState rightDividerState;

    public SegmentedButtonConfiguration(@NotNull AquaUIPainter.SegmentedButtonWidget bw, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean isSelected, boolean isFocused, @NotNull AquaUIPainter.Direction d, @NotNull AquaUIPainter.Position position, @NotNull DividerState leftDividerState, @NotNull DividerState rightDividerState) {
        super(bw, size, position);
        this.state = state;
        this.isSelected = isSelected;
        this.isFocused = isFocused;
        this.d = d;
        this.leftDividerState = leftDividerState;
        this.rightDividerState = rightDividerState;
    }

    public SegmentedButtonConfiguration(@NotNull SegmentedButtonLayoutConfiguration g, @NotNull AquaUIPainter.State state, boolean isSelected, boolean isFocused, @NotNull AquaUIPainter.Direction d, @NotNull DividerState leftDividerState, @NotNull DividerState rightDividerState) {
        this(g.getWidget(), g.getSize(), state, isSelected, isFocused, d, g.getPosition(), leftDividerState, rightDividerState);
    }

    @NotNull
    public SegmentedButtonConfiguration withWidget(@NotNull AquaUIPainter.SegmentedButtonWidget widget) {
        return new SegmentedButtonConfiguration(widget, this.getSize(), this.state, this.isSelected, this.isFocused, this.d, this.getPosition(), this.leftDividerState, this.rightDividerState);
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @NotNull
    public AquaUIPainter.Direction getDirection() {
        return this.d;
    }

    @NotNull
    public DividerState getLeftDividerState() {
        return this.leftDividerState;
    }

    @NotNull
    public DividerState getRightDividerState() {
        return this.rightDividerState;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SegmentedButtonConfiguration that = (SegmentedButtonConfiguration)o;
        return this.state == that.state && this.isSelected == that.isSelected && this.isFocused == that.isFocused && this.d == that.d && this.leftDividerState == that.leftDividerState && this.rightDividerState == that.rightDividerState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isSelected, this.isFocused, this.d, this.leftDividerState, this.rightDividerState});
    }

    @Override
    @NotNull
    public String toString() {
        String ls;
        String ss;
        String fs = this.isFocused ? " focused" : "";
        String string = ss = this.isSelected ? "S" : "-";
        String string2 = this.leftDividerState == DividerState.NONE ? "" : (ls = this.leftDividerState == DividerState.ORDINARY ? "<" : "[");
        String rs = this.rightDividerState == DividerState.NONE ? "" : (this.rightDividerState == DividerState.ORDINARY ? ">" : "]");
        return super.toString() + " " + (Object)((Object)this.d) + " " + (Object)((Object)this.state) + fs + " " + ls + ss + rs;
    }

    public static enum DividerState {
        NONE,
        ORDINARY,
        SELECTED;

    }
}

