/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class SliderLayoutConfiguration
extends LayoutConfiguration {
    @NotNull
    private final AquaUIPainter.SliderWidget sw;
    @NotNull
    private final AquaUIPainter.Size size;
    private final int numberOfTickMarks;
    @NotNull
    private final AquaUIPainter.TickMarkPosition position;

    public SliderLayoutConfiguration(@NotNull AquaUIPainter.SliderWidget sw, @NotNull AquaUIPainter.Size size, int numberOfTickMarks, @NotNull AquaUIPainter.TickMarkPosition position) {
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            if (position == AquaUIPainter.TickMarkPosition.LEFT || position == AquaUIPainter.TickMarkPosition.RIGHT) {
                position = AquaUIPainter.TickMarkPosition.BELOW;
            }
        } else if (!(sw != AquaUIPainter.SliderWidget.SLIDER_VERTICAL && sw != AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN || position != AquaUIPainter.TickMarkPosition.ABOVE && position != AquaUIPainter.TickMarkPosition.BELOW)) {
            position = AquaUIPainter.TickMarkPosition.LEFT;
        }
        this.sw = sw;
        this.size = size;
        this.numberOfTickMarks = numberOfTickMarks;
        this.position = position;
    }

    protected SliderLayoutConfiguration(@NotNull SliderLayoutConfiguration g) {
        this.sw = g.getWidget();
        this.size = g.getSize();
        this.numberOfTickMarks = g.getNumberOfTickMarks();
        this.position = g.getTickMarkPosition();
    }

    @NotNull
    public AquaUIPainter.SliderWidget getWidget() {
        return this.sw;
    }

    @NotNull
    public AquaUIPainter.Size getSize() {
        return this.size;
    }

    public int getNumberOfTickMarks() {
        return this.numberOfTickMarks;
    }

    public boolean hasTickMarks() {
        return this.numberOfTickMarks > 0;
    }

    @NotNull
    public AquaUIPainter.TickMarkPosition getTickMarkPosition() {
        return this.position;
    }

    public boolean isVertical() {
        return this.sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL || this.sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN;
    }

    public boolean isHorizontal() {
        return this.sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || this.sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliderLayoutConfiguration that = (SliderLayoutConfiguration)o;
        return this.sw == that.sw && this.size == that.size && this.numberOfTickMarks == that.numberOfTickMarks && this.position == that.position;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sw, this.size, this.numberOfTickMarks, this.position});
    }

    @NotNull
    public String toString() {
        String ts = "";
        if (this.numberOfTickMarks > 0) {
            ts = " " + (Object)((Object)this.position);
        }
        return (Object)((Object)this.sw) + " " + (Object)((Object)this.size) + ts;
    }
}

