/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.coreui.ColorWellRenderer;
import org.violetlib.jnr.aqua.coreui.CoreUIPainter;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class AugmentedCoreUIPainter
extends CoreUIPainter {
    public AugmentedCoreUIPainter() {
    }

    public AugmentedCoreUIPainter(boolean useJRS) {
        super(useJRS);
    }

    @Override
    @NotNull
    public AugmentedCoreUIPainter copy() {
        return new AugmentedCoreUIPainter(this.useJRS);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration g) {
        Renderer r = super.getButtonRenderer(g);
        if (g.getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return new ColorWellRenderer(g, r);
        }
        return r;
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g) {
        Renderer r = super.getSegmentedButtonRenderer(g);
        if (this.isCustomSegmentedButtonRendererNeeded(g)) {
            return this.createCustomSegmentedButtonRenderer(g, r);
        }
        return r;
    }

    protected boolean isCustomSegmentedButtonRendererNeeded(@NotNull SegmentedButtonConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget w = g.getWidget();
        return w != AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE && (g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE || g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE);
    }

    @NotNull
    protected Renderer createCustomSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g, @NotNull Renderer r) {
        return new MySegmentedButtonRenderer(g, r);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        if (g.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension px = new ThinSplitPaneDividerPainterExtension(g);
            return Renderer.create(px);
        }
        return super.getSplitPaneDividerRenderer(g);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        TableColumnHeaderCellPainterExtension px = new TableColumnHeaderCellPainterExtension(g);
        return Renderer.create(px);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        Renderer r = super.getSliderRenderer(g);
        if (g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer pr = Renderer.create(new CircularSliderPainterExtension(g));
            return Renderer.createCompositeRenderer(r, pr);
        }
        return r;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration g) {
        if (g.getWidget() != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR && g.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(uiLayout, g));
        }
        return null;
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer r = super.getPopupArrowRenderer(g);
        if (this.isArrowNeeded(g)) {
            if (g.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(g));
            }
            return Renderer.create(new PullDownArrowPainter(g));
        }
        return r;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        return w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED;
    }

    protected class MySegmentedButtonRenderer
    extends Renderer {
        @NotNull
        private final SegmentedButtonConfiguration g;
        @NotNull
        private final Renderer r;

        public MySegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g, Renderer r) {
            this.g = g;
            this.r = r;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor compositor) {
            boolean isRightExtensionNeeded;
            boolean isLeftExtensionNeeded = this.g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
            boolean bl = isRightExtensionNeeded = this.g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE && compositor.getScaleFactor() > 1;
            if (!isLeftExtensionNeeded && !isRightExtensionNeeded) {
                this.r.composeTo(compositor);
            } else {
                int leftInset = isLeftExtensionNeeded ? 1 : 0;
                int rightInset = isRightExtensionNeeded ? 1 : 0;
                int w = compositor.getRasterWidth();
                int h = compositor.getRasterHeight();
                Renderer basic = Renderer.createRasterOffsetRenderer(this.r, leftInset, 0, w - leftInset - rightInset, h);
                basic.composeTo(compositor);
                SegmentedButtonConfiguration rg = new SegmentedButtonConfiguration(this.g.getWidget(), this.g.getSize(), this.g.getState(), this.g.isSelected(), this.g.isFocused(), this.g.getDirection(), AquaUIPainter.Position.MIDDLE, this.g.getRightDividerState(), this.g.getLeftDividerState());
                int sourceWidth = 100;
                Renderer unconfiguredSource = AugmentedCoreUIPainter.super.getSegmentedButtonRenderer(rg);
                ReusableCompositor source = new ReusableCompositor();
                source.reset(sourceWidth, h, compositor.getScaleFactor());
                unconfiguredSource.composeTo(source);
                if (leftInset > 0) {
                    compositor.composeFrom(source, sourceWidth - 1, 0, 0, 0, leftInset, h);
                }
                if (rightInset > 0) {
                    compositor.composeFrom(source, w - rightInset, 0, rightInset, h);
                }
            }
        }
    }
}

