/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.geom.Rectangle2D;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.coreui.CoreUIRendererDescriptions;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.LinearSliderRenderer;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.PopupRenderer;
import org.violetlib.jnr.aqua.impl.TitleBarRendererBase;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.FlipVerticalRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

public class CoreUIPainter
extends AquaUIPainterBase
implements AquaUIPainter {
    protected static boolean debugFlag = false;
    @NotNull
    protected static final CoreUIRendererDescriptions rendererDescriptions;
    protected boolean useJRS;

    public CoreUIPainter() {
        this(true);
    }

    public CoreUIPainter(boolean useJRS) {
        super(rendererDescriptions);
        this.useJRS = useJRS;
    }

    @Override
    @NotNull
    public CoreUIPainter copy() {
        return new CoreUIPainter();
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration g) {
        String widget;
        AquaUIPainter.ButtonWidget bw = this.toCanonicalButtonStyle(g.getButtonWidget());
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            if (g.getButtonState() != AquaUIPainter.ButtonState.ON) {
                return NULL_RENDERER;
            }
            ToolBarItemWellConfiguration tg = new ToolBarItemWellConfiguration(g.getState(), true);
            return this.getToolBarItemWellRenderer(tg);
        }
        RendererDescription rd = rendererDescriptions.getButtonRendererDescription(g);
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.ButtonState bs = g.getButtonState();
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        switch (bw) {
            case BUTTON_PUSH: {
                widget = "pushbutton";
                break;
            }
            case BUTTON_BEVEL: {
                widget = "bevelbutton";
                break;
            }
            case BUTTON_BEVEL_ROUND: {
                widget = "bevelbuttonround";
                break;
            }
            case BUTTON_CHECK_BOX: {
                widget = "checkbox";
                break;
            }
            case BUTTON_RADIO: {
                widget = "radiobutton";
                break;
            }
            case BUTTON_DISCLOSURE: {
                widget = "disclosurebutton";
                break;
            }
            case BUTTON_DISCLOSURE_TRIANGLE: {
                widget = "kCUIWidgetDisclosureTriangle";
                break;
            }
            case BUTTON_GRADIENT: {
                widget = "bevelbuttoninset";
                break;
            }
            case BUTTON_HELP: {
                widget = "kCUIWidgetButtonRoundHelp";
                break;
            }
            case BUTTON_RECESSED: {
                if (bs == AquaUIPainter.ButtonState.OFF && st != AquaUIPainter.State.ROLLOVER && st != AquaUIPainter.State.PRESSED) {
                    return NULL_RENDERER;
                }
                if (st == AquaUIPainter.State.ACTIVE_DEFAULT || st == AquaUIPainter.State.INACTIVE || st == AquaUIPainter.State.DISABLED || st == AquaUIPainter.State.DISABLED_INACTIVE) {
                    st = AquaUIPainter.State.ACTIVE;
                }
                widget = "pushbutton.scopeselector";
                break;
            }
            case BUTTON_ROUNDED_RECT: {
                widget = "pushbutton.inlay";
                break;
            }
            case BUTTON_ROUND: {
                widget = "roundbutton";
                break;
            }
            case BUTTON_ROUND_INSET: {
                widget = "roundbutton.inset";
                break;
            }
            case BUTTON_ROUND_TEXTURED: {
                widget = "kCUIWidgetButtonRoundTextured";
                break;
            }
            case BUTTON_ROUND_TOOLBAR: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonRoundToolbar" : "roundbutton";
                break;
            }
            case BUTTON_INLINE: {
                widget = "kCUIWidgetButtonPushSlideshow";
                break;
            }
            case BUTTON_TEXTURED: {
                widget = "kCUIWidgetButtonSegmentedSCurve";
                break;
            }
            case BUTTON_TEXTURED_TOOLBAR: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonSegmentedToolbar" : "kCUIWidgetButtonSegmentedSCurve";
                break;
            }
            case BUTTON_PUSH_INSET2: {
                widget = "kCUIWidgetButtonPushInset2";
                break;
            }
            case BUTTON_COLOR_WELL: {
                widget = "kCUIWidgetFrameColorWell";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        String direction = null;
        String background = null;
        Integer animationFrame = null;
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            AnimatedButtonConfiguration ag;
            AquaUIPainter.ButtonState previousButtonState;
            background = "backgroundTypeLight";
            direction = bs == AquaUIPainter.ButtonState.OFF ? (g.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? "right" : "left") : "down";
            animationFrame = -1;
            if (g instanceof AnimatedButtonConfiguration && (previousButtonState = (ag = (AnimatedButtonConfiguration)g).getPreviousButtonState()) != bs) {
                animationFrame = 1 + Math.round(2.0f * ag.getTransition());
                if (bs == AquaUIPainter.ButtonState.OFF) {
                    animationFrame = 4 - animationFrame;
                }
                direction = g.getLayoutDirection() == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT ? "right" : "left";
            }
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            direction = bs == AquaUIPainter.ButtonState.OFF ? "down" : "up";
        }
        Integer buttonState = this.toButtonState(bs);
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT || bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            if (bs == AquaUIPainter.ButtonState.ON && (st == AquaUIPainter.State.ACTIVE || st == AquaUIPainter.State.INACTIVE)) {
                st = AquaUIPainter.State.PRESSED;
            }
            buttonState = null;
        }
        if (bw.isTextured()) {
            if (st == AquaUIPainter.State.DISABLED) {
                st = AquaUIPainter.State.ACTIVE;
            } else if (st == AquaUIPainter.State.DISABLED_INACTIVE) {
                st = AquaUIPainter.State.INACTIVE;
            }
        }
        if (bs == AquaUIPainter.ButtonState.STATELESS || bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            if (st == AquaUIPainter.State.INACTIVE) {
                st = AquaUIPainter.State.ACTIVE;
            } else if (st == AquaUIPainter.State.DISABLED_INACTIVE) {
                st = AquaUIPainter.State.DISABLED;
            }
        }
        Object size = this.toSize(g.getSize());
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            size = null;
        }
        BasicRenderer r = this.getRenderer("widget", widget, "backgroundTypeKey", background, "size", size, "state", this.toState(st), "focus", g.isFocused(), "value", buttonState, "direction", direction, "animframe", animationFrame);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration g) {
        RendererDescription rd = rendererDescriptions.getScrollColumnSizerRendererDescription(g);
        String widget = "widget.scrollColumnSizer";
        BasicRenderer r = this.getRenderer("widget", widget, "state", this.toState(g.getState()), "focus", g.isFocused());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration g) {
        BasicRenderer r;
        String widget;
        RendererDescription rd = rendererDescriptions.getScrollBarRendererDescription(g);
        RendererDescription trd = rendererDescriptions.getScrollBarThumbRendererDescription(g);
        AquaUIPainter.ScrollBarWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.Orientation o = g.getOrientation();
        float thumbPosition = g.getThumbPosition();
        float thumbExtent = g.getThumbExtent();
        boolean nothingToScroll = st == AquaUIPainter.State.DISABLED || st == AquaUIPainter.State.DISABLED_INACTIVE;
        boolean indicatorOnly = false;
        switch (bw) {
            case LEGACY: {
                widget = "scrollbar";
                if (st == AquaUIPainter.State.ROLLOVER) {
                    st = AquaUIPainter.State.PRESSED;
                }
                if (!g.isTrackSuppressed()) break;
                indicatorOnly = true;
                break;
            }
            case OVERLAY: {
                if (nothingToScroll) {
                    return NULL_RENDERER;
                }
                widget = "kCUIWidgetOverlayScrollBar";
                indicatorOnly = true;
                break;
            }
            case OVERLAY_ROLLOVER: {
                if (nothingToScroll) {
                    return NULL_RENDERER;
                }
                widget = "kCUIWidgetOverlayScrollBar";
                indicatorOnly = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (nothingToScroll) {
            BasicRenderer r2 = this.getRenderer("widget", widget, "size", this.toSize(sz), "kCUIOrientationKey", this.toOrientation(o), "noindicator", true);
            return Renderer.create(r2, rd);
        }
        AquaUIPainter.ScrollBarKnobWidget kw = g.getKnobWidget();
        String variant = null;
        switch (kw) {
            case LIGHT: {
                variant = "kCUIVariantWhite";
                break;
            }
            case DARK: {
                variant = "kCUIVariantBlack";
            }
        }
        Renderer trackRenderer = null;
        Renderer thumbRenderer = null;
        if (bw == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER || bw == AquaUIPainter.ScrollBarWidget.LEGACY && !g.isTrackSuppressed()) {
            r = this.getRenderer("widget", widget, "kCUIVariantKey", variant, "size", this.toSize(sz), "kCUIOrientationKey", this.toOrientation(o), "noindicator", true);
            trackRenderer = Renderer.create(r, rd);
        }
        if (kw != AquaUIPainter.ScrollBarKnobWidget.NONE) {
            if (st == AquaUIPainter.State.PRESSED || bw == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER) {
                r = this.getRenderer("widget", widget, "kCUIVariantKey", variant, "size", this.toSize(sz), "kCUIOrientationKey", this.toOrientation(o), "noarrows", true, "kCUIThumbProportionKey", thumbExtent, "indiconly", indicatorOnly, "state", "rollover", "value", thumbPosition);
                thumbRenderer = Renderer.create(r, trd);
            } else {
                r = this.getRenderer("widget", widget, "kCUIVariantKey", variant, "size", this.toSize(sz), "kCUIOrientationKey", this.toOrientation(o), "noarrows", true, "kCUIThumbProportionKey", thumbExtent, "indiconly", indicatorOnly, "value", thumbPosition);
                thumbRenderer = Renderer.create(r, trd);
            }
        }
        return Renderer.createCompositeRenderer(trackRenderer, thumbRenderer);
    }

    @Override
    @NotNull
    protected Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration g) {
        RendererDescription rd = rendererDescriptions.getToolBarItemWellRendererDescription(g);
        String widget = "kCUIWidgetToolbarItemWell";
        AquaUIPainter.State st = g.getState();
        BasicRenderer r = this.getRenderer("widget", widget, "state", this.toState(st), "kCUIPresentationStateKey", this.toPresentationState(st), "borders only", g.isFrameOnly());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getGroupBoxRendererDescription(g);
        String widget = "group";
        BasicRenderer r = this.getRenderer("widget", widget, "state", this.toState(g.getState()), "borders only", g.isFrameOnly());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getListBoxRenderer(@NotNull ListBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getListBoxRendererDescription(g);
        String widget = "listbox";
        BasicRenderer r = this.getRenderer("widget", widget, "state", this.toState(g.getState()), "focus", g.isFocused(), "borders only", g.isFrameOnly());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTextFieldRendererDescription(g);
        AquaUIPainter.TextFieldWidget tw = g.getWidget();
        String widget = this.getWidget(tw);
        if (widget != null) {
            String variant = this.getVariant(tw);
            BasicRenderer r = this.getRenderer("widget", widget, "size", tw == AquaUIPainter.TextFieldWidget.TEXT_FIELD ? this.toSize(AquaUIPainter.Size.LARGE) : this.toSize(g.getSize()), "state", this.toState(g.getState()), "kCUIVariantKey", variant, "focus", g.isFocused());
            return Renderer.create(r, rd);
        }
        if (tw.isSearch()) {
            Insetter searchButtonInsets = uiLayout.getSearchButtonPaintingInsets(g);
            Insetter cancelButtonInsets = tw.hasCancel() ? uiLayout.getCancelButtonPaintingInsets(g) : null;
            return new SearchFieldRenderer(g, rd, searchButtonInsets, cancelButtonInsets);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    private String getWidget(@NotNull AquaUIPainter.TextFieldWidget tw) {
        switch (tw) {
            case TEXT_FIELD_ROUND: 
            case TEXT_FIELD_ROUND_TOOLBAR: {
                return "textfieldround";
            }
            case TEXT_FIELD: {
                return "textfield";
            }
        }
        return null;
    }

    @Nullable
    private String getVariant(@NotNull AquaUIPainter.TextFieldWidget tw) {
        return tw.isToolbar() ? "kCUIVariantTextFieldRoundToolbar" : null;
    }

    @Override
    @NotNull
    public Renderer getSearchFieldFindButtonRenderer(@NotNull TextFieldConfiguration g) {
        AquaUIPainter.TextFieldWidget widget = g.getWidget();
        boolean hasMenu = widget.hasMenu();
        BasicRenderer r = this.getRenderer("widget", "buttonsearchfieldfind", "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(g.getLayoutDirection()), "size", this.toSize(g.getSize()), "state", this.toState(g.getState()), "kCUIVariantKey", hasMenu ? "variant.withmenuglyph" : null);
        RendererDescription rd = this.getSearchFieldFindButtonRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected RendererDescription getSearchFieldFindButtonRendererDescription(@NotNull TextFieldConfiguration g) {
        return this.getSearchButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public Renderer getSearchFieldCancelButtonRenderer(@NotNull TextFieldConfiguration g) {
        BasicRenderer r = this.getRenderer("widget", "buttonsearchfieldcancel", "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(g.getLayoutDirection()), "size", this.toSize(g.getSize()), "state", this.toState(g.getState()));
        RendererDescription rd = this.getSearchFieldCancelButtonRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected RendererDescription getSearchFieldCancelButtonRendererDescription(@NotNull TextFieldConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getComboBoxRendererDescription(g);
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.UILayoutDirection ld = g.getLayoutDirection();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            BasicRenderer r = this.getRenderer("widget", "combobox", "size", this.toSize(sz), "state", this.toState(st), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(ld), "noframe", true);
            return Renderer.create(r, rd);
        }
        String widget = this.getWidget(bw);
        BasicRenderer r = this.getRenderer("widget", widget, "size", this.toSize(sz), "state", this.toState(st), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(ld), "focus", g.isFocused());
        return Renderer.create(r, rd);
    }

    @NotNull
    private String getWidget(@NotNull AquaUIPainter.ComboBoxWidget w) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        switch (w) {
            case BUTTON_COMBO_BOX_TEXTURED: {
                return "kCUIWidgetButtonComboBoxTextured";
            }
            case BUTTON_COMBO_BOX_TEXTURED_TOOLBAR: {
                return platformVersion >= 101100 ? "kCUIWidgetButtonComboBoxToolbar" : "kCUIWidgetButtonComboBoxTextured";
            }
        }
        return "combobox";
    }

    @Override
    @NotNull
    protected Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer basicRenderer = this.getBasicPopupButtonRenderer(g);
        Renderer arrowsRenderer = this.getPopupArrowRenderer(g);
        Insetter arrowsInsetter = arrowsRenderer != null ? uiLayout.getPopUpArrowInsets(g) : null;
        return new PopupRenderer(g, basicRenderer, arrowsRenderer, arrowsInsetter);
    }

    @Nullable
    public Renderer getBasicPopupButtonRenderer(@NotNull PopupButtonConfiguration g) {
        BasicRenderer r;
        String widget;
        if (g.isCell()) {
            return null;
        }
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.UILayoutDirection ld = g.getLayoutDirection();
        Collection extraParameters = null;
        RendererDescription rd = rendererDescriptions.getBasicPopupButtonRendererDescription(g);
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        switch (g.getPopupButtonWidget()) {
            case BUTTON_POP_DOWN: {
                widget = "popdownbutton";
                break;
            }
            case BUTTON_POP_UP: {
                widget = "popupbutton";
                break;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                widget = "bevelbuttonround";
                break;
            }
            case BUTTON_POP_DOWN_ROUND_RECT: {
                widget = "popdownbutton.inset";
                break;
            }
            case BUTTON_POP_UP_ROUND_RECT: {
                widget = "popupbutton.inset";
                break;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                if (st != AquaUIPainter.State.ROLLOVER && st != AquaUIPainter.State.PRESSED) {
                    return null;
                }
                widget = "pushbutton.scopeselector";
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED: {
                widget = "kCUIWidgetButtonPopDownTextured";
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonPopDownToolbar" : "kCUIWidgetButtonPopDownTextured";
                break;
            }
            case BUTTON_POP_UP_TEXTURED: {
                widget = "kCUIWidgetButtonPopUpTextured";
                break;
            }
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonPopUpToolbar" : "kCUIWidgetButtonPopUpTextured";
                break;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                widget = "bevelbuttoninset";
                break;
            }
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_SQUARE: {
                widget = "bevelbutton";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (extraParameters == null) {
            r = this.getRenderer("widget", widget, "size", this.toSize(sz), "state", this.toState(st), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(ld));
        } else {
            List<Object> parameters = Arrays.asList("widget", widget, "size", this.toSize(sz), "state", this.toState(st), "kCUIUserInterfaceLayoutDirectionKey", this.toLayoutDirection(ld));
            parameters.addAll(extraParameters);
            r = this.getRenderer(parameters.toArray());
        }
        return Renderer.create(r, rd);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        AquaUIPainter.State state = g.getState();
        switch (w) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: 
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                return null;
            }
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_UP_CELL: {
                if (state != AquaUIPainter.State.ROLLOVER) break;
                state = AquaUIPainter.State.ACTIVE;
            }
        }
        Object ld = this.toLayoutDirection(g.getLayoutDirection());
        String bt = "backgroundTypeLight";
        String st = this.toState(state);
        if (g.isPopUp()) {
            AquaUIPainter.Size arrowSize = g.getSize();
            BasicRenderer r = this.getRenderer("widget", "popupbutton", "arrowsonly", true, "backgroundTypeKey", bt, "kCUIUserInterfaceLayoutDirectionKey", ld, "size", this.toSize(arrowSize), "state", st);
            CoreUIRendererDescriptions rds = rendererDescriptions;
            RendererDescription rd = rds.getPopUpArrowRendererDescription(g, arrowSize);
            return Renderer.create(r, rd);
        }
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        String imageName = platformVersion >= 101100 ? "DropDownIndicator" : "image.DropDownIndicator";
        BasicRenderer r = this.getRenderer("widget", "image", "imageIsGrayscaleKey", true, "imageNameKey", imageName, "backgroundTypeKey", bt, "kCUIUserInterfaceLayoutDirectionKey", ld, "state", st);
        CoreUIRendererDescriptions rds = rendererDescriptions;
        RendererDescription rd = rds.getPullDownArrowRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTitleBarRendererDescription(g);
        Insetter closeButtonInsets = uiLayout.getTitleBarButtonInsets(g, AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
        Insetter minimizeButtonInsets = uiLayout.getTitleBarButtonInsets(g, AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
        Insetter resizeButtonInsets = uiLayout.getTitleBarButtonInsets(g, AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
        return new TitleBarRenderer(g, rd, closeButtonInsets, minimizeButtonInsets, resizeButtonInsets);
    }

    @Override
    @NotNull
    protected Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration g) {
        String widget;
        RendererDescription rd = rendererDescriptions.getIndeterminateProgressIndicatorRendererDescription(g);
        AquaUIPainter.Size sz = g.getSize();
        switch (g.getWidget()) {
            case SPINNER: {
                widget = "widget.progressSpinner";
                if (sz == AquaUIPainter.Size.SMALL) break;
                sz = AquaUIPainter.Size.LARGE;
                break;
            }
            case INDETERMINATE_BAR: {
                if (sz == AquaUIPainter.Size.MINI) {
                    throw new UnsupportedOperationException();
                }
                widget = "kCUIWidgetIndeterminateBar";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        BasicRenderer r = this.getRenderer("widget", widget, "size", this.toSize(sz), "state", this.toState(g.getState()), "kCUIOrientationKey", this.toOrientation(g.getOrientation()), "animframe", g.getAnimationFrame());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration g) {
        RendererDescription rd = rendererDescriptions.getProgressIndicatorRendererDescription(g);
        if (g.getSize() == AquaUIPainter.Size.MINI) {
            throw new UnsupportedOperationException();
        }
        Object layoutDirection = g.getWidget() == AquaUIPainter.ProgressWidget.BAR ? this.toLayoutDirection(g.getLayoutDirection()) : null;
        BasicRenderer r = this.getRenderer("widget", "kCUIWidgetProgressBar", "size", this.toSize(g.getSize()), "state", this.toActiveStateCode(g.getState()), "kCUIPresentationStateKey", this.toPresentationState(g.getState()), "kCUIOrientationKey", this.toOrientation(g.getOrientation()), "kCUIUserInterfaceLayoutDirectionKey", layoutDirection, "value", g.getValue());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        AquaUIPainter.Size sz;
        RendererDescription rd = rendererDescriptions.getSliderRendererDescription(g);
        AquaUIPainter.SliderWidget sw = g.getWidget();
        AquaUIPainter.Size size = sz = g.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : g.getSize();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            int degrees = (int)Math.round(g.getValue() * 360.0);
            BasicRenderer r = this.getRenderer("widget", "dial", "size", this.toSize(sz), "state", this.toState(g.getState()), "focus", false, "noindicator", true, "value", degrees);
            return Renderer.create(r, rd);
        }
        Renderer trackRenderer = this.getSliderTrackRenderer(g);
        Renderer tickMarkRenderer = this.getSliderTickMarkRenderer(g);
        Renderer thumbRenderer = this.getSliderThumbRenderer(g);
        Insetter trackInsets = uiLayout.getSliderTrackPaintingInsets(g);
        Insetter thumbInsets = uiLayout.getSliderThumbPaintingInsets(g, g.getValue());
        return new LinearSliderRenderer(g, trackRenderer, trackInsets, tickMarkRenderer, thumbRenderer, thumbInsets);
    }

    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration g) {
        return null;
    }

    @NotNull
    protected Renderer getSliderTrackRenderer(@NotNull SliderConfiguration g) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size sz = g.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : g.getSize();
        String uiDirection = "kCUIUserInterfaceLayoutDirectionLeftToRight";
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            sw = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
            uiDirection = "kCUIUserInterfaceLayoutDirectionRightToLeft";
        } else if (sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            sw = AquaUIPainter.SliderWidget.SLIDER_VERTICAL;
        }
        AquaUIPainter.State st = g.getState();
        boolean isTinted = st != AquaUIPainter.State.DISABLED && st != AquaUIPainter.State.DISABLED_INACTIVE && !g.hasTickMarks();
        String orientation = sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL ? "kCUIOrientVertical" : "kCUIOrientHorizontal";
        String direction = g.hasTickMarks() ? this.toDirection(g.getTickMarkPosition()) : "none";
        BasicRenderer r = this.getRenderer("widget", "slider", "noindicator", true, "size", this.toSize(sz), "state", this.toState(g.getState()), "kCUIOrientationKey", orientation, "direction", direction, "kCUIUserInterfaceLayoutDirectionKey", uiDirection, "kCUISliderTrackDrawTintedKey", isTinted, "value", g.getValue());
        if (g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN && isTinted) {
            r = new FlipVerticalRenderer(r);
        }
        RendererDescription rd = rendererDescriptions.getSliderTrackRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration g) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return NULL_RENDERER;
        }
        AquaUIPainter.Size sz = g.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : g.getSize();
        String orientation = sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL ? "kCUIOrientVertical" : "kCUIOrientHorizontal";
        String direction = g.hasTickMarks() ? this.toDirection(g.getTickMarkPosition()) : "none";
        BasicRenderer r = this.getRenderer("widget", "kCUIWidgetSliderThumb", "size", this.toSize(sz), "state", this.toState(g.getState()), "kCUIOrientationKey", orientation, "direction", direction, "focus", g.isFocused(), "value", g.getValue());
        RendererDescription rd = rendererDescriptions.getSliderThumbRendererDescription(g);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSpinnerArrowsRendererDescription(g);
        AquaUIPainter.State st = g.getState();
        if (st == AquaUIPainter.State.PRESSED && !g.isPressedTop()) {
            BasicRenderer r = this.getRenderer("widget", "littlearrows", "size", this.toSize(g.getSize()), "state", this.toState(st), "value", 1);
            return Renderer.create(r, rd);
        }
        BasicRenderer r = this.getRenderer("widget", "littlearrows", "size", this.toSize(g.getSize()), "state", this.toState(st));
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        String variant;
        RendererDescription rd = rendererDescriptions.getSplitPaneDividerRendererDescription(g);
        String widget = "splitter";
        String orientation = this.toOrientation(g.getOrientation());
        switch (g.getWidget()) {
            case THIN_DIVIDER: {
                return NULL_RENDERER;
            }
            case THICK_DIVIDER: {
                variant = "kCUIVariantDividerSplitterDimple";
                break;
            }
            default: {
                variant = "kCUIVariantDividerSplitterRodMail";
            }
        }
        BasicRenderer r = this.getRenderer("widget", widget, "state", this.toState(g.getState()), "kCUIVariantKey", variant, "kCUIOrientationKey", orientation);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSegmentedButtonRendererDescription(g);
        BasicRenderer r = this.getSegmentedButtonBasicRenderer(g);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected BasicRenderer getSegmentedButtonBasicRenderer(@NotNull SegmentedButtonConfiguration g) {
        boolean isSelected = g.isSelected();
        boolean isLeftNeighborSelected = g.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED;
        boolean isRightNeighborSelected = g.getRightDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED;
        String leftType = "kCUISegmentSeparatorTypeNoneSelected";
        if (isSelected) {
            leftType = isLeftNeighborSelected ? "kCUISegmentSeparatorTypeBothSelected" : "kCUISegmentSeparatorTypeRightSelected";
        } else if (isLeftNeighborSelected) {
            leftType = "kCUISegmentSeparatorTypeLeftSelected";
        }
        String rightType = "kCUISegmentSeparatorTypeNoneSelected";
        if (isSelected) {
            rightType = isRightNeighborSelected ? "kCUISegmentSeparatorTypeBothSelected" : "kCUISegmentSeparatorTypeLeftSelected";
        } else if (isRightNeighborSelected) {
            rightType = "kCUISegmentSeparatorTypeRightSelected";
        }
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.State st = g.getState();
        String widget = "segmentedbutton";
        String state = this.toState(st);
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        switch (bw) {
            case BUTTON_TAB: {
                widget = "tab";
                break;
            }
            case BUTTON_SEGMENTED: {
                widget = "segmentedbutton";
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                widget = "kCUIWidgetButtonSegmentedInset";
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                widget = "kCUIWidgetButtonSegmentedSCurve";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: {
                widget = "kCUIWidgetButtonSegmentedTextured";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonSegmentedToolbar" : "kCUIWidgetButtonSegmentedTextured";
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                widget = "kCUIWidgetButtonSegmentedToolbar";
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                widget = "bevelbuttoninset";
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                widget = "kCUIWidgetButtonSegmentedSeparated";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonSegmentedSeparatedTextured" : "kCUIWidgetButtonSegmentedSeparatedToolbar";
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                widget = platformVersion >= 101100 ? "kCUIWidgetButtonSegmentedSeparatedToolbar" : "kCUIWidgetButtonSegmentedSeparatedToolbar";
            }
        }
        return this.getRenderer("widget", widget, "size", this.toSize(g.getSize()), "state", state, "kCUIPresentationStateKey", this.toPresentationState(g.getState()), "focus", g.isFocused(), "kCUIUserInterfaceLayoutDirectionKey", "kCUIUserInterfaceLayoutDirectionLeftToRight", "direction", this.toDirection(g.getDirection()), "kCUIPositionKey", this.toSegmentPosition(g.getPosition()), "kCUISegmentLeadingSeparatorKey", g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE, "kCUISegmentTrailingSeparatorKey", g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE, "kCUISegmentLeadingSeparatorTypeKey", leftType, "kCUISegmentTrailingSeparatorTypeKey", rightType, "value", isSelected ? 1 : 0);
    }

    @Override
    @NotNull
    protected Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTableColumnHeaderRendererDescription(g);
        Boolean value = g.getSortArrowDirection() != AquaUIPainter.ColumnSortArrowDirection.NONE;
        BasicRenderer r = this.getRenderer("widget", "listheader", "state", this.toState(g.getState()), "focus", g.isFocused(), "direction", this.toDirection(g.getSortArrowDirection()), "value", value);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getGradientRenderer(@NotNull GradientConfiguration g) {
        RendererDescription rd = rendererDescriptions.getGradientRendererDescription(g);
        String variant = this.toVariant(g.getWidget());
        Integer state = this.toActiveStateCode(g.getState());
        BasicRenderer r = this.getRenderer("widget", "gradient", "kCUIVariantKey", variant, "state", state);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected Object toSize(@NotNull AquaUIPainter.Size sz) {
        switch (sz) {
            case MINI: {
                return "mini";
            }
            case SMALL: {
                return "small";
            }
            case REGULAR: {
                return "regular";
            }
            case LARGE: {
                return "large";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case DISABLED: {
                return "disabled";
            }
            case DISABLED_INACTIVE: {
                return "disabled";
            }
            case PRESSED: {
                return "pressed";
            }
            case ACTIVE_DEFAULT: {
                return "pulsed";
            }
            case ROLLOVER: {
                return "rollover";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toActiveState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return "inactive";
            }
        }
        return "active";
    }

    @NotNull
    protected String toActiveDisabledState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return "disabled";
            }
        }
        return "active";
    }

    protected int toActiveStateCode(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    protected Object toPresentationState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case ACTIVE: {
                return "kCUIPresentationStateActiveKey";
            }
            case INACTIVE: {
                return "kCUIPresentationStateInactive";
            }
            case DISABLED: {
                return "kCUIPresentationStateActiveKey";
            }
            case DISABLED_INACTIVE: {
                return "kCUIPresentationStateInactive";
            }
            case PRESSED: {
                return "kCUIPresentationStateActiveKey";
            }
            case ACTIVE_DEFAULT: {
                return "kCUIPresentationStateActiveKey";
            }
            case ROLLOVER: {
                return "kCUIPresentationStateActiveKey";
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toButtonState(@NotNull AquaUIPainter.ButtonState s) {
        switch (s) {
            case OFF: 
            case STATELESS: {
                return 0;
            }
            case ON: {
                return 1;
            }
            case MIXED: {
                return 2;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toHorizontalAlignment(@NotNull AquaUIPainter.HorizontalAlignment ha) {
        switch (ha) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toVerticalAlignment(@NotNull AquaUIPainter.VerticalAlignment va) {
        switch (va) {
            case TOP: {
                return "top";
            }
            case CENTER: {
                return "center";
            }
            case BOTTOM: {
                return "bottom";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toOrientation(@NotNull AquaUIPainter.Orientation o) {
        switch (o) {
            case HORIZONTAL: {
                return "kCUIOrientHorizontal";
            }
            case VERTICAL: {
                return "kCUIOrientVertical";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toDirection(@NotNull AquaUIPainter.ColumnSortArrowDirection d) {
        switch (d) {
            case NONE: {
                return "none";
            }
            case UP: {
                return "up";
            }
            case DOWN: {
                return "down";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toDirection(@NotNull AquaUIPainter.Direction d) {
        switch (d) {
            case NONE: {
                return "none";
            }
            case UP: {
                return "up";
            }
            case DOWN: {
                return "down";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toDirection(@NotNull AquaUIPainter.TickMarkPosition p) {
        switch (p) {
            case ABOVE: {
                return "up";
            }
            case BELOW: {
                return "down";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toLayoutDirection(@NotNull AquaUIPainter.UILayoutDirection ld) {
        switch (ld) {
            case LEFT_TO_RIGHT: {
                return "kCUIUserInterfaceLayoutDirectionLeftToRight";
            }
            case RIGHT_TO_LEFT: {
                return "kCUIUserInterfaceLayoutDirectionRightToLeft";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Object toSegmentPosition(@NotNull AquaUIPainter.Position sp) {
        switch (sp) {
            case FIRST: {
                return "kCUISegmentPositionFirst";
            }
            case MIDDLE: {
                return "kCUISegmentPositionMiddle";
            }
            case LAST: {
                return "kCUISegmentPositionLast";
            }
            case ONLY: {
                return "kCUISegmentPositionOnly";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected String toVariant(@NotNull AquaUIPainter.GradientWidget gw) {
        switch (gw) {
            case GRADIENT_FIND_BAR: {
                return "kCUIVariantGradientFindBar";
            }
            case GRADIENT_FINDER_INFO: {
                return "variant.gradient.FinderInfo";
            }
            case GRADIENT_FINDER_SIDE_BAR: {
                return "variant.gradient.FinderSideBar";
            }
            case GRADIENT_FREEFORM: {
                return "kCUIVariantGradientFreeform";
            }
            case GRADIENT_LIST_BACKGROUND_EVEN: {
                return "kCUIVariantGradientListBackgroundEven";
            }
            case GRADIENT_LIST_BACKGROUND_ODD: {
                return "kCUIVariantGradientListBackgroundOdd";
            }
            case GRADIENT_SCOPE_BACKGROUND_BAR: {
                return "kCUIVariantGradientScopeBackgroundBar";
            }
            case GRADIENT_SCOPE_BACKGROUND_EVEN: {
                return "kCUIVariantGradientScopeBackgroundEven";
            }
            case GRADIENT_SCOPE_BACKGROUND_ODD: {
                return "kCUIVariantGradientScopeBackgroundOdd";
            }
            case GRADIENT_SIDE_BAR: {
                return "kCUIVariantGradientSideBar";
            }
            case GRADIENT_SIDE_BAR_SELECTION: {
                return "kCUIVariantGradientSideBarSelection";
            }
            case GRADIENT_SIDE_BAR_SELECTION_MULTIPLE: {
                return "kCUIVariantGradientSideBarSelectionMultiple";
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected BasicRenderer getRenderer(Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("getRenderer requires an even number of parameters");
        }
        return (data, rw, rh, w, h) -> {
            float xscale = (float)rw / w;
            float yscale = (float)rh / h;
            if (debugFlag) {
                String msg = "Rendering";
                for (Object o : args) {
                    msg = msg + " " + o;
                }
                System.err.println(msg);
                System.err.flush();
            }
            if (this.useJRS) {
                CoreUIPainter.nativeJRSPaint(data, rw, rh, xscale, yscale, args);
            } else {
                CoreUIPainter.nativePaint(data, rw, rh, xscale, yscale, args);
            }
        };
    }

    private static native void nativePaint(int[] var0, int var1, int var2, float var3, float var4, Object[] var5);

    private static native void nativeJRSPaint(int[] var0, int var1, int var2, float var3, float var4, Object[] var5);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NativeSupport.load();
                return null;
            }
        });
        rendererDescriptions = new CoreUIRendererDescriptions();
    }

    protected class TitleBarRenderer
    extends TitleBarRendererBase {
        @NotNull
        private final Object windowType;

        public TitleBarRenderer(@NotNull TitleBarConfiguration g, @Nullable RendererDescription rd, @Nullable Insetter closeButtonInsets, @Nullable Insetter minimizeButtonInsets, Insetter resizeButtonInsets) {
            super(g, rd, closeButtonInsets, minimizeButtonInsets, resizeButtonInsets);
            switch (g.getWidget()) {
                case DOCUMENT_WINDOW: {
                    this.windowType = "regularwin";
                    break;
                }
                case UTILITY_WINDOW: {
                    this.windowType = "utilwin.variant2";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        @Override
        @NotNull
        protected BasicRenderer getBasicTitleBarRenderer(float w, float h) {
            String widget = "kCUIWidgetWindowFrame";
            String state = CoreUIPainter.this.toActiveState(this.g.getTitleBarState());
            return CoreUIPainter.this.getRenderer("widget", widget, "windowtype", this.windowType, "kCUIWindowFrameDrawClippedKey", 1, "kCUIWindowFrameDrawTitleSeparatorKey", 1, "kCUIWindowFrameUnifiedTitleBarHeightKey", h, "state", state, "value", h);
        }

        @Override
        @NotNull
        protected Renderer getButtonRenderer(@NotNull AquaUIPainter.TitleBarButtonWidget bw) {
            String ps;
            AquaUIPainter.State st;
            String widget;
            switch (bw) {
                case CLOSE_BOX: {
                    widget = "titlebarclose";
                    st = this.g.getCloseButtonState();
                    break;
                }
                case MINIMIZE_BOX: {
                    widget = "titlebarcollapse";
                    st = this.g.getMinimizeButtonState();
                    break;
                }
                case RESIZE_BOX: {
                    switch (this.g.getResizeAction()) {
                        case ZOOM_ENTER: 
                        case ZOOM_EXIT: {
                            widget = "titlebarzoom";
                            break;
                        }
                        case FULL_SCREEN_ENTER: {
                            widget = "kCUIWidgetTitleBarFullScreenEnter";
                            break;
                        }
                        case FULL_SCREEN_EXIT: {
                            widget = "kCUIWidgetTitleBarFullScreenExit";
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    st = this.g.getResizeButtonState();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            String string = ps = this.g.getTitleBarState() == AquaUIPainter.State.ACTIVE ? "kCUIPresentationStateActiveKey" : "kCUIPresentationStateInactive";
            if (this.g.isDirty() && bw == AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX) {
                BasicRenderer r = CoreUIPainter.this.getRenderer("widget", widget, "windowtype", this.windowType, "kCUIPresentationStateKey", ps, "state", CoreUIPainter.this.toState(st), "value", 1);
                return Renderer.create(r, null);
            }
            BasicRenderer r = CoreUIPainter.this.getRenderer("widget", widget, "windowtype", this.windowType, "kCUIPresentationStateKey", ps, "state", CoreUIPainter.this.toState(st));
            return Renderer.create(r, null);
        }
    }

    private class SearchFieldRenderer
    extends Renderer {
        @NotNull
        private final TextFieldConfiguration g;
        @NotNull
        private final RendererDescription rd;
        @Nullable
        private final Insetter searchButtonInsets;
        @Nullable
        private final Insetter cancelButtonInsets;

        public SearchFieldRenderer(@NotNull TextFieldConfiguration g, @Nullable RendererDescription rd, @Nullable Insetter searchButtonInsets, Insetter cancelButtonInsets) {
            this.g = g;
            this.rd = rd;
            this.searchButtonInsets = searchButtonInsets;
            this.cancelButtonInsets = cancelButtonInsets;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor compositor) {
            Rectangle2D bounds;
            Renderer br;
            float w = compositor.getWidth();
            float h = compositor.getHeight();
            String variant = CoreUIPainter.this.getVariant(this.g.getWidget());
            BasicRenderer br2 = CoreUIPainter.this.getRenderer("widget", "textfieldround", "size", CoreUIPainter.this.toSize(this.g.getSize()), "state", CoreUIPainter.this.toState(this.g.getState()), "kCUIVariantKey", variant, "focus", this.g.isFocused());
            Renderer r = Renderer.create(br2, this.rd);
            r.composeTo(compositor);
            if (this.searchButtonInsets != null) {
                br = CoreUIPainter.this.getSearchFieldFindButtonRenderer(this.g);
                bounds = this.searchButtonInsets.apply2D(w, h);
                r = Renderer.createOffsetRenderer(br, bounds);
                r.composeTo(compositor);
            }
            if (this.cancelButtonInsets != null) {
                br = CoreUIPainter.this.getSearchFieldCancelButtonRenderer(this.g);
                bounds = this.cancelButtonInsets.apply2D(w, h);
                r = Renderer.createOffsetRenderer(br, bounds);
                r.composeTo(compositor);
            }
        }
    }
}

