/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.ViewRendererDescriptions;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class CoreUIRendererDescriptions
extends ViewRendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration g) {
        AquaUIPainter.DividerWidget dw = g.getWidget();
        AquaUIPainter.Orientation o = g.getOrientation();
        switch (g.getWidget()) {
            case THIN_DIVIDER: 
            case THICK_DIVIDER: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case PANE_SPLITTER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration g) {
        AquaUIPainter.ButtonWidget bw = this.toCanonicalButtonStyle(g.getButtonWidget());
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 4.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
            int platformVersion = JNRPlatformUtils.getPlatformVersion();
            if (platformVersion >= 101100) {
                BasicRendererDescription x1 = new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
                BasicRendererDescription x2 = new BasicRendererDescription(-0.5f, -1.0f, 1.0f, 2.0f);
                return new MultiResolutionRendererDescription(x1, x2);
            }
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return super.getButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        RendererDescription rd = super.getSegmentedButtonRendererDescription(g);
        float extraWidth = 0.0f;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float leftOffset = 0.0f;
        float leftExtraWidth = 0.0f;
        float rightExtraWidth = 0.0f;
        float extraHeight = 0.0f;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                yOffset = JNRUtils.size2D(sz, -0.51f, -1.0f, -2.0f);
                leftOffset = JNRUtils.size(sz, -2, -2, -1);
                if (bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED && g.getPosition() != AquaUIPainter.Position.ONLY) {
                    return this.getSegmentedSeparatedRendererDescription(g, rd, yOffset, leftOffset);
                }
                leftExtraWidth = rightExtraWidth = (float)JNRUtils.size(sz, 2, 2, 1);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                yOffset = JNRUtils.size2D(sz, -1.0f, -1.51f, -2.0f);
                leftOffset = -1.0f;
                leftExtraWidth = 1.0f;
                rightExtraWidth = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                if (sz == AquaUIPainter.Size.MINI) {
                    rd = this.createVertical(0.0f, 4.0f);
                }
                yOffset = JNRUtils.size2D(sz, 0.0f, platformVersion >= 101100 ? -1.5f : -1.0f, -2.0f);
                if (!bw.isSeparated()) break;
                return this.getTexturedSeparatedRendererDescription(g, rd, yOffset);
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                yOffset = -1.0f;
                extraHeight = JNRUtils.size(sz, 0, -1, -2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.adjustSegmentedRendererDescription(g, rd, extraWidth, xOffset, yOffset, leftOffset, leftExtraWidth, rightExtraWidth, extraHeight);
    }

    @NotNull
    protected RendererDescription getTexturedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration g, @NotNull RendererDescription rd, float yOffset) {
        float extraWidth1 = 0.0f;
        float extraWidth2 = -0.5f;
        float xOffset1 = 0.0f;
        float xOffset2 = 0.0f;
        boolean hasLeft = g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean hasRight = g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        AquaUIPainter.Position pos = g.getPosition();
        if (pos == AquaUIPainter.Position.FIRST) {
            if (!hasRight) {
                extraWidth1 = 1.0f;
                extraWidth2 = 0.5f;
            } else {
                extraWidth2 = 0.0f;
            }
        } else if (pos == AquaUIPainter.Position.MIDDLE) {
            if (hasRight && !hasLeft) {
                extraWidth2 = 0.5f;
                xOffset2 = -0.5f;
            } else if (hasLeft && !hasRight) {
                extraWidth1 = 1.0f;
                extraWidth2 = 0.5f;
            } else if (!hasLeft && !hasRight) {
                extraWidth1 = 1.0f;
                extraWidth2 = 1.0f;
                xOffset2 = -0.5f;
            } else {
                extraWidth2 = 0.0f;
            }
        } else if (pos == AquaUIPainter.Position.LAST) {
            if (!hasLeft) {
                extraWidth2 = 0.5f;
                xOffset2 = -0.5f;
            } else {
                extraWidth2 = 0.0f;
            }
        }
        RendererDescription d1 = this.adjustSegmentedRendererDescription(g, rd, extraWidth1, xOffset1, yOffset, 0.0f, 0.0f, 0.0f, 0.0f);
        RendererDescription d2 = this.adjustSegmentedRendererDescription(g, rd, extraWidth2, xOffset2, yOffset, 0.0f, 0.0f, 0.0f, 0.0f);
        return new MultiResolutionRendererDescription(d1, d2);
    }

    @NotNull
    protected RendererDescription getSegmentedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration g, @NotNull RendererDescription rd, float yOffset, float xOffset) {
        boolean hasLeft = g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean hasRight = g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        float extraWidth = hasRight ? 2.0f : 2.5f;
        AquaUIPainter.Position pos = g.getPosition();
        if (pos != AquaUIPainter.Position.FIRST) {
            if (pos == AquaUIPainter.Position.MIDDLE) {
                xOffset = 0.0f;
                extraWidth = 0.49f;
                if (hasRight && !hasLeft) {
                    xOffset = -0.49f;
                } else if (hasLeft && hasRight) {
                    extraWidth = 0.0f;
                } else if (!hasLeft && !hasRight) {
                    extraWidth = 1.0f;
                    xOffset = -0.49f;
                }
            } else if (pos == AquaUIPainter.Position.LAST) {
                extraWidth = 2.0f;
                xOffset = hasLeft ? 0.0f : -0.49f;
            }
        }
        try {
            return JNRUtils.adjustRendererDescription(rd, xOffset, yOffset, extraWidth, 0.0f);
        }
        catch (UnsupportedOperationException ex) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + g);
            return rd;
        }
    }

    @NotNull
    protected RendererDescription adjustSegmentedRendererDescription(@NotNull SegmentedButtonConfiguration g, @NotNull RendererDescription rd, float extraWidth, float xOffset, float yOffset, float leftOffset, float leftExtraWidth, float rightExtraWidth, float extraHeight) {
        boolean isRightDividerPossible;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        boolean isSeparated = bw.isSeparated();
        AquaUIPainter.Position pos = g.getPosition();
        boolean atLeftEdge = pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.ONLY;
        boolean atRightEdge = pos == AquaUIPainter.Position.LAST || pos == AquaUIPainter.Position.ONLY;
        boolean isLeftDividerPossible = !isSeparated && (pos == AquaUIPainter.Position.MIDDLE || pos == AquaUIPainter.Position.LAST);
        boolean bl = isRightDividerPossible = !isSeparated && (pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.MIDDLE);
        if (atLeftEdge) {
            xOffset += leftOffset;
            extraWidth += leftExtraWidth;
        }
        if (atRightEdge) {
            extraWidth += rightExtraWidth;
        }
        if (isLeftDividerPossible && g.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.NONE) {
            xOffset -= 1.0f;
            extraWidth += 1.0f;
        }
        if (isRightDividerPossible && g.getRightDividerState() == SegmentedButtonConfiguration.DividerState.NONE) {
            extraWidth += 1.0f;
        }
        try {
            return JNRUtils.adjustRendererDescription(rd, xOffset, yOffset, extraWidth, extraHeight);
        }
        catch (UnsupportedOperationException ex) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + g);
            return rd;
        }
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.5f, 2.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (sz) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 1.0f, 0.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, -0.51f, 2.0f, 1.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        return super.getPopupButtonRendererDescription(g);
    }

    @Nullable
    public RendererDescription getPopUpArrowRendererDescription(@NotNull PopupButtonConfiguration g, @NotNull AquaUIPainter.Size arrowSize) {
        float left = JNRUtils.size2D(arrowSize, 1.0f, 0.0f, 2.0f);
        float top = JNRUtils.size2D(arrowSize, 3.0f, 1.0f, 1.0f);
        int w = JNRUtils.size(arrowSize, 1, 0, 1);
        int h = JNRUtils.size(arrowSize, 3, 1, 0);
        return new BasicRendererDescription(-left, -top, w, h);
    }

    @NotNull
    public RendererDescription getPullDownArrowRendererDescription(@NotNull PopupButtonConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public RendererDescription getScrollBarThumbRendererDescription(@NotNull ScrollBarConfiguration g) {
        int extra;
        int n = extra = g.getWidget() == AquaUIPainter.ScrollBarWidget.LEGACY ? 2 : 1;
        if (g.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            return new BasicRendererDescription(0.0f, extra, 0.0f, -2 * extra);
        }
        return new BasicRendererDescription(extra, 0.0f, -2 * extra, 0.0f);
    }
}

