/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.impl.ImageCache;

public class AquaPixelsKey
implements ImageCache.PixelsKey {
    private final int pixelCount;
    private final int hash;
    private final int scaleFactor;
    private final int w;
    private final int h;
    @NotNull
    private final Configuration g;

    public AquaPixelsKey(int scaleFactor, int w, int h, @NotNull Configuration g) {
        this.pixelCount = w * h;
        this.scaleFactor = scaleFactor;
        this.w = w;
        this.h = h;
        this.g = g;
        this.hash = this.hash();
    }

    @Override
    public int getPixelCount() {
        return this.pixelCount;
    }

    private int hash() {
        int hash = this.scaleFactor;
        hash = 31 * hash + this.w;
        hash = 31 * hash + this.h;
        hash = 31 * hash + this.g.hashCode();
        return hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj != null && obj.getClass() == AquaPixelsKey.class) {
            AquaPixelsKey that = (AquaPixelsKey)obj;
            return this.scaleFactor == that.scaleFactor && this.w == that.w && this.h == that.h && this.g.equals(that.g);
        }
        return false;
    }
}

