/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.ElCapitanLayoutInfo;
import org.violetlib.jnr.aqua.impl.SierraLayoutInfo;
import org.violetlib.jnr.aqua.impl.UIOutliner;
import org.violetlib.jnr.aqua.impl.YosemiteLayoutInfo;
import org.violetlib.jnr.aqua.impl.YosemiteOutliner;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public abstract class AquaUIPainterAbstractBase
implements AquaUIPainter {
    protected int w;
    protected int h;
    protected boolean forceVertical;
    protected boolean isAlignmentEnabled = true;
    @Nullable
    protected LayoutInfo layoutInfo;
    protected float xOffset;
    protected float yOffset;
    protected float pWidth;
    protected float pHeight;
    @NotNull
    protected static final AquaUILayoutInfo uiLayout;
    @NotNull
    protected static final UIOutliner uiOutliner;

    @NotNull
    private static AquaUILayoutInfo findLayoutInfo(int platformVersion) {
        if (platformVersion >= 101200) {
            return new SierraLayoutInfo();
        }
        if (platformVersion >= 101100) {
            return new ElCapitanLayoutInfo();
        }
        return new YosemiteLayoutInfo();
    }

    public void setAlignmentEnabled(boolean b) {
        this.isAlignmentEnabled = b;
    }

    @Override
    public void configure(int w, int h) {
        this.w = w;
        this.h = h;
        this.forceVertical = false;
    }

    @Override
    @NotNull
    public AquaUILayoutInfo getLayoutInfo() {
        return uiLayout;
    }

    @Override
    @NotNull
    public final Rectangle2D getComboBoxEditorBounds(@NotNull ComboBoxLayoutConfiguration g) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        Insetter s = uiLayout.getComboBoxEditorInsets(g);
        return s.applyToBounds2D(bounds);
    }

    @Override
    @NotNull
    public final Rectangle2D getComboBoxIndicatorBounds(@NotNull ComboBoxLayoutConfiguration g) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        Insetter s = uiLayout.getComboBoxIndicatorInsets(g);
        return s.applyToBounds2D(bounds);
    }

    @Override
    @NotNull
    public final Rectangle2D getPopupButtonContentBounds(@NotNull PopupButtonLayoutConfiguration g) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        Insetter s = uiLayout.getPopupButtonContentInsets(g);
        return s.applyToBounds2D(bounds);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull ScrollBarThumbLayoutConfiguration g, boolean useExtent) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        return uiLayout.getScrollBarThumbPosition(bounds, g, useExtent);
    }

    @Override
    public int getScrollBarThumbHit(@NotNull ScrollBarThumbConfiguration g) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        return uiLayout.getScrollBarThumbHit(bounds, g);
    }

    @Override
    @NotNull
    public final Rectangle2D getSliderThumbBounds(@NotNull SliderLayoutConfiguration g, double thumbPosition) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        return uiLayout.getSliderThumbBounds(bounds, g, thumbPosition);
    }

    @Override
    @NotNull
    public final Rectangle2D getSliderLabelBounds(@NotNull SliderLayoutConfiguration g, double thumbPosition, @NotNull Dimension size) {
        if (thumbPosition < 0.0 || thumbPosition > 1.0) {
            return new Rectangle(0, 0, 0, 0);
        }
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        return uiLayout.getSliderLabelBounds(bounds, g, thumbPosition, size);
    }

    public final double getSliderThumbCenter(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, double thumbPosition) {
        return uiLayout.getSliderThumbCenter(bounds, g, thumbPosition);
    }

    @Override
    public final double getSliderThumbPosition(@NotNull SliderLayoutConfiguration g, int x, int y) {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        return uiLayout.getSliderThumbPosition(bounds, g, x, y);
    }

    protected void configureLayout(@Nullable LayoutInfo info) {
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.pWidth = this.w;
        this.pHeight = this.h;
        this.layoutInfo = info;
        if (this.layoutInfo != null) {
            float fixedHeight;
            float fixedWidth = this.layoutInfo.getFixedVisualWidth();
            if (fixedWidth > 0.0f) {
                if ((float)this.w > fixedWidth && this.isAlignmentEnabled) {
                    this.xOffset = ((float)this.w - fixedWidth) / 2.0f;
                }
                this.pWidth = fixedWidth;
            }
            if ((fixedHeight = this.layoutInfo.getFixedVisualHeight()) > 0.0f) {
                if ((float)this.h > fixedHeight && this.isAlignmentEnabled) {
                    this.yOffset = ((float)this.h - fixedHeight) / 2.0f;
                }
                this.pHeight = fixedHeight;
            }
        }
    }

    @NotNull
    protected Rectangle2D getCenteredBounds(@Nullable LayoutInfo layoutInfo) {
        float x = 0.0f;
        float y = 0.0f;
        float width = this.w;
        float height = this.h;
        if (layoutInfo != null) {
            float extra;
            float fixedHeight;
            float extra2;
            float fixedWidth = layoutInfo.getFixedVisualWidth();
            if (fixedWidth > 0.0f && (extra2 = width - fixedWidth) > 0.0f) {
                x += extra2 / 2.0f;
                width -= extra2;
            }
            if ((fixedHeight = layoutInfo.getFixedVisualHeight()) > 0.0f && (extra = height - fixedHeight) > 0.0f) {
                y += extra / 2.0f;
                height -= extra;
            }
        }
        return new Rectangle2D.Float(x, y, width, height);
    }

    static {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        uiLayout = AquaUIPainterAbstractBase.findLayoutInfo(platformVersion);
        uiOutliner = new YosemiteOutliner((YosemiteLayoutInfo)uiLayout);
    }
}

