/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.NullPainter;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.SliderPainter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaRenderedPainter;
import org.violetlib.jnr.aqua.impl.AquaUIPainterAbstractBase;
import org.violetlib.jnr.aqua.impl.PopupArrowConfiguration;
import org.violetlib.jnr.aqua.impl.RendererDescriptions;
import org.violetlib.jnr.aqua.impl.SearchFieldCancelButtonConfiguration;
import org.violetlib.jnr.aqua.impl.SearchFieldFindButtonConfiguration;
import org.violetlib.jnr.aqua.impl.SliderThumbConfiguration;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.OffsetPainter;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDebugInfo;
import org.violetlib.jnr.impl.RendererDescription;

public abstract class AquaUIPainterBase
extends AquaUIPainterAbstractBase
implements AquaUIPainter {
    public static final Renderer NULL_RENDERER = Renderer.createCompositeRenderer(new Renderer[0]);
    @NotNull
    protected final RendererDescriptions rendererDescriptions;

    protected AquaUIPainterBase(@NotNull RendererDescriptions rds) {
        this.rendererDescriptions = rds;
    }

    @Override
    @Nullable
    public Shape getOutline(@NotNull LayoutConfiguration g) throws UnsupportedOperationException {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
        return this.getOutline(bounds, g);
    }

    @Nullable
    public Shape getOutline(@NotNull Rectangle2D bounds, @NotNull LayoutConfiguration g) throws UnsupportedOperationException {
        return uiOutliner.getOutline(bounds, g);
    }

    @Override
    @NotNull
    public Painter getPainter(@NotNull Configuration g) throws UnsupportedOperationException {
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo((LayoutConfiguration)((Object)g));
        Renderer r = this.getRenderer(g);
        Painter p = this.getPainter(layoutInfo, g, r);
        return this.customizePainter(p, g, layoutInfo);
    }

    @NotNull
    protected Painter customizePainter(@NotNull Painter p, @NotNull Configuration g, @NotNull LayoutInfo layoutInfo) {
        if (g instanceof SliderConfiguration) {
            SliderConfiguration sg = (SliderConfiguration)g;
            Rectangle2D bounds = this.getCenteredBounds(layoutInfo);
            return new SliderPainterImpl(sg, layoutInfo, bounds, sg.getValue(), p);
        }
        return p;
    }

    @NotNull
    public Renderer getRenderer(@NotNull Configuration g) {
        LayoutConfiguration gg;
        Renderer r;
        if (g instanceof ButtonConfiguration) {
            ButtonConfiguration gg2 = (ButtonConfiguration)g;
            return this.getButtonRenderer(gg2);
        }
        if (g instanceof ComboBoxConfiguration) {
            ComboBoxConfiguration gg3 = (ComboBoxConfiguration)g;
            return this.getComboBoxButtonRenderer(gg3);
        }
        if (g instanceof PopupButtonConfiguration) {
            PopupButtonConfiguration gg4 = (PopupButtonConfiguration)g;
            return this.getPopupButtonRenderer(gg4);
        }
        if (g instanceof TitleBarConfiguration) {
            TitleBarConfiguration gg5 = (TitleBarConfiguration)g;
            return this.getTitleBarRenderer(gg5);
        }
        if (g instanceof SliderConfiguration) {
            SliderConfiguration gg6 = (SliderConfiguration)g;
            return this.getSliderRenderer(gg6);
        }
        if (g instanceof SpinnerArrowsConfiguration) {
            SpinnerArrowsConfiguration gg7 = (SpinnerArrowsConfiguration)g;
            return this.getSpinnerArrowsRenderer(gg7);
        }
        if (g instanceof SplitPaneDividerConfiguration) {
            SplitPaneDividerConfiguration gg8 = (SplitPaneDividerConfiguration)g;
            return this.getSplitPaneDividerRenderer(gg8);
        }
        if (g instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration gg9 = (SegmentedButtonConfiguration)g;
            return this.getSegmentedButtonRenderer(gg9);
        }
        if (g instanceof ToolBarItemWellConfiguration) {
            ToolBarItemWellConfiguration gg10 = (ToolBarItemWellConfiguration)g;
            return this.getToolBarItemWellRenderer(gg10);
        }
        if (g instanceof GroupBoxConfiguration) {
            GroupBoxConfiguration gg11 = (GroupBoxConfiguration)g;
            return this.getGroupBoxRenderer(gg11);
        }
        if (g instanceof ListBoxConfiguration) {
            ListBoxConfiguration gg12 = (ListBoxConfiguration)g;
            return this.getListBoxRenderer(gg12);
        }
        if (g instanceof TextFieldConfiguration) {
            TextFieldConfiguration gg13 = (TextFieldConfiguration)g;
            return this.getTextFieldRenderer(gg13);
        }
        if (g instanceof ScrollBarConfiguration) {
            ScrollBarConfiguration gg14 = (ScrollBarConfiguration)g;
            return this.getScrollBarRenderer(gg14);
        }
        if (g instanceof ScrollColumnSizerConfiguration) {
            ScrollColumnSizerConfiguration gg15 = (ScrollColumnSizerConfiguration)g;
            return this.getScrollColumnSizerRenderer(gg15);
        }
        if (g instanceof IndeterminateProgressIndicatorConfiguration) {
            IndeterminateProgressIndicatorConfiguration gg16 = (IndeterminateProgressIndicatorConfiguration)g;
            return this.getIndeterminateProgressIndicatorRenderer(gg16);
        }
        if (g instanceof ProgressIndicatorConfiguration) {
            ProgressIndicatorConfiguration gg17 = (ProgressIndicatorConfiguration)g;
            return this.getProgressIndicatorRenderer(gg17);
        }
        if (g instanceof TableColumnHeaderConfiguration) {
            TableColumnHeaderConfiguration gg18 = (TableColumnHeaderConfiguration)g;
            return this.getTableColumnHeaderRenderer(gg18);
        }
        if (g instanceof GradientConfiguration) {
            GradientConfiguration gg19 = (GradientConfiguration)g;
            return this.getGradientRenderer(gg19);
        }
        if (g instanceof SliderThumbConfiguration) {
            SliderThumbConfiguration gg20 = (SliderThumbConfiguration)g;
            return this.getSliderThumbRenderer(gg20.getSliderConfiguration());
        }
        if (g instanceof PopupArrowConfiguration && (r = this.getPopupArrowRenderer(((PopupArrowConfiguration)(gg = (PopupArrowConfiguration)g)).getPopupButtonConfiguration())) != null) {
            return r;
        }
        if (g instanceof SearchFieldFindButtonConfiguration && (r = this.getSearchFieldFindButtonRenderer(((SearchFieldFindButtonConfiguration)(gg = (SearchFieldFindButtonConfiguration)g)).getTextFieldConfiguration())) != null) {
            return r;
        }
        if (g instanceof SearchFieldCancelButtonConfiguration && (r = this.getSearchFieldCancelButtonRenderer(((SearchFieldCancelButtonConfiguration)(gg = (SearchFieldCancelButtonConfiguration)g)).getTextFieldConfiguration())) != null) {
            return r;
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RendererDebugInfo getRendererDebugInfo(@NotNull Configuration g, int scaleFactor, int width, int height) {
        if (g instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration gg = (SegmentedButtonConfiguration)g;
            return this.getSegmentedButtonRendererDebugInfo(gg, scaleFactor, width, height);
        }
        return null;
    }

    @NotNull
    protected AquaUIPainter.ButtonWidget toCanonicalButtonStyle(AquaUIPainter.ButtonWidget bw) {
        return bw;
    }

    @Nullable
    protected Renderer getSearchFieldFindButtonRenderer(@NotNull TextFieldConfiguration g) {
        return null;
    }

    @Nullable
    protected Renderer getSearchFieldCancelButtonRenderer(@NotNull TextFieldConfiguration g) {
        return null;
    }

    @Nullable
    protected RendererDescription getSearchButtonRendererDescription(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (!w.isSearch()) {
            return null;
        }
        AquaUIPainter.Size sz = g.getSize();
        boolean hasMenu = w.hasMenu();
        if (hasMenu) {
            float x1 = JNRUtils.size2D(sz, -5.0f, -6.0f, -4.0f);
            float y1 = JNRUtils.size(sz, -1, -1, -2);
            float x2 = JNRUtils.size2D(sz, -5.5f, -6.0f, -4.5f);
            float y2 = JNRUtils.size2D(sz, -1.5f, -1.5f, -2.0f);
            float wa = JNRUtils.size(sz, 6, 7, 4);
            float ha = JNRUtils.size(sz, 1, 1, 2);
            if (!g.isLeftToRight()) {
                x1 += 4.0f;
                x2 += 4.0f;
            }
            BasicRendererDescription rd1 = new BasicRendererDescription(x1, y1, wa, ha);
            BasicRendererDescription rd2 = new BasicRendererDescription(x2, y2, wa, ha);
            return new MultiResolutionRendererDescription(rd1, rd2);
        }
        float x1 = 0.0f;
        float y1 = JNRUtils.size(sz, -1, -1, -2);
        float wa1 = 0.0f;
        float ha1 = JNRUtils.size(sz, 1, 1, 1);
        float x2 = -0.5f;
        float y2 = JNRUtils.size2D(sz, -1.5f, -2.0f, -2.0f);
        float wa2 = 0.0f;
        float ha2 = JNRUtils.size2D(sz, 1.0f, 1.5f, 1.5f);
        BasicRendererDescription rd1 = new BasicRendererDescription(x1, y1, wa1, ha1);
        BasicRendererDescription rd2 = new BasicRendererDescription(x2, y2, wa2, ha2);
        return new MultiResolutionRendererDescription(rd1, rd2);
    }

    @NotNull
    protected Painter getPainter(@Nullable LayoutInfo info, @NotNull Configuration g, @NotNull Renderer r) {
        this.configureLayout(info);
        if (this.pWidth <= 0.0f || this.pHeight <= 0.0f) {
            return new NullPainter(info);
        }
        Painter p = this.getPainter(g, r, this.pWidth, this.pHeight);
        if (this.xOffset != 0.0f || this.yOffset != 0.0f) {
            p = new OffsetPainter(p, this.xOffset, this.yOffset);
        }
        return p;
    }

    @NotNull
    protected Painter getPainter(@NotNull Configuration g, @NotNull Renderer r, float width, float height) {
        return new AquaRenderedPainter(g, r, width, height);
    }

    @NotNull
    protected abstract Renderer getButtonRenderer(@NotNull ButtonConfiguration var1);

    @NotNull
    protected abstract Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration var1);

    @NotNull
    protected abstract Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration var1);

    @NotNull
    protected abstract Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration var1);

    @NotNull
    protected abstract Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration var1);

    @NotNull
    protected abstract Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration var1);

    @NotNull
    protected abstract Renderer getListBoxRenderer(@NotNull ListBoxConfiguration var1);

    @NotNull
    protected abstract Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration var1);

    @NotNull
    protected abstract Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration var1);

    @NotNull
    protected abstract Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration var1);

    @NotNull
    protected abstract Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration var1);

    @NotNull
    protected abstract Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration var1);

    @NotNull
    protected abstract Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration var1);

    @NotNull
    protected abstract Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration var1);

    @NotNull
    protected abstract Renderer getSliderRenderer(@NotNull SliderConfiguration var1);

    @NotNull
    protected abstract Renderer getSliderThumbRenderer(@NotNull SliderConfiguration var1);

    @NotNull
    protected abstract Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration var1);

    @NotNull
    protected abstract Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration var1);

    @NotNull
    protected abstract Renderer getGradientRenderer(@NotNull GradientConfiguration var1);

    @Nullable
    protected RendererDebugInfo getSegmentedButtonRendererDebugInfo(@NotNull SegmentedButtonConfiguration g, int scaleFactor, int width, int height) {
        return null;
    }

    @Nullable
    protected Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        return null;
    }

    private class SliderPainterImpl
    implements SliderPainter {
        @NotNull
        private final SliderConfiguration sg;
        @Nullable
        private final LayoutInfo layoutInfo;
        @NotNull
        private final Rectangle2D bounds;
        @NotNull
        private final Painter p;
        private final double thumbPosition;
        @Nullable
        private Rectangle2D thumbBounds;
        @Nullable
        private Shape thumbOutline;

        public SliderPainterImpl(@Nullable SliderConfiguration sg, @NotNull LayoutInfo layoutInfo, Rectangle2D bounds, @NotNull double thumbPosition, Painter p) {
            this.sg = sg;
            this.layoutInfo = layoutInfo;
            this.bounds = bounds;
            this.thumbPosition = thumbPosition;
            this.p = p;
        }

        @Override
        @NotNull
        public Rectangle2D getThumbBounds() {
            if (this.thumbBounds == null) {
                this.thumbBounds = AquaUIPainterAbstractBase.uiLayout.getSliderThumbBounds(this.bounds, this.sg, this.thumbPosition);
            }
            return this.thumbBounds;
        }

        @Override
        @NotNull
        public Shape getThumbOutline() {
            if (this.thumbOutline == null) {
                SliderThumbLayoutConfiguration tg = new SliderThumbLayoutConfiguration(this.sg, this.thumbPosition);
                this.thumbOutline = AquaUIPainterBase.this.getOutline(this.bounds, tg);
            }
            return this.thumbOutline;
        }

        @Override
        public double getThumbPosition(int x, int y) {
            return AquaUIPainterAbstractBase.uiLayout.getSliderThumbPosition(this.bounds, this.sg, x, y);
        }

        @Override
        @NotNull
        public Rectangle2D getLabelBounds(double value, @NotNull Dimension size) {
            return AquaUIPainterAbstractBase.uiLayout.getSliderLabelBounds(this.bounds, this.sg, value, size);
        }

        @Override
        public float getFixedWidth() {
            return this.layoutInfo != null ? this.layoutInfo.getFixedVisualWidth() : 0.0f;
        }

        @Override
        public float getFixedHeight() {
            return this.layoutInfo != null ? this.layoutInfo.getFixedVisualHeight() : 0.0f;
        }

        @Override
        public void paint(@NotNull Graphics g, float x, float y) {
            this.p.paint(g, x, y);
        }
    }
}

