/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.impl.SliderCircularIndicatorPainter;
import org.violetlib.jnr.aqua.impl.SliderCircularTickPainter;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;

public class CircularSliderPainterExtension
implements PainterExtension {
    @NotNull
    protected final SliderConfiguration sg;
    protected Color TICK_COLOR = new Color(10, 10, 10, 110);

    public CircularSliderPainterExtension(@NotNull SliderConfiguration g) {
        this.sg = g;
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        AquaUIPainter.SliderWidget sw = this.sg.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            if (this.sg.hasTickMarks()) {
                this.paintCircularTickMarks(g, width, height);
            }
            this.paintCircularIndicator(g, width, height);
        }
    }

    protected void paintCircularTickMarks(@NotNull Graphics2D g, float width, float height) {
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        int tickCount = this.sg.getNumberOfTickMarks();
        double p0 = tickCount > 1 ? 0.0 : 0.5;
        double p1 = tickCount > 1 ? 1.0 : 0.5;
        double zeroAngle = 1.5707963267948966;
        float radius = JNRUtils.size2D(this.sg.getSize(), 15.5f, 10.5f, 10.5f);
        SliderCircularTickPainter p = new SliderCircularTickPainter(this.TICK_COLOR, 1.0, 1.0, x, y, radius, zeroAngle, tickCount, p0, p1);
        p.paint(g);
    }

    protected void paintCircularIndicator(@NotNull Graphics2D g, float width, float height) {
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        double zeroAngle = 1.5707963267948966;
        double thumbPosition = this.sg.getValue();
        float radius = JNRUtils.size2D(this.sg.getSize(), 7.5f, 3.5f, 3.5f);
        SliderCircularIndicatorPainter p = new SliderCircularIndicatorPainter(x, y, radius, zeroAngle, thumbPosition);
        p.paint(g);
    }
}

