/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.YosemiteLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class ElCapitanLayoutInfo
extends YosemiteLayoutInfo {
    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellLayoutConfiguration tg = new ToolBarItemWellLayoutConfiguration();
            return this.getToolBarItemWellLayoutInfo(tg);
        }
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 14, 12, 10), JNRUtils.size(sz, 14, 12, 10));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 16, 14, 10), JNRUtils.size(sz, 16, 14, 10));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 19, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 18, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return BasicLayoutInfo.createFixedHeight(17.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 22, 18, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 24, 20, 17));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 20, 17, 14), JNRUtils.size(sz, 21, 18, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return BasicLayoutInfo.createFixed(18.0f, 18.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 18, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 23, 20, 17), JNRUtils.size(sz, 23, 20, 17));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return BasicLayoutInfo.createFixed(9.0f, 9.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 19, 17, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return BasicLayoutInfo.createMinimum(44.0f, 23.0f);
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        float top = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        float right = 0.0f;
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            top = JNRUtils.size(sz, 1, 2, 1);
            bottom = JNRUtils.size(sz, 2, 2, 2);
            right = left = (float)JNRUtils.size(sz, 4, 4, 3);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            top = 1.0f;
            bottom = 1.0f;
            left = 1.0f;
            right = 1.0f;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            top = JNRUtils.size(sz, 1, 2, 1);
            bottom = JNRUtils.size(sz, 2, 2, 2);
            right = left = (float)JNRUtils.size(sz, 4, 4, 3);
        } else {
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
                top = 1.0f;
                bottom = 1.0f;
                left = 1.0f;
                right = 1.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
                bottom = 1.0f;
                top = 1.0f;
                left = right = (float)JNRUtils.size(sz, 4, 3, 3);
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                top = 2.0f;
                bottom = 2.0f;
                left = right = (float)JNRUtils.size(sz, 6, 5, 5);
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
                bottom = 1.0f;
                top = 1.0f;
                right = 4.0f;
                left = 4.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
                top = 0.51f;
                bottom = 1.49f;
                right = 3.0f;
                left = 3.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
                left = right = JNRUtils.size2D(sz, 4.0f, 3.5f, 3.0f);
                top = right;
                bottom = top + 1.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
                right = 3.0f;
                left = 3.0f;
                bottom = top = 3.5f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
                left = right = JNRUtils.size2D(sz, 3.5f, 3.0f, 2.5f);
                top = right;
                bottom = top + 1.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TOOLBAR) {
                top = bottom = JNRUtils.size2D(sz, 4.5f, 4.0f, 3.5f);
                left = right = JNRUtils.size2D(sz, 3.5f, 3.0f, 2.5f);
            } else {
                if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
                    return null;
                }
                if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
                    top = JNRUtils.size(sz, 1, 1, 1);
                    bottom = JNRUtils.size(sz, 1, 1, 1);
                    right = left = (float)JNRUtils.size(sz, 7, 6, 6);
                } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
                    top = 2.0f;
                    bottom = 3.0f;
                    right = 4.0f;
                    left = 4.0f;
                } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
                    // empty if block
                }
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        return Insetters.createFixed(top, left, bottom, right, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getSegmentedButtonLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 22, 19, 16));
            }
            case BUTTON_SEGMENTED_INSET: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 22, 18, 15));
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 24, 20, 17));
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 21, 19, 17));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getSegmentedButtonLabelInsets(@NotNull SegmentedButtonLayoutConfiguration g) {
        float left;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Position pos = g.getPosition();
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        float top = 1.0f;
        float bottom = 2.0f;
        float right = left = 1.0f;
        float endAdjust = 3.0f;
        boolean isLeftEnd = pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.ONLY;
        boolean isRightEnd = pos == AquaUIPainter.Position.LAST || pos == AquaUIPainter.Position.ONLY;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: {
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                endAdjust = 0.0f;
                right = 3.0f;
                left = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                bottom = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: {
                top = 0.5f;
                bottom = 1.5f;
                endAdjust = 2.0f;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                top = 0.5f;
                bottom = 1.5f;
                endAdjust = 0.0f;
                right = 3.0f;
                left = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                bottom = 1.0f;
                endAdjust = 0.0f;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (isLeftEnd) {
            left += endAdjust;
        }
        if (isRightEnd) {
            right += endAdjust;
        }
        return Insetters.createFixed(top, left, bottom, right, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getComboBoxLayoutInfo(@NotNull ComboBoxLayoutConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(sz, 14, 11, 11));
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED) {
            float fixedHeight = JNRUtils.size(sz, 22, 18, 15);
            float minWidth = JNRUtils.size(sz, 27, 24, 22);
            return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            float fixedHeight = JNRUtils.size(sz, 24, 20, 17);
            float minWidth = JNRUtils.size(sz, 27, 24, 22);
            return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
        }
        float fixedHeight = JNRUtils.size(sz, 22, 19, 15);
        float minWidth = JNRUtils.size(sz, 27, 24, 22);
        return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
    }

    @Override
    @NotNull
    protected LayoutInfo getPopUpButtonLayoutInfo(@NotNull PopupButtonLayoutConfiguration g) {
        boolean isArrowsOnly;
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        boolean isSquare = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl = isArrowsOnly = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((isSquare || isArrowsOnly) && sz == AquaUIPainter.Size.MINI) {
            sz = AquaUIPainter.Size.SMALL;
        }
        switch (bw) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN: {
                float fixedHeight = JNRUtils.size(sz, 22, 19, 16);
                float minWidth = JNRUtils.size(sz, 25, 24, 20);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_UP_CELL: 
            case BUTTON_POP_DOWN_CELL: {
                return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(sz, 12, 10, 10));
            }
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 23, 20, 17));
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                return BasicLayoutInfo.createFixedHeight(22.0f);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: {
                float fixedHeight = JNRUtils.size(sz, 22, 18, 15);
                float minWidth = JNRUtils.size(sz, 25, 24, 20);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                float fixedHeight = JNRUtils.size(sz, 24, 20, 17);
                float minWidth = JNRUtils.size(sz, 25, 24, 20);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                return BasicLayoutInfo.createFixedHeight(21.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected LayoutInfo getTextFieldLayoutInfo(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (w.isRound() || w.isSearch()) {
            if (w.isToolbar()) {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(g.getSize(), 24, 20, 17));
            }
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(g.getSize(), 22, 19, 17));
        }
        return BasicLayoutInfo.getInstance();
    }
}

