/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;

public class HybridAquaUIPainter
implements AquaUIPainter {
    @NotNull
    protected final AquaUIPainter viewPainter;
    @NotNull
    protected final AquaUIPainter coreUIPainter;
    @Nullable
    protected final AquaUIPainter jrsPainter;
    @NotNull
    private final AquaUILayoutInfo layout;
    private int w;
    private int h;

    public HybridAquaUIPainter(@NotNull AquaUIPainter viewPainter, @NotNull AquaUIPainter coreUIPainter, @Nullable AquaUIPainter jrsPainter) {
        this.viewPainter = viewPainter;
        this.coreUIPainter = coreUIPainter;
        this.jrsPainter = jrsPainter;
        this.layout = viewPainter.getLayoutInfo();
    }

    @Override
    @NotNull
    public HybridAquaUIPainter copy() {
        return new HybridAquaUIPainter(this.viewPainter, this.coreUIPainter, this.jrsPainter);
    }

    @Override
    public void configure(int w, int h) {
        this.w = w;
        this.h = h;
    }

    @Override
    @NotNull
    public Painter getPainter(@NotNull Configuration g) throws UnsupportedOperationException {
        AquaUIPainter p = this.select(g);
        p.configure(this.w, this.h);
        return p.getPainter(g);
    }

    @NotNull
    protected AquaUIPainter select(@NotNull Configuration g) {
        if (g instanceof ButtonConfiguration) {
            ButtonConfiguration bg = (ButtonConfiguration)g;
            AquaUIPainter.ButtonWidget bw = bg.getButtonWidget();
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                return this.viewPainter;
            }
            return this.coreUIPainter;
        }
        if (g instanceof SegmentedButtonConfiguration) {
            return this.coreUIPainter;
        }
        if (g instanceof GradientConfiguration) {
            return this.coreUIPainter;
        }
        if (g instanceof ComboBoxConfiguration) {
            ComboBoxConfiguration bg = (ComboBoxConfiguration)g;
            AquaUIPainter.ComboBoxWidget w = bg.getWidget();
            AquaUIPainter.State st = bg.getState();
            AquaUIPainter.Size sz = bg.getSize();
            if (st == AquaUIPainter.State.DISABLED || st == AquaUIPainter.State.DISABLED_INACTIVE || bg.getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL && sz == AquaUIPainter.Size.MINI) {
                return this.coreUIPainter;
            }
        } else if (g instanceof PopupButtonConfiguration) {
            PopupButtonConfiguration bg = (PopupButtonConfiguration)g;
            if (bg.getLayoutDirection() == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT) {
                return this.coreUIPainter;
            }
            AquaUIPainter.PopupButtonWidget widget = bg.getPopupButtonWidget();
            if (widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED || widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED || widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR || widget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR) {
                return this.coreUIPainter;
            }
        } else if (g instanceof ProgressIndicatorConfiguration) {
            ProgressIndicatorConfiguration bg = (ProgressIndicatorConfiguration)g;
            if (bg.getWidget() == AquaUIPainter.ProgressWidget.BAR && bg.getOrientation() == AquaUIPainter.Orientation.HORIZONTAL) {
                return this.coreUIPainter;
            }
        } else {
            if (g instanceof IndeterminateProgressIndicatorConfiguration) {
                IndeterminateProgressIndicatorConfiguration bg = (IndeterminateProgressIndicatorConfiguration)g;
                return this.coreUIPainter;
            }
            if (g instanceof TextFieldConfiguration) {
                TextFieldConfiguration bg = (TextFieldConfiguration)g;
                AquaUIPainter.TextFieldWidget w = bg.getWidget();
                if (w != AquaUIPainter.TextFieldWidget.TEXT_FIELD && w != AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND) {
                    return this.coreUIPainter;
                }
            } else if (g instanceof SliderConfiguration) {
                SliderConfiguration bg = (SliderConfiguration)g;
                if (!bg.hasTickMarks()) {
                    return this.coreUIPainter;
                }
            } else {
                if (g instanceof TitleBarConfiguration) {
                    return this.coreUIPainter;
                }
                if (g instanceof ScrollBarConfiguration) {
                    return this.coreUIPainter;
                }
            }
        }
        return this.jrsPainter != null ? this.jrsPainter : this.coreUIPainter;
    }

    @Override
    @NotNull
    public AquaUILayoutInfo getLayoutInfo() {
        return this.layout;
    }

    @Override
    @Nullable
    public Shape getOutline(@NotNull LayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getOutline(g);
    }

    @Override
    @NotNull
    public Rectangle2D getComboBoxEditorBounds(@NotNull ComboBoxLayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getComboBoxEditorBounds(g);
    }

    @Override
    @NotNull
    public Rectangle2D getComboBoxIndicatorBounds(@NotNull ComboBoxLayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getComboBoxIndicatorBounds(g);
    }

    @Override
    @NotNull
    public Rectangle2D getPopupButtonContentBounds(@NotNull PopupButtonLayoutConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getPopupButtonContentBounds(g);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderThumbBounds(@NotNull SliderLayoutConfiguration g, double thumbPosition) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderThumbBounds(g, thumbPosition);
    }

    @Override
    public double getSliderThumbPosition(@NotNull SliderLayoutConfiguration g, int x, int y) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderThumbPosition(g, x, y);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull ScrollBarThumbLayoutConfiguration g, boolean useExtent) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getScrollBarThumbPosition(g, useExtent);
    }

    @Override
    public int getScrollBarThumbHit(@NotNull ScrollBarThumbConfiguration g) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getScrollBarThumbHit(g);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderLabelBounds(@NotNull SliderLayoutConfiguration g, double thumbPosition, @NotNull Dimension size) {
        this.viewPainter.configure(this.w, this.h);
        return this.viewPainter.getSliderLabelBounds(g, thumbPosition, size);
    }
}

