/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class LinearSliderRenderer
extends Renderer {
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer trackRenderer;
    @NotNull
    protected final Insetter trackInsets;
    @Nullable
    protected final Renderer tickMarkRenderer;
    @NotNull
    protected final Renderer thumbRenderer;
    @NotNull
    protected final Insetter thumbInsets;

    public LinearSliderRenderer(@NotNull SliderConfiguration g, @NotNull Renderer trackRenderer, @NotNull Insetter trackInsets, @Nullable Renderer tickMarkRenderer, @NotNull Renderer thumbRenderer, @NotNull Insetter thumbInsets) {
        this.g = g;
        this.trackRenderer = trackRenderer;
        this.trackInsets = trackInsets;
        this.tickMarkRenderer = tickMarkRenderer;
        this.thumbRenderer = thumbRenderer;
        this.thumbInsets = thumbInsets;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        float w = compositor.getWidth();
        float h = compositor.getHeight();
        Rectangle2D trackBounds = this.trackInsets.apply2D(w, h);
        Renderer r = Renderer.createOffsetRenderer(this.trackRenderer, trackBounds);
        r.composeTo(compositor);
        if (this.tickMarkRenderer != null) {
            this.tickMarkRenderer.composeTo(compositor);
        }
        Rectangle2D thumbBounds = this.thumbInsets.apply2D(w, h);
        double x = thumbBounds.getX();
        double y = thumbBounds.getY();
        Renderer r2 = Renderer.createOffsetRenderer(this.thumbRenderer, x, y, thumbBounds.getWidth(), thumbBounds.getHeight());
        r2.composeTo(compositor);
    }
}

