/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.impl.PainterExtension;

public class OverlayScrollBarPainterExtension
implements PainterExtension {
    @NotNull
    private final AquaUILayoutInfo uiLayout;
    @NotNull
    private final ScrollBarConfiguration g;
    @NotNull
    private final AquaUIPainter.ScrollBarKnobWidget kw;
    private final boolean isRollover;
    private final Color LIGHT_TRACK = new Color(68, 68, 68, 217);
    private final Color LIGHT_TRACK_BORDER = new Color(63, 63, 63, 217);
    private final Color LIGHT_THUMB = new Color(255, 255, 255, 128);
    private final Color LIGHT_THUMB_BORDER = new Color(0, 0, 0, 26);
    private final Color LIGHT_ROLLOVER_THUMB = new Color(169, 169, 169, 235);
    private final Color LIGHT_ROLLOVER_THUMB_BORDER = new Color(59, 59, 59, 217);
    private final Color DARK_THUMB = new Color(0, 0, 0, 128);
    private final Color DARK_TRACK = new Color(250, 250, 250, 191);
    private final Color DARK_TRACK_BORDER = new Color(220, 220, 220, 200);

    public OverlayScrollBarPainterExtension(@NotNull AquaUILayoutInfo uiLayout, @NotNull ScrollBarConfiguration g) {
        this.uiLayout = uiLayout;
        this.g = g;
        this.kw = g.getKnobWidget();
        this.isRollover = g.getWidget() == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER;
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        boolean isVertical;
        g = (Graphics2D)g.create();
        g.clip(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        boolean bl = isVertical = height > width;
        if (this.isRollover) {
            Rectangle2D.Float r = new Rectangle2D.Float(0.0f, 0.0f, width, height);
            r.setFrameFromCenter(r.getCenterX(), r.getCenterY(), r.getMinX(), r.getMinY());
            g.setColor(this.getTrackBackgroundColor());
            g.fill(r);
            float borderThickness = this.getTrackBorderThickness();
            if (this.kw == AquaUIPainter.ScrollBarKnobWidget.LIGHT) {
                Rectangle2D.Float inner = new Rectangle2D.Float(0.0f, 0.0f, width, height);
                inner.setFrameFromCenter(r.getCenterX(), r.getCenterY(), r.getMinX() + (double)borderThickness, r.getMinY() + (double)borderThickness);
                Rectangle2D border = ((Rectangle2D)r).createIntersection(inner);
                g.setColor(this.getTrackBorderColor());
                g.fill(border);
            } else {
                double o = borderThickness / 2.0f;
                Path2D.Float borderPath = new Path2D.Float();
                if (isVertical) {
                    ((Path2D)borderPath).moveTo(((RectangularShape)r).getX() + o, ((RectangularShape)r).getY() + o);
                    ((Path2D)borderPath).lineTo(((RectangularShape)r).getX() + o, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() - o);
                    ((Path2D)borderPath).moveTo(((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() - o, ((RectangularShape)r).getY() + o);
                    ((Path2D)borderPath).lineTo(((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() - o, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() - o);
                } else {
                    ((Path2D)borderPath).moveTo(((RectangularShape)r).getX() + o, ((RectangularShape)r).getY() + o);
                    ((Path2D)borderPath).lineTo(((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() - o, ((RectangularShape)r).getY() + o);
                    ((Path2D)borderPath).moveTo(((RectangularShape)r).getX() + o, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() - o);
                    ((Path2D)borderPath).lineTo(((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() - o, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() - o);
                }
                g.setColor(this.getTrackBorderColor());
                g.setStroke(new BasicStroke(borderThickness));
                g.draw(borderPath);
            }
        }
        if (this.kw != AquaUIPainter.ScrollBarKnobWidget.NONE) {
            Shape thumbShape = this.createThumbShape(width, height);
            g.setColor(this.getThumbColor());
            g.fill(thumbShape);
            Color thumbBorderColor = this.getThumbBorderColor();
            if (thumbBorderColor != null) {
                float thickness = this.getThumbBorderThickness();
                g.setColor(thumbBorderColor);
                g.setStroke(new BasicStroke(thickness * 1.5f));
                Shape thumbBorderShape = this.createThumbShape(width, height);
                g.clip(thumbShape);
                g.draw(thumbBorderShape);
            }
        }
        g.dispose();
    }

    @NotNull
    protected Shape createThumbShape(float width, float height) {
        boolean isVertical = height > width;
        double leftTop = 3.5;
        double rightBottom = 1.5;
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        Rectangle2D thumbBounds = this.uiLayout.getScrollBarThumbBounds(bounds, this.g);
        if (isVertical) {
            double w = (double)width - leftTop - rightBottom;
            return new RoundRectangle2D.Double(leftTop, thumbBounds.getY(), w, thumbBounds.getHeight(), w, w);
        }
        double h = (double)height - leftTop - rightBottom;
        return new RoundRectangle2D.Double(thumbBounds.getX(), leftTop, thumbBounds.getWidth(), h, h, h);
    }

    @NotNull
    protected Color getTrackBorderColor() {
        switch (this.kw) {
            case LIGHT: {
                return this.LIGHT_TRACK_BORDER;
            }
        }
        return this.DARK_TRACK_BORDER;
    }

    protected float getTrackBorderThickness() {
        switch (this.kw) {
            case LIGHT: {
                return 1.0f;
            }
        }
        return 0.8f;
    }

    protected float getThumbBorderThickness() {
        switch (this.kw) {
            case LIGHT: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    @NotNull
    protected Color getTrackBackgroundColor() {
        switch (this.kw) {
            case LIGHT: {
                return this.LIGHT_TRACK;
            }
        }
        return this.DARK_TRACK;
    }

    @NotNull
    protected Color getThumbColor() {
        switch (this.kw) {
            case LIGHT: {
                return this.isRollover ? this.LIGHT_ROLLOVER_THUMB : this.LIGHT_THUMB;
            }
        }
        return this.DARK_THUMB;
    }

    @Nullable
    protected Color getThumbBorderColor() {
        switch (this.kw) {
            case LIGHT: {
                return this.isRollover ? this.LIGHT_ROLLOVER_THUMB_BORDER : this.LIGHT_THUMB_BORDER;
            }
        }
        return null;
    }
}

