/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainterBase;
import org.violetlib.jnr.impl.PainterExtension;

public class PopUpArrowPainter
extends PopUpArrowPainterBase
implements PainterExtension {
    public PopUpArrowPainter(@NotNull PopupButtonConfiguration g) {
        super(g);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        AquaUIPainter.Size sz = this.gg.getSize();
        double h = sz == AquaUIPainter.Size.REGULAR ? 2.0 : 2.0;
        double w = sz == AquaUIPainter.Size.REGULAR ? 5.0 : 4.0;
        double sep = sz == AquaUIPainter.Size.REGULAR ? 5.0 : 4.0;
        double stroke = sz == AquaUIPainter.Size.REGULAR ? 1.5 : 1.2;
        double hh = 2.0 * h + sep;
        double x1 = ((double)width - w) / 2.0;
        double y1 = ((double)height - hh) / 2.0;
        double x2 = x1 + w / 2.0;
        double y2 = y1 + h;
        double x3 = x1 + w;
        double y4 = y2 + h + sep;
        double y5 = y4 - h;
        Color c = this.getColor();
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(x1, y2);
        ((Path2D)p).lineTo(x2, y1);
        ((Path2D)p).lineTo(x3, y2);
        ((Path2D)p).moveTo(x1, y5);
        ((Path2D)p).lineTo(x2, y4);
        ((Path2D)p).lineTo(x3, y5);
        g.setColor(c);
        g.setStroke(new BasicStroke((float)stroke));
        g.draw(p);
    }
}

